/*
 * resource.h - a definition file resources
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */


struct s_resource {
  char    *vflibcap;       /* vflibcap path */

  char    *s_dpi;          /* dpi */
  int     dpi;

  char    *kpathsea_mode;

  char    *s_paper;        /* paper size */
  int     paper;
  char    *s_orient;       /* orientation */
  int     orient; 

  char    *s_shrink;       /* shrink factor */
  double  shrink; 

  char    *s_mag_max;      /* magnification max */
  double  mag_max;
  char    *s_mag_min;      /* magnification min */
  double  mag_min;

  char    *s_keymap;       /* key assign */
  int     keymap; 

  char    *s_prevwin_w;    /* preview window size */
  int     prevwin_w;
  char    *s_prevwin_h;
  int     prevwin_h;

  char    *s_offset_x;     /* offset */
  double  offset_x; 
  char    *s_offset_y;
  double  offset_y; 

  char    *color_char;     /* character color */
  char    *color_paper;    /* paper color */
  char    *color_frame;    /* paper frame color */

  char *s_visual_text;  
  int   visual_text;
  char *s_visual_eps;  
  int   visual_eps;

  char    *s_draw_eps;     /* EPS figures & Ghostscript */
  int     draw_eps;
  char    *s_eps_style;
  int     eps_style;

  char    *gs_path;
  char    *s_gs_timeout;
  int     gs_timeout;
  char    *temp_dir;

  char    *s_novice;
  int     novice; 

  char    *s_page_cache;   /* page cache size */
  int     page_cache; 

  char    *s_poll;         /* polling interval for user input */
  int     poll;

  /* Message Window Size & Max History */
  char    *s_msg_window_size;
  int     msg_window_size;
  char    *s_msg_history_size;
  int     msg_history_size;

  /* Printer List & Print Command Specs */
  char    *lplist;
  char    *s_debug_lpspec;
  int     debug_lpspec;
  char    *s_print_msg_window_columns;
  char    *s_print_msg_window_rows;
  int     print_msg_window_columns;
  int     print_msg_window_rows;
  char    *s_print_msg_history_size;
  int     print_msg_history_size;
  char    *lpr_spec_dvi;         /* dvi class */
  char    *lpr_page_spec_dvi;
  char    *lpq_spec_dvi;
  char    *lprm_spec_dvi;
  char    *lpr_spec_ps;          /* ps class */
  char    *lpr_page_spec_ps;
  char    *lpq_spec_ps;
  char    *lprm_spec_ps;
  char    *lpr_spec_usr1;        /* usr1 class */
  char    *lpr_page_spec_usr1;
  char    *lpq_spec_usr1;
  char    *lprm_spec_usr1;
  char    *lpr_spec_usr2;        /* usr2 class */
  char    *lpr_page_spec_usr2;
  char    *lpq_spec_usr2;
  char    *lprm_spec_usr2;
};
typedef  struct s_resource  *RESOURCE;

extern int    resource_create(DVI_DEVICE,int,char**,int);
extern void   resource_dispose(RESOURCE);

/*EOF*/

