/*
 * The configuration file for XMDVI
 *   by Hirotsugu Kakugawa
 */  


/**
 ** Program Name & DVI File
 **/
#define PROG_NAME              "xmdvi"
#define PROG_NAME_RESOURCE     "Xmdvi"
#define DVI_FILE_EXTENSION     ".dvi"
#define DEFAULT_PRINTER        "lp"


/** 
 ** Resource Defaults 
 **/

/*
 * Default Paper Size   ("A4", "B5", "LEETER", etc.)
 *   resource name : "paperSize"
 */
#define DEFAULT_PAPER          "A4"

/*
 * Default Paper Orientation   ("Portrait" or "Landscape")
 *   resource name : "orientation"
 */
#define DEFAULT_ORIENTATION    "Portrait"

/*
 * Default shrink factor
 *   resource name : "shrinkFactor"
 */
#define DEFAULT_SHRINK_FACTOR   "6"

/*
 * Default Minimum and Maximum magnification 
 *   resource name : "magnificationMin", magnificationMax"
 * (Note: This magnification is relative to shrink factor.)
 */
#define DEFAULT_MAGNIFICATION_MIN       "0.1"
#define DEFAULT_MAGNIFICATION_MAX       "6.0"

/*
 * Default DPI value ("300", "400", "600", etc.)
 *   resource name : "dpi"
 */
#define DEFAULT_DPI	       "300"

/*
 * Default Device Mode Name for Kpathsea Library ("cx", etc.)
 *   resource name : "kpathsea_mode"
 */
#define DEFAULT_KPATHSEA_MODE   "cx"

/*
 * VFlib
 *   resource name : "vflibcap"
 */
#define DEFAULT_VFLIBCAP       "vflibcap-tex"

/*
 * Paper Color
 *   resource name : "ColorCharacter", "ColorPaper"
 */
#define DEFAULT_PAPER_CHAR_COLOR         "black"
#define DEFAULT_PAPER_PAPER_COLOR        "white"
#define DEFAULT_PAPER_FRAME_COLOR        "black"

/* 
 * Color mode
 *   resourc names:  "visualText", "visualEPS"
 *   (These values has effects on color text and EPS figures.)
 */
#define DEFAULT_VISUAL_TEXT      "RGB"
#define DEFAULT_VISUAL_EPS       "RGB"

/*
 * Preview Window
 *   resource name : "previewWindowWidth", "previewWindowHeight"
 */
#define DEFAULT_PREVWIN_WIDTH     "400"
#define DEFAULT_PREVWIN_HEIGHT    "600"

/*
 * Offset
 *   resource name : "offsetX", "offsetY" (in inch)
 */
#define DEFAULT_OFFSET_X    "1.00"
#define DEFAULT_OFFSET_Y    "1.00"

/*
 * Confirmations for Novice
 *   resource name : "novice"  ("True" or "False")
 */
#define DEFAULT_NOVICE         "True"

/*
 * Polling interval
 *   resource name : "pollingInterval"
 */
#define DEFAULT_POLLING_INTERVAL  "50"

/*
 * Message Window
 *   resource name : "messageWindowSize", "messageMaxHistory"
 */
#define DEFAULT_MESSAGE_WINDOW     "8"   /* displays the last n lines */
#define DEFAULT_MESSAGE_HISTORY   "24"   /* keeps last n message */


/*
 * Drawing PostScript figures by Ghostscript (gs).
 *   resource names : 
 *      "epsStyle", "drawEPSFigures", "gsPath", "gsTimeOut" 
 */
#define DEFAULT_EPS_FIGURE_STYLE    "LaTeX2e/graphics.sty"
#define DEFAULT_DRAW_EPS_FIGS       "True"
#define DEFAULT_GS_PATH             "gs"
/*#define DEFAULT_GS_PATH             "/usr/local/bin/gs"*/
#define DEFAULT_GS_TIMEOUT          "30"   /* in Sec */

/*
 * Default Keymap.
 *   resource name : "keymap"
 * ("emacs" or "vi")
 */
#define DEFAULT_KEYMAP              "emacs"

/*
 * Default Page Cache Size.
 *   resource name : "pageCacheSize"
 */
#define DEFAULT_PAGE_CACHE_SIZE    "4"

/*
 * Temp directory
 *   resource name : "tempDirectory"
 */
#define DEFAULT_TEMP_DIRECTORY     "/var/tmp"

/*
 * Printers
 *   DEFAULT_PRINTER is used if printer list is empty (e.g. when
 *   app defaults specifys empty).
 *   resource name : "lpList"
 */
#define DEFAULT_PRINTER_LIST  "lp:DVI:Default Printer, ps:PS:PostScriptPrinter"

/*
 * Printer Message Window
 *   resource name : "printMessageWindowRows", "printMessageWindowColumns", 
 *       "printMessageMaxHistory"
 */
#define DEFAULT_PRINT_MESSAGE_WINDOW_R   "8"
#define DEFAULT_PRINT_MESSAGE_WINDOW_C  "20"
#define DEFAULT_PRINT_MESSAGE_HISTORY   "24"   /* keeps last n message */

/*
 * Print out commands specifications
 *   resource name : 
 *    "debugPrintSpec", "usePrintThisPage", 
 *    "printFileSpecDVI",   "printThisPageSpecDVI", 
 *    "printQueueSpecDVI",  "printRmQueueSpecDVI", 
 *    "printFileSpecPS",    "printThisPageSpecPS", 
 *    "printQueueSpecPS",   "printRmQueueSpecPS", 
 *    "printFileSpecUSR1",  "printThisPageSpecUSR1", 
 *    "printQueueSpecUSR1", "printRmQueueSpecUSR1", 
 *    "printFileSpecUSR2",  "printThisPageSpecUSR2", 
 *    "printQueueSpecUSR2", "printRmQueueSpecUSR2", 
 */
#define DEFAULT_DEBUG_PRINT_SPEC    "False"

/* DVI */
#define DEFAULT_PRINTFILE_SPEC_DVI     \
        "lpr -d -P%p '%f'"
#define DEFAULT_PRINTPAGE_SPEC_DVI     \
        "dvisepect -i '%f' -o '%t' =%C;  lpr -d -P%p '%t' ; rm -f '%t'"
#define DEFAULT_PRINTQUEUE_SPEC_DVI    \
        "lpq -P%p '%f'"
#define DEFAULT_REMOVE_QUEUE_SPEC_DVI  \
        "lprm -P%p"
/* PS */
#define DEFAULT_PRINTFILE_SPEC_PS      \
        "dvips %t | lpr -P%p"
#define DEFAULT_PRINTPAGE_SPEC_PS      \
        "dviselect -i '%f' -o %t =%C; (cd %d; dvips %t | lpr -P%p); rm %t"
#define DEFAULT_PRINTQUEUE_SPEC_PS     \
        "lpq -P%p"
#define DEFAULT_REMOVE_QUEUE_SPEC_PS   \
        "lprm -P%p"
/* USR1 */
#define DEFAULT_PRINTFILE_SPEC_USR1    \
        "dvips %t | rsh foo.bar.baz lpr -P%p"
#define DEFAULT_PRINTPAGE_SPEC_USR1    \
        "dviselect -i '%f' -o %t =%C; (cd %d; dvips %t | rsh foo.bar.baz lpr -P%p); rm %t"
#define DEFAULT_PRINTQUEUE_SPEC_USR1   \
        "rsh foo.bar.baz lpq -P%p"
#define DEFAULT_REMOVE_QUEUE_SPEC_USR1 \
        "rsh foo.bar.baz lprm -P%p"
/* USR2 */
#define DEFAULT_PRINTFILE_SPEC_USR2    \
        "lpr -d -P%p '%f'"
#define DEFAULT_PRINTPAGE_SPEC_USR2    \
        "dvisepect -i '%f' -o '%t' =%C;  lpr -d -P%p '%t' ; rm -f '%t'"
#define DEFAULT_PRINTQUEUE_SPEC_USR2   \
        "lpq -P%p"
#define DEFAULT_REMOVE_QUEUE_SPEC_USR2 \
        "lprm -P%p"


/*EOF*/
