/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif
#include <ctype.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "libdvi29.h"
#include "defs.h"
#include "xgdvi.h"
#include "files.h"
#include "gui.h"
#include "lprconf.h"
#include "lprspec.h"
#include "strstream.h"

#define WIDTH    450
#define HEIGHT   150



#define MINIMUM(x,y)  ((x) < (y)) ? (x) : (y)
#define MAXIMUM(x,y)  ((x) < (y)) ? (y) : (x)


#define LPR_ACT_PRINT_NONE      0
#define LPR_ACT_PRINT_DOC       1
#define LPR_ACT_PRINT_CURRENT   2
#define LPR_ACT_PRINT_PAGE_1    3
#define LPR_ACT_PRINT_PAGE_5    4
#define LPR_ACT_PRINT_PAGE_20   5



static int        PrinterShown = 0;
static GtkWidget *Printer      = NULL;

static GtkWidget **LprLabels      = NULL;
static GtkWidget  *LprMessageText = NULL;
static GtkWidget  *ScrolledWindow = NULL;
static GtkWidget  *prButtonAbort  = NULL;

static int  debug_lpr_command = 0;



static void
on_destry                              (GtkObject      *obj,
                                        gpointer        user_data);

void
on_prButtonDoc_clicked                 (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonPage_clicked                (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonPage1_clicked               (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonPage5_clicked               (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonPage20_clicked              (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonAbort_clicked               (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonJobs_clicked                (GtkButton      *button,
                                        GtkWidget      *menu);
void
on_prButtonRemove_clicked              (GtkButton      *button,
                                        GtkWidget      *menu);

void
on_prButtonClear_clicked               (GtkButton      *button,
                                        gpointer        user_data);
void
on_prButtonCancel_clicked              (GtkButton      *button,
                                        gpointer        user_data);




GtkWidget*
create_Printer ()
{
  GtkWidget *dialog_vbox;
  GtkWidget *separator;
  GtkWidget *achbox;
  GtkWidget *frame1;
  GtkWidget *frame2;
  GtkWidget *frame3;
  GtkWidget *frame4;
  GtkWidget *hbox1;
  GtkWidget *hbox21;
  GtkWidget *hbox22;
  GtkWidget *hbox3;
  GtkWidget *vbox2;
  GtkWidget *vbox4;
  GtkWidget *mhbbox;
  GtkWidget *LprOptMenu;
  GtkWidget *PrinterMenu;
  GtkWidget *prButtonDoc;
  GtkWidget *prButtonPage;
  GtkWidget *prButtonPage1;
  GtkWidget *prButtonPage5;
  GtkWidget *prButtonPage20;
  GtkWidget *prButtonJobs;
  GtkWidget *prButtonRemove;
  GtkWidget *prButtonClear;
  GtkWidget *prButtonCancel;
  int  i, n;

  if (getenv("XGDVI_DEBUG_LPR") != NULL)
    debug_lpr_command = 1;

  lprconf_read(XGDVI_CONFIG_DIR, _("PrintSpec16"));
	       
  Printer = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_container_set_border_width (GTK_CONTAINER (Printer), 10);
  gtk_window_set_title (GTK_WINDOW (Printer), _("xgdvi: Print Document"));
  gtk_object_set_data (GTK_OBJECT (xgdvi), "Printer", Printer);
#if 1
  gtk_widget_set_events(Printer, GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(Printer), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
#endif
  gtk_signal_connect (GTK_OBJECT (Printer), "destroy",
		      GTK_SIGNAL_FUNC(on_destry), NULL);
  gtk_signal_connect (GTK_OBJECT (Printer), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

  dialog_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (Printer), dialog_vbox);
  gtk_widget_show (dialog_vbox);

  frame1 = gtk_frame_new (_("Printer Selection"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame1, FALSE, TRUE, 5);
  gtk_widget_show (frame1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), hbox1);
  gtk_container_border_width (GTK_CONTAINER (hbox1), 5);
  gtk_widget_show (hbox1);

  LprOptMenu = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (hbox1), LprOptMenu, TRUE, TRUE, 5);
  gtk_widget_show (LprOptMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), LprOptMenu,
    (gchar*) _("Select a printer to print DVI files."),
    (gchar*) NULL);

  PrinterMenu = gtk_menu_new ();
  n = lprconf_nlprs();
  LprLabels = (GtkWidget**)calloc(sizeof(GtkWidget*), n+1);
  if (LprLabels == NULL){
    fprintf(stderr, _("No memory\n"));
    exit(1);
  }
  for (i = 0; i < n; i++){
    LprLabels[i] = gtk_menu_item_new_with_label (lprconf_get_lpr_name(i));
    gtk_widget_show (LprLabels[i]);
    gtk_menu_append (GTK_MENU (PrinterMenu), LprLabels[i]);
  }
  LprLabels[i] = NULL;
  gtk_option_menu_set_menu (GTK_OPTION_MENU (LprOptMenu), PrinterMenu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (LprOptMenu), 0);

  frame2 = gtk_frame_new (_("Print Commands"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame2, FALSE, TRUE, 5);
  gtk_widget_show (frame2);

  vbox2 = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame2), vbox2);
  gtk_widget_show (vbox2);

  hbox21 = gtk_hbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox21);
  gtk_widget_show (hbox21);

  prButtonDoc = gtk_button_new_with_label (_("Print Document"));
  gtk_widget_show (prButtonDoc);
  gtk_box_pack_start (GTK_BOX (hbox21), prButtonDoc, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonDoc), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonDoc), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonDoc_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonDoc,
    (gchar*) _("Print all pages of the document."),
    (gchar*) NULL);

  prButtonPage = gtk_button_new_with_label (_("Print Current Page"));
  gtk_widget_show (prButtonPage);
  gtk_box_pack_start (GTK_BOX (hbox21), prButtonPage, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonPage), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonPage), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonPage_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonPage,
    (gchar*) _("Print the current page of the document."),
    (gchar*) NULL);

  hbox22 = gtk_hbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox22);
  gtk_widget_show (hbox22);

  prButtonPage1 = gtk_button_new_with_label (_("Print 1 Page"));
  gtk_widget_show (prButtonPage1);
  gtk_box_pack_start (GTK_BOX (hbox22), prButtonPage1, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonPage1), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonPage1), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonPage1_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonPage1,
    (gchar*) _("Print one page of the document."),
    (gchar*) NULL);

  prButtonPage5 = gtk_button_new_with_label (_("Print 5 Pages"));
  gtk_widget_show (prButtonPage5);
  gtk_box_pack_start (GTK_BOX (hbox22), prButtonPage5, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonPage5), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonPage5), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonPage5_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonPage5,
    (gchar*) _("Print 5 pages of the document."),
    (gchar*) NULL);

  prButtonPage20 = gtk_button_new_with_label (_("Print 20 Pages"));
  gtk_widget_show (prButtonPage20);
  gtk_box_pack_start (GTK_BOX (hbox22), prButtonPage20, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonPage20), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonPage20), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonPage20_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonPage20,
    (gchar*) _("Print 20 pages of the document."),
    (gchar*) NULL);

  frame3 = gtk_frame_new (_("Print Job Control Commands"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame3, FALSE, TRUE, 5);
  gtk_widget_show (frame3);

  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame3), hbox3);
  gtk_widget_show (hbox3);

  prButtonJobs = gtk_button_new_with_label (_("Show Print Jobs"));
  gtk_widget_show (prButtonJobs);
  gtk_box_pack_start (GTK_BOX (hbox3), prButtonJobs, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonJobs), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonJobs), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonJobs_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonJobs,
    (gchar*) _("Check pending print jobs."),
    (gchar*) NULL);

  prButtonRemove = gtk_button_new_with_label (_("Cancel Print Jobs"));
  gtk_widget_show (prButtonRemove);
  gtk_box_pack_start (GTK_BOX (hbox3), prButtonRemove, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonRemove), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonRemove), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonRemove_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonRemove,
    (gchar*) _("Remove all of your pending print jobs."),
    (gchar*) NULL);

  prButtonAbort = gtk_button_new_with_label (_("Abort Command"));
  gtk_widget_show (prButtonAbort);
  gtk_box_pack_start (GTK_BOX (hbox3), prButtonAbort, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (prButtonAbort), 5);
  gtk_signal_connect (GTK_OBJECT (prButtonAbort), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonAbort_clicked),
                      PrinterMenu);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonAbort,
    (gchar*) _("Stop executing print command (if any)."),
    (gchar*) NULL);

  frame4 = gtk_frame_new (_("Print Command Message"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame4, TRUE, TRUE, 5);
  gtk_widget_show (frame4);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (frame4), vbox4);

  ScrolledWindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (vbox4), ScrolledWindow, TRUE, TRUE, 5);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (ScrolledWindow),
				     GTK_CORNER_BOTTOM_RIGHT);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ScrolledWindow),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_ALWAYS);
  gtk_widget_set_usize (ScrolledWindow, WIDTH, HEIGHT);
  gtk_widget_show (ScrolledWindow);
  LprMessageText = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (LprMessageText), FALSE);
  gtk_container_add (GTK_CONTAINER (ScrolledWindow), LprMessageText);
  gtk_widget_show (LprMessageText);
  gtk_text_set_word_wrap(GTK_TEXT(LprMessageText), FALSE);
  gtk_text_set_editable(GTK_TEXT(LprMessageText), FALSE);

  mhbbox = gtk_hbutton_box_new ();
  gtk_widget_show (mhbbox);
  gtk_container_border_width (GTK_CONTAINER (mhbbox), 5);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(mhbbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(mhbbox), 5);
  gtk_box_pack_end (GTK_BOX (vbox4), mhbbox, FALSE, FALSE, 0);

  prButtonClear = gtk_button_new_with_label (_("Clear Message"));
  gtk_widget_show (prButtonClear);
  gtk_box_pack_end (GTK_BOX (mhbbox), prButtonClear, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (prButtonClear), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonClear_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonClear,
    (gchar*) _("Clear the message area."),
    (gchar*) NULL);

  separator = gtk_hseparator_new ();
  gtk_widget_show (separator);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), separator, FALSE, TRUE, 0);

  achbox = gtk_hbutton_box_new ();
  gtk_widget_show (achbox);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(achbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(achbox), 5);
  gtk_box_pack_end (GTK_BOX (dialog_vbox), achbox, FALSE, FALSE, 0);

  prButtonCancel = gtk_button_new_with_label (_("Close"));
  gtk_widget_show (prButtonCancel);
  GTK_WIDGET_SET_FLAGS (prButtonCancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (achbox), prButtonCancel, TRUE, TRUE, 0);
  gtk_widget_grab_default (prButtonCancel);
  gtk_signal_connect (GTK_OBJECT (prButtonCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_prButtonCancel_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), prButtonCancel,
    (gchar*) _("Close the print window."),
    (gchar*) NULL);

  return Printer;
}


static void 
lpr_jump_to_last_message(void)
{
  static GtkAdjustment  *adj = NULL;

  if (adj == NULL){
    adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (ScrolledWindow));
  }
  if (adj != NULL){
    adj->value = MAXIMUM (adj->value, adj->upper - adj->page_size);
    gtk_adjustment_value_changed (adj);
  } 
}

static void
lpr_message(char *msg, int len, int col)
{
  int  c;
    static GdkColor color[] = 
  { { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0xFFFF, 0xFFFF, 0xFFFF },
    { 0, 0xFFFF, 0x0000, 0x0000 },
    { 0, 0x0000, 0xFFFF, 0x0000 },
    { 0, 0x0000, 0x0000, 0xFFFF },
    { 0, 0x0000, 0xFFFF, 0xFFFF },
    { 0, 0xFFFF, 0x0000, 0xFFFF },
    { 0, 0xFFFF, 0xFFFF, 0x0000 } };

  switch (col){
  default:
  case 0:
    c = 0;
    break;
  case 1:
    c = 2;
    break;
  case 2:
    c = 4;
    break;
  }
  gtk_text_set_point(GTK_TEXT (LprMessageText),
		     gtk_text_get_length(GTK_TEXT (LprMessageText)));
  gtk_text_freeze (GTK_TEXT (LprMessageText)); 
  gtk_text_insert (GTK_TEXT (LprMessageText), NULL, &color[c], NULL, msg, len); 
  gtk_text_thaw (GTK_TEXT (LprMessageText));
  lpr_jump_to_last_message();
}



static int   lpr_running_command = 0; 
static FILE *lpr_pipe_fp         = NULL; 
static int   lpr_handler_id      = -1; 


static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data)
{
  PrinterShown = 0;
  Printer = create_Printer ();
}


void
on_Print_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  if (PrinterShown == 0){
    PrinterShown = 1;
    gtk_widget_show (Printer);
    if (lpr_running_command == 0)
      gtk_widget_unmap (prButtonAbort);
  } else {
    PrinterShown = 0;
    gtk_widget_hide (Printer);
  }
}


void
show_Printer(void)
{
  if (PrinterShown == 0){
    PrinterShown = 1;
    gtk_widget_show (Printer);
  }
}

void
hide_Printer(void)
{
  if (PrinterShown == 1){
    PrinterShown = 0;
    gtk_widget_hide (Printer);
  }
}



void
lpr_abort_command()
{
  char *msg1;
  char *msg2;

  msg1 = _("Command is not running.\n\n");
  msg2 = _("Aborted.\n\n");

  if (lpr_handler_id == -1){
    gdk_beep();
    lpr_message(msg1, strlen(msg1), 1);
    return;
  }

  lpr_running_command = 0;
  gtk_widget_unmap (prButtonAbort);
  gdk_flush();
  if (lpr_pipe_fp != NULL){
    pclose(lpr_pipe_fp);
    lpr_pipe_fp = NULL;
  }
  gdk_input_remove(lpr_handler_id);
  lpr_handler_id = -1;
  lpr_message(msg2, strlen(msg2), 1);
}

void
lpr_message_callback(gpointer data, gint fd, GdkInputCondition cond)
{
  char *msg1;
  char buff[1024];
  int n;

  msg1 = _("Done.\n\n");
  if ((n = read(fd, buff, sizeof(buff))) <= 0){
    lpr_message(msg1, strlen(msg1), 1);
    lpr_running_command = 0;
    gtk_widget_unmap (prButtonAbort);
    gdk_input_remove(lpr_handler_id);
    lpr_handler_id = -1;
    if (lpr_pipe_fp != NULL){
      pclose(lpr_pipe_fp);
      lpr_pipe_fp = NULL;
    }
    return;
  }

  lpr_message(buff, n, 0);
}


static void
lpr_run_command(char *spec, int act, char *job)
{
  str_stream     *z;
  char  *msg1, *msg2, *msgx;
  char  *cmd, *cmd2, *cmd0;
  int    p, np, rb, re, mv, ap;
  char  *f; 

  msg1 = _("Running: ");
  msg2 = _("Error. Failed to run command.\n\n");
  msgx = _("(Debugging mode. Do not run commands.)\n\n");

  if (lpr_running_command == 1){
    gdk_beep();
    return;
  }

  mv = 0;
  if (dvi == NULL){
    p = 0;
    np = 0;
    ap = 0; 
    rb = re = 0; 
  } else {
    p = page;
    np = dvi->pages;
    switch (act){
    default:
    case LPR_ACT_PRINT_NONE:      ap = 0; rb = 0; re = 0;    mv = 0; break;
    case LPR_ACT_PRINT_DOC:       ap = 1; rb = 1; re = np;   mv = 0; break;
    case LPR_ACT_PRINT_CURRENT:   ap = 0; rb = p; re = p;    mv = 0; break;
    case LPR_ACT_PRINT_PAGE_1:    ap = 0; rb = p; re = p;    mv = 1; break;
    case LPR_ACT_PRINT_PAGE_5:    ap = 0; rb = p; re = p+4;  mv = 1; break;
    case LPR_ACT_PRINT_PAGE_20:   ap = 0; rb = p; re = p+19; mv = 1; break;
    }
    if (re > np)
      re = np;
  }
  if ((f = dvi_file) == NULL)
    f = "";
 
  if ((cmd0 = lprspec(dvi, spec, f, ap, p, rb, re, 
		      p, np, paper, orient)) == NULL)
    return;

  cmd = cmd0;

  while (isspace(*cmd)){
    if (*cmd == '\0'){
      free(cmd0);
      return;
    }
    cmd++;
  }

  if (job != NULL)
    lpr_message(job, strlen(job), 1);
  if (*cmd != '@'){
    lpr_message(msg1, strlen(msg1), 2);
    lpr_message(cmd,  strlen(cmd), 2);
    lpr_message("\n", 1, 2);
  } 
  if (*cmd == '@'){
    cmd++;
  }

  if (debug_lpr_command == 1){
    printf("%s%s\n", msg1, cmd);
    lpr_message(msgx, strlen(msgx), 1);
    free(cmd0);
    return;
  }

  if ((z = str_stream_open()) == NULL){
    free(cmd0);
    return;
  }
  str_stream_add(z, "( ");
  str_stream_add(z, cmd);
  str_stream_add(z, " ) 2>&1;");
  if ((cmd2 = str_stream_compose_and_close(z)) == NULL){
    free(cmd0);
    return;
  }

#if 0
  printf("%s\n", cmd2);
#else
#ifdef HAVE_PIPE
  if ((lpr_pipe_fp = popen(cmd2, "r")) == NULL){
    lpr_message(msg2, strlen(msg2), 1);
  } else {
    lpr_running_command = 1;
    gtk_widget_map (prButtonAbort);
    lpr_handler_id = gdk_input_add(fileno(lpr_pipe_fp), GDK_INPUT_READ, 
				   lpr_message_callback, NULL);
  }
#else
  lpr_pipe_fp = NULL;
  lpr_running_command = 1;
  gtk_widget_map (prButtonAbort);
  if (system(cmd2) < 0)
    lpr_message(msg2, strlen(msg2), 1);
  lpr_running_command = 0;
  gtk_widget_unmap (prButtonAbort);
  lpr_handler_id = -1;
#endif
#endif

  if ((mv == 1) && (rb > 0) && (re > 0)){
    if (re+1 < dvi->pages)
      goto_page(re+1); 
    else
      goto_page(dvi->pages); 
    draw_page();
  }

  free(cmd0);
  free(cmd2);
}

static int 
lpr_find_spec_number(GtkWidget *menu)
{
  GtkWidget  *m;
  int    i;

  m = gtk_menu_get_active (GTK_MENU (menu));
  for (i = 0; LprLabels[i] != NULL; i++){
    if (LprLabels[i] == m){
      return i;
    }
  }
  return 0;
}


void
on_prButtonDoc_clicked                 (GtkButton       *button,
                                        GtkWidget       *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_doc(i);
  lpr_run_command(spec, LPR_ACT_PRINT_DOC,
		  _("Printing a document.\n"));
}

void
on_prButtonPage_clicked                (GtkButton       *button,
                                        GtkWidget       *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_page(i);
  lpr_run_command(spec, LPR_ACT_PRINT_CURRENT,
		  _("Printing current page.\n"));
}


void
on_prButtonPage1_clicked               (GtkButton      *button,
                                        GtkWidget      *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_page(i);
  lpr_run_command(spec, LPR_ACT_PRINT_PAGE_1,
		  _("Printing one page.\n"));
}

void
on_prButtonPage5_clicked               (GtkButton      *button,
                                        GtkWidget      *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_page(i);
  lpr_run_command(spec, LPR_ACT_PRINT_PAGE_5,
		  _("Printing 5 pages.\n"));
}

void
on_prButtonPage20_clicked              (GtkButton      *button,
                                        GtkWidget      *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_page(i);
  lpr_run_command(spec, LPR_ACT_PRINT_PAGE_20,
		  _("Printing 20 pages.\n"));
}

void
on_prButtonAbort_clicked               (GtkButton       *button,
                                        GtkWidget       *menu)
{
  lpr_abort_command();
}


void
on_prButtonJobs_clicked                (GtkButton       *button,
                                        GtkWidget       *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_queue(i);
  lpr_run_command(spec, LPR_ACT_PRINT_NONE,
		  _("Listing print jobs.\n"));
}


void
on_prButtonRemove_clicked              (GtkButton       *button,
                                        GtkWidget       *menu)
{
  char  *spec;
  int    i;

  if (dvi == NULL)
    return;

  i = lpr_find_spec_number(menu);
  spec = lprconf_get_spec_cancel(i);
  lpr_run_command(spec, LPR_ACT_PRINT_NONE,
		  _("Canceling print jobs.\n"));
}


void
on_prButtonClear_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_text_set_point(GTK_TEXT (LprMessageText), 0);
  gtk_text_freeze (GTK_TEXT (LprMessageText));
  gtk_text_forward_delete(GTK_TEXT (LprMessageText), 
			  gtk_text_get_length(GTK_TEXT (LprMessageText)));
  gtk_text_thaw (GTK_TEXT (LprMessageText));
}


void
on_prButtonCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  if (PrinterShown == 1){
    PrinterShown = 0;
    gtk_widget_hide (Printer);
  }
}
