/*
 * special.c - a module for 'special' DVI instruction
 * by Hirotsugu Kakugawa
 *
 * 2 June 1997  Improved to make extensions easy.
 *
 */
/*
 * Copyright (C) 1996-1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This file is part of the DVIlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_MALLOC_H
#  include <malloc.h>
#endif
#if defined(HAVE_STRING_H)
#  include  <string.h>
#endif
#if defined(HAVE_STRINGS_H)
#  include  <strings.h>
#endif
#include <ctype.h>
#include <sys/errno.h>
#include <sys/param.h>
#include <sys/signal.h>

#ifdef HAVE_FCNTL_H
#  include <fcntl.h>
#endif
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef HAVE_SELECT
#  include <sys/types.h>
#  include <sys/socket.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#  include <sys/wait.h>
#endif

#include "libdvi29.h"
#include "defs.h"
#include "cache.h"
#include "private.h"
#include "special.h"
#include "spc_ps.h"
#include "spc_col.h"


Private int  do_special(DVI,DVI_DEVICE,char*,long,long,int);



Public int 
dvi_do_special(DVI dvi, DVI_DEVICE dev, char* cmd, long x, long y)
{
  return do_special(dvi, dev, cmd, x, y, 1);
}

Public int 
dvi_special(DVI dvi, DVI_DEVICE dev, char* cmd, long x, long y)
{
  return do_special(dvi, dev, cmd, x, y, 0);
}


Private int 
do_special(DVI dvi, DVI_DEVICE dev, char* cmd, 
	   long x, long y, int ps_hook)
{
  int    res, ps, bps;
  int    (*special_func)(DVI,DVI_DEVICE,char*,long,long);

  if (DEV_METHOD_DEF(dev,special_command_hook))
    DEV_CALL(dev,special_command_hook)(dev, dvi, cmd, x, y);

  while (isspace((int)*cmd))
    cmd++;

  ps = 0;
  special_func = NULL;
  if (strncmp(cmd, "postscriptbox", 13) == 0){
    ps = 1;
    special_func = dvi_special_postscriptbox;
  } else if (strncmp(cmd, "PSfile=", 7) == 0){
    ps = 1;
    special_func = dvi_special_PSfile;
  } else if (strncmp(cmd, "epsfile=", 8) == 0){
    ps = 1;
    special_func = dvi_special_epsfile;
  } else if (strncmp(cmd, "ps:", 3) == 0){
    special_func = dvi_special_ps;
  } else if (strncmp(cmd, "color", 5) == 0){
    special_func = dvi_special_color;
  } else if (strncmp(cmd, "background", 10) == 0){
    special_func = dvi_special_bgcolor;
  } else if (strncmp(cmd, "textcolor:", 10) == 0){
    special_func = dvi_special_textcolor;
  } else if (strncmp(cmd, "pdf: /C", 7) == 0){
    special_func = dvi_special_color_pdftex;
  } else if (strncmp(cmd, "pdf: /BG", 8) == 0){
    special_func = dvi_special_bgcolor_pdftex;
  } else if (strncmp(cmd, "landscape", 9) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "papersize", 9) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "header", 6) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "xtex:", 5) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "em:", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "html:", 5) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "Warning", 7) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "warning", 7) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "pn ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "pa ", 3) == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "wh") == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "bk") == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "fp") == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "ip ") == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "ia ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "pa ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "da ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "dt ", 3) == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "sp") == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "sp ", 3) == 0){
    special_func = NULL;
  } else if (strcmp(cmd, "sh") == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "sh ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "ar ", 3) == 0){
    special_func = NULL;
  } else if (strncmp(cmd, "tx ", 3) == 0){
    special_func = NULL;
  }

  res = -1;
  bps = 1;
  if (special_func != NULL){
    if ((ps_hook == 1) && (ps == 1))
      bps = DEV_CALL(dev,before_ps_figure)(dev, dvi, cmd,
					   x, y, PD(dvi,special_pos));
    if ((bps == 1) && !PROP_TEST(dvi, DVI_PROP_SKIP_SPECIALS))
      res = (*special_func)(dvi, dev, cmd, x, y);
    if ((ps_hook == 1) && (ps == 1))
      DEV_CALL(dev,after_ps_figure)(dev, dvi, cmd,
				    x, y, PD(dvi,special_pos));
  } else {
  if (DEV_METHOD_DEF(dev,special_command_undef))
    DEV_CALL(dev,special_command_undef)(dev, dvi, cmd, 
					x, y, PD(dvi,special_pos));
  }
  return res;
}


/*EOF*/
