/***************************************************************************
 *  IProperties.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using NDesk.DBus;
using org.freedesktop.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void PropertiesChangedHandler (Property[] properties);
	public delegate void PropertyFlagsChangedHandler (PropertyFlagInfo[] properties);

	public enum PropertyFlag : uint
	{
		Read = 1,
		Write = 2
	}

	public struct Property
	{
		public uint Id;
		public object Value;
	}

	public struct PropertyDetails
	{
		public uint Id;
		public string Name;
		public string Signature;
		public uint Flags;
	}

	public struct PropertyFlagInfo
	{
		public uint Id;
		public uint Flags;
	}

	[Interface ("org.freedesktop.Telepathy.Properties")]
	public interface IProperties
	{
		event PropertiesChangedHandler PropertiesChanged;
		event PropertyFlagsChangedHandler PropertyFlagsChanged;

		Property[] GetProperties (uint[] properties);
		PropertyDetails[] ListProperties ();
		Property[] Properties { set; }
	}
}
