/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-preferences.h:
 * Preferences Dialog
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_PREFERENCES_H__
#define __TI_DLG_PREFERENCES_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgPreferences TIDlgPreferences;
typedef struct _TIDlgPreferencesClass TIDlgPreferencesClass;

#define TI_TYPE_DLG_PREFERENCES               ti_dlg_preferences_get_type()
#define TI_DLG_PREFERENCES(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_PREFERENCES, TIDlgPreferences))
#define TI_DLG_PREFERENCES_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_PREFERENCES, TIDlgPreferencesClass))
#define TI_IS_DLG_PREFERENCES(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_PREFERENCES))
#define TI_IS_DLG_PREFERENCES_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_PREFERENCES))
#define TI_DLG_PREFERENCES_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_PREFERENCES, TIDlgPreferencesClass))

struct _TIDlgPreferences
{
    GObject parent;
};

struct _TIDlgPreferencesClass
{
    GObjectClass parent;
};

GType ti_dlg_preferences_get_type (void);

TIDlgPreferences *ti_dlg_preferences_new (GtkWindow *parent);

/**
 * Shows the Preferences dialog.
 * It also updates the global preferences accordingly.
 */
void ti_dlg_preferences_run (TIDlgPreferences *dlg_preferences);

#endif
