/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wdg-generic-conn-param.c:
 * Widgets Generic Connection Parameter
 * Used by TIDialogRequestConn ("Request Connection" dialog)
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "ti-wdg-generic-conn-param.h"
#include "ti-wdg-conn-param-priv.h"

#include <stdlib.h>

struct _TIWdgGenericConnParamClass {
    TIWdgConnParamClass parent;
    /* class members */
};

G_DEFINE_TYPE (TIWdgGenericConnParam, ti_wdg_generic_conn_param, TI_TYPE_WDG_CONN_PARAM);

/* Function prototypes */
static GValue* _ti_wdg_generic_conn_param_get_value (TIWdgConnParam* conn_param);

/**
 * Finalizes the object, marking the memory as ready for reuse
 */
static void
ti_wdg_generic_conn_param_finalize (GObject *object)
{
	TIWdgGenericConnParam* generic_conn_param = TI_WDG_GENERIC_CONN_PARAM (object);

    g_free (generic_conn_param->type_sig);

	G_OBJECT_CLASS (ti_wdg_generic_conn_param_parent_class)->finalize (object);
}

/**
 * Class initialization.
 */
static void
ti_wdg_generic_conn_param_class_init (TIWdgGenericConnParamClass* generic_conn_param_class)
{
    TIWdgConnParamClass* conn_param_class = TI_WDG_CONN_PARAM_CLASS (generic_conn_param_class);
	GObjectClass* gobject_class = G_OBJECT_CLASS (generic_conn_param_class);

    conn_param_class->get_value = _ti_wdg_generic_conn_param_get_value;

    gobject_class->finalize = ti_wdg_generic_conn_param_finalize;
}

/**
 * Instance initialization.
 */
static void
ti_wdg_generic_conn_param_init (TIWdgGenericConnParam* generic_conn_param)
{
    generic_conn_param->type_sig = NULL;
}

/**
 * New
 */
TIWdgConnParam*
ti_wdg_generic_conn_param_new (const gchar* name, const gchar* def_val, const gchar* type_sig)
{
    TIWdgGenericConnParam* generic_conn_param;
    TIWdgConnParam* conn_param;

    g_assert (g_str_equal (type_sig, "b") == FALSE);

	generic_conn_param = g_object_new (TI_TYPE_WDG_GENERIC_CONN_PARAM, NULL);
    conn_param = TI_WDG_CONN_PARAM (generic_conn_param);

    _ti_wdg_conn_param_new (conn_param, name);

    // Value
    conn_param->value = gtk_entry_new ();
    gtk_entry_set_text (GTK_ENTRY (conn_param->value), def_val);

    if (g_str_equal (name, "password"))
    {
        gtk_entry_set_visibility (GTK_ENTRY (conn_param->value), FALSE);
    }

    // Type Signarure
    generic_conn_param->type_sig = g_strdup (type_sig);

    return conn_param;
}

/**
 * Get Value
 */
static GValue*
_ti_wdg_generic_conn_param_get_value (TIWdgConnParam* conn_param)
{
    TIWdgGenericConnParam* generic_conn_param = TI_WDG_GENERIC_CONN_PARAM (conn_param);
    GValue* value;
    const gchar* text_value;

    text_value = gtk_entry_get_text (GTK_ENTRY (conn_param->value));


    value = g_new0 (GValue, 1);

    if (g_str_equal (generic_conn_param->type_sig, "s"))
    {
        g_value_init (value, G_TYPE_STRING);
        g_value_set_string (value, text_value);
    }
    else if (g_str_equal (generic_conn_param->type_sig, "n") ||
             g_str_equal (generic_conn_param->type_sig, "i"))
    {
        g_value_init (value, G_TYPE_INT);
        g_value_set_int (value, atoi (text_value));
    }
    else if (g_str_equal (generic_conn_param->type_sig, "q") ||
             g_str_equal (generic_conn_param->type_sig, "u"))
    {
        g_value_init (value, G_TYPE_UINT);
        g_value_set_uint (value, atoi (text_value));
    }
    else
    {
        // TODO: Do the conversion for the other types!
        g_assert_not_reached();
    }

    return value;
}
