/*
 * tcpreen.h - header for tcpreen.cpp
 * $Id: tcpreen.h,v 1.14 2004/06/05 15:15:18 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_TCPREEN_H

# define _TCPREEN_TCPREEN_H
# include <sys/types.h> /* uid_t */

# include "log.h"


enum
{
	tcpreen_normal=0x00,
	tcpreen_numeric=0x01,
	tcpreen_listen_server=0x02,
	tcpreen_listen_client=0x04,
	tcpreen_daemon=0x08,
	tcpreen_verbose=0x20,
	tcpreen_speak=0x28
};


struct bridgeconf
{
	const char *servername, *bridgename, *serverservice, *bridgeservice;
	int serveraf, bridgeaf;
	const DataLogListMaker *logsmaker;
	int mode, maxclients;
	long bytelimit, totalclients;
	uid_t user;
};

int bridge_main (const struct bridgeconf *conf);
#endif

