[manpage_begin nameserv::auto n 0.1]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Name service facility}]
[titledesc {Name service facility, Client Extension}]
[require Tcl 8.4]
[require nameserv::auto [opt 0.1]]
[require nameserv]
[keywords {name service} client restore reconnect automatic]
[see_also nameserv(n)]
[description]

This package sits on top of the regular name service client
([package nameserv]) and provides automatic restoration of a lost
connection, and automatic rebinding of name/data pairs. The latter is
however restricted to names which registered through this package
instead of the regular client.

[para]

It does this by watching for the [term lost-connection] events
generated by [package nameserv] and then trying to reconnect every
[var N] milliseconds (configurable, default is [const 1000], i.e. 1
second).

[para]

An important case to detect and handle is where a registered name was
bound by a different client in the interval between loss and
restoration of the connection.

When that happens an automatic rebinding is not possible anymore for
the specific name/data pair. This package will generate a
[term lost-name] event (tag [term nameserv]) for all such names.

The detail information of these events will be a Tcl dictionary
containing two keys, [const name], and [const data], whose values hold
the information of the lost pair.

[section API]

The package exports three commands, as specified below:

[list_begin definitions]

[call [cmd ::nameserv::auto::bind] [arg name] [arg data]]

This command is identical to [cmd ::nameserv::bind] of package
[package nameserv], except that it remembers the [arg name]/[arg data]
information and rebinds them automatically when a lost connection is
restored.


[call [cmd ::nameserv::auto::cget] [option -option]]

This command returns the currently configured value for the specified
[option -option]. The list of supported options and their meaning can
be found in section [sectref OPTIONS].

[call [cmd ::nameserv::auto::configure]]

In this form the command returns a dictionary of all supported
options, and their current values. The list of supported options and
their meaning can be found in section [sectref OPTIONS].


[call [cmd ::nameserv::auto::configure] [option -option]]

In this form the command is an alias for
"[cmd ::nameserv::auto::cget] [option -option]]".

The list of supported options and their meaning can be found in
section [sectref OPTIONS].


[call [cmd ::nameserv::auto::configure] "[option -option] [arg value]..."]

In this form the command is used to configure one or more of the
supported options. At least one option has to be specified, and each
option is followed by its new value.

The list of supported options and their meaning can be found in
section [sectref OPTIONS].

[list_end]


[section OPTIONS]

The one option supported by the auto-client specifies the time
interval between attempts to restore a lost connection.

It is:

[list_begin options]
[opt_def -delay [arg milliseconds]]

This option specifies the interval to wait between attempts to restore
a lost connection, in milliseconds. The default value is [const 1000],
i.e. one second.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph nameserv] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
