".ds n) tardy",
".TH \\*(n) 1",
".SH NAME",
"\\*(n) \\- a tar post-processor",
".SH SYNOPSIS",
".B \\*(n)",
"[",
".IR option \\&...",
"][",
".IR infile",
"[",
".IR outfile",
"]]",
".br",
".B \\*(n)",
".B -Help",
".br",
".B \\*(n)",
".B -VERSion",
".SH DESCRIPTION",
"The",
".I \\*(n)",
"program is used to manipulate the file headers within",
".IR tar (1)",
"archive files.",
".PP",
"This is useful when preparing sources for Internet archive sites,",
"and you don't want to included details of your development environment",
"in the",
".IR tar (1)",
"file.",
".PP",
"One of the most useful features is the ability to add a prefix to the",
"names of the files within the",
".IR tar (1)",
"file.",
"An example is adding the prefix \".\",",
"for when you have a",
".IR tar (1)",
"file with absolute paths in it,",
"and need to extract the file with relative paths.",
".PP",
"The GNU tar format headers are understood,",
"including extended names.",
".PP",
"If no input file is named,",
"or the special name \"-\" is used,",
"input will be read from the standard input.",
"Similarly,",
"if no output file is named,",
"or the special name \"-\" is used,",
"output will be written to the standard output.",
".SH OPTIONS",
"The following options are understood:",
".TP 8n",
"\\fB\\-Block_Size\\fP \\fInumber\\fP",
"Thsi option many be used to specify the block size, as a multiple of",
"512 bytes.  The default is \\f[CW]-bs=20\\fP resulting in a 10KB block size.",
".TP 8n",
".B -Clean_Meta",
".br",
"This option may be used to",
"ensure that file names do not contain shell meta characters.",
"If any are found, they are replaced by a hyphen (-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B -Clean_Print",
".br",
"This option may be used to",
"ensure that file names only contain printable ascii characters.",
"If any non-printable characters are found,",
"they are replaced by a hyphen (-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B -Clean_Space",
".br",
"This option may be used to",
"ensure that file names contain no white space characters.",
"If any are found, they are replaced by a hyphen (-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B -Clean",
".br",
"This option is a terse way of specifying all of the above 3 options.",
".TP 8n",
".B -DownCase",
".br",
"This option may be used to",
"force file names to be all lower case.",
"Warning: duplicate file names may result.",
".TP 8n",
"\\fB\\-EXclude\\fP \\f[I]pattern\\fP",
"This option may be used to completely remove files from the archive.",
"All files that have a filename patching the given shell filename pattern",
"will be removed.",
"Be caseful with wildcards, they match everything, including shash (/)",
"characters.",
"The exclude pattern is applied before all file-name manipulating patterns.",
".TP 8n",
"\\fB-Group\\fP \\fIarg\\fP",
".br",
"This option may be used to set both",
"the group name and group number fields",
"in the header of every file in the archive file.",
"The argument may be either a string or a number.",
"It is an error if a corresponding entry cannot be found in the",
".I /etc/group",
"file.",
".TP 8n",
"\\fB-Group_NAme\\fP \\fIstring\\fP",
".br",
"This option is used to",
"set the group name field in the header",
"of every file in the archive file.",
"The string may be any arbitrary string,",
"it is not restricted to a known group.",
".TP 8n",
"\\fB-Group_NAme\\fP \\fInumber\\fP",
".br",
"This option is used to",
"set the group name field in the header",
"of every file in the archive file.",
"The number is mapped to a group name through the",
".I /etc/group",
"file.",
"It is an error if a corresponding group cannot be found.",
".TP 8n",
"\\fB-Group_NUmber\\fP \\fIstring\\fP",
".br",
"This option is used to",
"set the group number field in the header",
"of every file in the archive file.",
"The string is mapped to a group number through the",
".I /etc/group",
"file.",
"It is an error if a corresponding group cannot be found.",
".TP 8n",
"\\fB-Group_NUmber\\fP \\fInumber\\fP",
".br",
"This option is used to",
"set the group number field in the header",
"of every file in the archive file.",
"The number may be any arbitrary number,",
"it is not restricted to a known group.",
".so o_help.so",
".TP 8n",
"\\fI\\-Input_ForMaT\\fP \\fIname\\fP",
".RS",
"This option may be used to specify the input format to be used.",
"The input \\fIname\\fPs are",
".TP 8n",
"tar",
"This format understands all of the various \\fItar\\fP(1) formats.",
"This is the default.",
".TP 8n",
"list",
"The input is a text file which contains one file name per line.",
"The named files are read as if they were the input.",
"It is common for \\fIfind\\fP(1) to be used to form the list of file names.",
".PP",
"Any other format name will produce an error.",
".RE",
".TP 8n",
".B -List",
".br",
"Give a terse listing of the file headers on the standard error",
"as they are written to the output.",
".TP 8n",
".B -No_Directories",
".br",
"This option may be used to supress directories",
"from the output.",
"This can be useful when the archive has been created with",
"directories in useless modes.",
".TP 8n",
"\\fB-Mode_Clear\\fP \\fIbits\\fP",
".br",
"This option may be used to",
"set the mode of each file in the archive file.",
"The",
".I bits",
"specified are cleared in the mode.",
"You should use an octal number with a leading zero as the argument;",
"if you omit the leading zero it will be interpreted as decimal.",
"The",
".B -Mode_Set",
"option is applied first,",
"the",
".B -Mode_Clear",
"option is applied specond;",
"if neither is specified the mode of each file is unaltered.",
".TP 8n",
"\\fB-Mode_Set\\fP \\fIbits\\fP",
".br",
"This option may be used to set the",
"mode of each file in the archive file.",
"The",
".I bits",
"specified are set in the mode.",
"You should use an octal number with a leading zero as the argument;",
"if you omit the leading zero it will be interpreted as decimal.",
".TP 8n",
".B -Now",
".br",
"Set the last-time-modified field of the headers to the current time,",
"all files will be giben the same time.",
".TP 8n",
".B -Old_Type",
".br",
"By default,",
"\\*(n) corrects the old normal file",
"type into the modern normal file type.",
"This option requests that old normal file",
"type indicators remain unaltered.",
".TP 8n",
"\\fB\\-Output_ForMaT\\fP \\fIname\\fP",
".RS",
"This option may be used to specify the output format to be used.",
"The output \\fIname\\fPs are",
".TP 8n",
"ustar",
"The format that GNU tar uses.",
"This is the default.",
".TP 8n",
"tar-bsd",
"The format that BSD \\fItar\\fP(1) uses.",
".TP 8n",
"cpio",
"The new \\fIcpio\\fP(1) ASCII format.",
".TP 8n",
"cpio-old-ascii",
"The old \\fIcpio\\fP(1) ASCII format.",
".TP 8n",
"v7",
"The ancient UNIX V7 \\fItar\\fP(1) format.",
".PP",
"Any other format name will produce an error.",
".RE",
".TP 8n",
"\\fB-Prefix\\fP \\fIstring\\fP",
".br",
"This option is used to add a prefix directory name to the",
"name of every file in the archive file.",
".TP 8n",
"\\fB\\-PROgress\\fP",
"This option is used to obtain a progress indicator.",
"Only works in combination with the \\fI\\-\\-ifmt=list\\fP option.",
".TP 8n",
"\\fB-Remove_Prefix\\fP \\fInumber\\fP",
".br",
"This option is used to remove a number of leading directories from",
"the name of every file in the archive file,",
"if present.",
"The prefixes will be removed before any prefix specified by the",
".B -Prefix",
"option is prepended.",
".TP 8n",
"\\fB-Remove_Prefix\\fP \\fIstring\\fP",
".RS",
"This option is used to remove a prefix directory name from",
"the name of every file in the archive file,",
"if present.",
"This option may be given more than once,",
"and as many of the prefixes as appear will be removed.",
"The prefixes will be removed before any prefix specified by the",
".B -Prefix",
"option is prepended.",
".PP",
"This option is potentially ambiguous with the preceeding option, if you",
"wish to remove a leading prefix which looks like a number.  If this is",
"the case, add a slash (\"/\") to the end of the prefix to stop it looking",
"like a number.",
".RE",
".TP 8n",
".B -UpCase",
".br",
"This option may be used to",
"force file names to be all upper case.",
"Warning: duplicate file names may result.",
".TP 8n",
"\\fB-User\\fP \\fIarg\\fP",
".br",
"This option may be used to set both",
"the user name and user number fields",
"in the header of every file in the archive file.",
"The argument may be either a string or a number.",
"It is an error if a corresponding entry cannot be found in the",
".I /etc/passwd",
"file.",
".TP 8n",
"\\fB-User_NAme\\fP \\fIstring\\fP",
".br",
"This option is used to",
"set the user name field in the header of every file in the archive file.",
"The string may be any arbitrary string,",
"it is not restricted to a known user.",
".TP 8n",
"\\fB-User_NAme\\fP \\fInumber\\fP",
".br",
"This option is used to",
"set the user name field in the header of every file in the archive file.",
"The number is mapped to a user name through the",
".I /etc/passwd",
"file.",
"It is an error if a corresponding user cannot be found.",
".TP 8n",
"\\fB-User_NUmber\\fP \\fIstring\\fP",
".br",
"This option is used to",
"set the user number field in the header of",
"every file in the archive file.",
"The string is mapped to a user number through the",
".I /etc/passwd",
"file.",
"It is an error if a corresponding user cannot be found.",
".TP 8n",
"\\fB-User_NUmber\\fP \\fInumber\\fP",
".br",
"This option is used to",
"set the user number field in the header",
"of every file in the archive file.",
"The number may be any arbitrary number,",
"it is not restricted to a known user.",
".TP 8n",
".B -VERSion",
".br",
"Print the version of the",
".I \\*(n)",
"program being executed.",
".so o__rules.so",
".so z_exit.so",
".so z_cr.so",
