//
//      srecord - manipulate eprom load files
//      Copyright (C) 2002, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_FILENAMELIST_H
#define COMMON_TAR_INPUT_FILENAMELIST_H

#include <libtardy/filenamelist.h>
#include <libtardy/tar/input.h>

/**
  * The tar_input_filenamelist class is used to represent a file name
  * list as a source of tar input.
  */
class tar_input_filenamelist:
        public tar_input
{
public:
        /**
          * The destructor.
          */
        virtual ~tar_input_filenamelist();

        /**
          * The constructor.
          */
        tar_input_filenamelist(filenamelist *);

        // see base class for documentation
        int read_data(void *, int);

        // see base class for documentation
        int read_header(tar_header &);

        // see base class for documentation
        const char *filename () const;

private:
        /**
          * The default constructor.  Do not use.
          */
        tar_input_filenamelist();

        /**
          * The copy constructor.  Do not use.
          */
        tar_input_filenamelist(const tar_input_filenamelist &);

        /**
          * The assignment operator.  Do not use.
          */
        tar_input_filenamelist &operator=(const tar_input_filenamelist &);

        /**
          * The source instance variable is used to remember where we
          * are getting out file names from.
          */
        filenamelist *source;

        /**
          * The `singleton' instance variable is used to remember the
          * deeper input source.
          */
        mutable tar_input *singleton;

        /**
          * The `get_singleton' method is used to instantiate the
          * singleton it it is null, by reading the next file name from
          * the file name list and opening it.
          */
        tar_input *get_singleton(void) const;
};

#endif // COMMON_TAR_INPUT_FILENAMELIST_H
