//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2002, 2003, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_FORMAT_H
#define COMMON_TAR_FORMAT_H

#include <libtardy/rcstring.h>

#define TBLOCK 512
#define NAMSIZ 100

//
// The magic field is filled with this if uname and gname are valid.
//
#define TMAGIC          "ustar  "       // 7 chars and a null

//
// The linkflag defines the type of file
//
#define LF_OLDNORMAL    '\0'            // Normal disk file, Unix compat
#define LF_NORMAL       '0'             // Normal disk file
#define LF_LINK         '1'             // Link to previously dumped file
#define LF_SYMLINK      '2'             // Symbolic link
#define LF_CHR          '3'             // Character special file
#define LF_BLK          '4'             // Block special file
#define LF_DIR          '5'             // Directory
#define LF_FIFO         '6'             // FIFO special file
#define LF_CONTIG       '7'             // Contiguous file
#define LF_LONGNAME     'L'             // File is actually long name
                                        // for next file in the archive.
#define LF_LONGLINK     'K'             // File is actually long link
                                        // for next file in the archive.
#define LF_GZIPPED      'z'             // Flags that the next file in the
                                        // archive is gzipped.
// Further link types may be defined later.


class header_ty
{
        public:
        char    name[NAMSIZ];
        char    mode[8];
        char    uid[8];
        char    gid[8];
        char    size[12];
        char    mtime[12];
        char    chksum[8];
        char    linkflag;
        char    linkname[NAMSIZ];
        char    magic[8];
        char    uname[32];
        char    gname[32];
        char    devmajor[8];
        char    devminor[8];

        rcstring name_get();
        void name_set(const rcstring &);
        long mode_get();
        void mode_set(long);
        long uid_get();
        void uid_set(long);
        long gid_get();
        void gid_set(long);
        long size_get();
        void size_set(long);
        long mtime_get();
        void mtime_set(long);
        long chksum_get();
        void chksum_set(long);
        int linkflag_get();
        void linkflag_set(int);
        rcstring linkname_get();
        void linkname_set(const rcstring &);
        rcstring uname_get();
        void uname_set(const rcstring &);
        rcstring gname_get();
        void gname_set(const rcstring &);
        long devmajor_get();
        void devmajor_set(long);
        long devminor_get();
        void devminor_set(long);

        long calculate_checksum();
        void dump();
};

#endif // COMMON_TAR_FORMAT_H
