//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2004, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_FILE_INPUT_STDIN_H
#define COMMON_FILE_INPUT_STDIN_H

#include <libtardy/file/input.h>

/**
  * The file_input_stdin is used to represent input from the process's
  * standard input stream.
  */
class file_input_stdin: public file_input
{
public:
    /**
      * The destructor.
      */
    ~file_input_stdin();

    /**
      * The default constructor.
      */
    file_input_stdin();

    // See base class for documentation.
    virtual int read(void *data, int nbytes) const;

    // See base class for documentation.
    virtual const char *filename() const;

private:
    /**
      * The copy constructor.  Do not use.
      */
    file_input_stdin(const file_input_stdin &);

    /**
      * The assignment operator.  Do not use.
      */
    file_input_stdin &operator = (const file_input_stdin &);
};

#endif // COMMON_FILE_INPUT_STDIN_H
