/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar output cpio oldasciis
 */

#include <ac/stdio.h>

#include <tar/output/cpio/oldascii.h>


tar_output_cpio_oldascii::~tar_output_cpio_oldascii()
{
}


tar_output_cpio_oldascii::tar_output_cpio_oldascii(file_output *arg_fp)
	: tar_output_cpio(arg_fp, 2)
{
}


void
tar_output_cpio_oldascii::write_header(const tar_header &h)
{
	char buffer[78];
	int dev = ((h.device_major & 0xFF) << 8) | (h.device_minor & 0xFF);
	int rdev = ((h.rdevice_major & 0xFF) << 8) | (h.rdevice_minor & 0xFF);
	snprintf
	(
		buffer,
		sizeof(buffer),
		"%06o%06o%06lo%06lo%06lo%06lo%06lo%06o%011lo%06lo%011lo",
		070707,
		dev & 0777777,
		h.inode_number & 0x777777,
		(long)calculate_mode(h) & 07777,
		h.user_id & 0777777,
		h.group_id & 0777777,
		h.link_count & 0777777,
		rdev & 0777777,
		h.mtime & 07777777777,
		(long)h.name.length() + 1,
		h.size
	);
	write_data(buffer, 76);

	write_data(h.name.to_c_string(), h.name.length() + 1);
}


void
tar_output_cpio_oldascii::write_header_padding()
{
	/* no header padding, only data padding */
}


tar_output_cpio_oldascii::tar_output_cpio_oldascii()
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_output_cpio_oldascii::tar_output_cpio_oldascii(const tar_output_cpio_oldascii &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_output_cpio_oldascii &
tar_output_cpio_oldascii::operator = (const tar_output_cpio_oldascii &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
	return *this;
}
