/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include "QtTapioca/HandleFactory"
#include "QtTapioca/Handle"

#include <QDebug>
#include <QList>

namespace QtTapioca {

/*
 * Private Class
 */
class HandleFactoryPrivate {
public:
    HandleFactoryPrivate(org::freedesktop::Telepathy::Connection *conn)
        : telepathyConn(conn)
    {
    }
    ~HandleFactoryPrivate()
    {
    }

    org::freedesktop::Telepathy::Connection *telepathyConn;
};

} // namespace

using namespace QtTapioca;

/*
 * Constructor
 */
HandleFactory::HandleFactory(QObject *connDBusProxy, QObject *parent)
    : QObject(parent)
{
    org::freedesktop::Telepathy::Connection *telepathyConn = qobject_cast<org::freedesktop::Telepathy::Connection *>(connDBusProxy);

    d = new HandleFactoryPrivate(telepathyConn);

    Q_ASSERT(d);
}

/*
 * Destructor
 */
HandleFactory::~HandleFactory()
{
    delete d;
}

/*
 * Create Handle (name)
 */
Handle *HandleFactory::createHandle(uint handleType, const QString &name)
{
    Handle *handle = new Handle(d->telepathyConn, handleType, name, this);
    if (!handle->isValid()) {
        delete handle;
        return NULL;
    }

    return handle;
}

/*
 * Create Handle (ID)
 */
Handle *HandleFactory::createHandle(uint handleType, uint handleId)
{
    Handle *handle = new Handle(d->telepathyConn, handleType, handleId, this);
    if (!handle->isValid()) {
        qDebug() << "error creating handle.";
        delete handle;
        return NULL;
    }
    return handle;
}

