/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2005 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* Module contributed by Nick Robinson <np@bottlehall.co.uk>               */
/* Modified by Tomaz Solc						   */
/* $Id: export_csv.c,v 1.1 2005/01/10 10:19:53 avian Exp $                 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <time.h>
#include <string.h>

#ifdef HAVE_ICONV
#include <iconv.h>
#include <langinfo.h>
#endif

#include "data.h"
#include "xmlsup.h"
#include "gettext.h"

#define BUFFSIZE	256
char buff[BUFFSIZE];

#ifdef HAVE_ICONV
char buff2[BUFFSIZE];

char *get_dayname(int n) {
	struct tm t;
	char *a,*b;
	size_t c, d;
	iconv_t cd;

	cd=iconv_open("UTF-8", nl_langinfo(CODESET));

	t.tm_wday=n%5+1;
	strftime(buff, BUFFSIZE, "%a", &t);

	if(((int) cd)==-1) {
		return(buff);
	}

	a=buff;
	b=buff2;
	c=BUFFSIZE;
	d=BUFFSIZE;

	iconv(cd, &a, &c, &b, &d);

	iconv_close(cd);

	return(buff2);
}
#else
char *get_dayname(int n) {
	struct tm t;

	t.tm_wday=n+1;
	strftime(buff, BUFFSIZE, "%a", &t);

	return(buff);
}
#endif

void output_function(chromo *t, int *cpnt, int *tpnt, char *options, FILE* out, outputext *opnt)
{
	int cid, tid, sid, rid, day, per;
	int n;

	fprintf(out, "\"%s\"\n", school_name);
	fprintf(out, "\"%s\"\n", school_address);
	fprintf(out, "\"%s\"\n", author);
	fprintf(out, "\"Grade\",%d\n", t->grade);
	fprintf(out, 	"\"Class\",\"Day\",\"Period\","
		  	"\"Subject\",\"Teacher\",\"Room\"\n");

	for(n=0;n<tuplenum;n++) {
		day=t->inf[n].time/PERIODS;
		per=t->inf[n].time%PERIODS;
		rid=t->inf[n].room;

		cid=tuplemap[n].cid;
		tid=tuplemap[n].tid;
		sid=tuplemap[n].sid;

		fprintf(out, "\"%d-%s\",\"%s\",%d,\"%s\",\"%s\",\"%s\"\n",
			cmap[cid].year, 
			cmap[cid].name, 
			get_dayname(day), per,
			smap[sid].title, tmap[tid].name, rmap[rid].id);
	}
}
