## sambaBackend.py - contains the backend code for system-config-samba
## Copyright (C) 2002, 2003 Red Hat, Inc.
## Copyright (C) 2002, 2003 Brent Fox <bfox@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See then
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import string
import os
import re

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = 'system-config-samba'
translate.textdomain (domain)

class SambaBackend:

    def nmbIsService (self):
        # Check if nmb is its own service
        s = os.system ('/sbin/chkconfig --list nmb >& /dev/null')
        if s == 0:
            return True
        else:
            return False

    def isSambaRunning (self):
        services = [ ('smb', 'smbd') ]

        if self.nmbIsService ():
            services.append ( ('nmb', 'nmbd') )

        for service, procname in services:
            fd = os.popen ('LC_MESSAGES=C /sbin/service %s status' % service)
            lines = fd.readlines ()
            fd.close ()

            for line in lines:
                if string.find (line, procname) >= 0:
                    if not string.find (line, 'running') > 0:
                        return False

        return True

    def startSamba(self):
        services = ['smb']

        if self.nmbIsService ():
            services.append ('nmb')

        for service in services:
            os.system ('/sbin/service %s start > /dev/null' % service)

    def restartSamba(self):
        services = ['smb']

        if self.nmbIsService ():
            services.append ('nmb')

        for service in services:
            os.system ('/sbin/service %s restart > /dev/null' % service)
