C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE NDLOCF
C                       *****************
C
C      --------------------------------------------------------
     * (NELESF,NDMASF,NBCOUF,NPOINF,NODESF,NCOUPF,
     * NRAPF,NBRAF,NELRAF,NODRAF,ITRAV,
     * NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE,
     * NWNCF1,NWNRF1,NWECF1,NWERF1,NWDMA1)
C      --------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   TRANSFORMATION DE LA TABLE NODESF                       *
C              ON PASSE DE LA NUMEROTAION GLOBALE A LA NUMEROTATION    *
C              LOCALE DES NOEUDS                                       *
C                                                                      *
C        Avant : NODESF(n,1) = num glob du 1er noeuds de l'elt n       *
C        Apres : NODESF(n,1) = num loc couple du 1er noeuds de l'elt n *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NELESF !   E  ! D  ! NOMBRE D'ELTS SURF FLUIDE                   !
C   ! NDMASF !   E  ! D  ! NOMBRE DE NOEUDS DES ELTS SURF FLUIDES      !
C   ! NBCOUF !   E  ! D  ! NOMBRE DE NOEUDS COUPLES FLUIDES            !
C   ! NPOINF !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE FLUIDE  3D     !
C   ! NREFF  !  TE  ! D  ! REFERENCES DES NOEUDS FLUIDES               !
C   ! NODESF !  TE  ! M  ! TABLE DES ELTS DE BORD FLUIDES COUPLES      !
C   ! NCOUPF !  TE  ! D  ! NUMEROS GLOBAUX DES NOEUDS FLUIDES COUPLES  !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C
C.. Variables externes
      INTEGER NELESF,NDMASF,NBCOUF,NPOINF,NBRAF,NELRAF
      INTEGER ITRAV(NPOINF),NODESF(NELESF,NDMASF),NCOUPF(NBCOUF,2)
      INTEGER NRAPF(NBRAF,2),NODRAF(NELRAF,NDMASF)
      INTEGER NBFILS,NWMAIL,NWDN,NWDRN,NWNCF1,NWNRF1
      INTEGER NWDE,NWDRE,NWDMA1,NWECF1,NWERF1
C
C.. Variables internes
      INTEGER N,M
      LOGICAL LVERIF
C
C
C**********************************************************************
C
C     1. MAILLAGE DES NOEUDS FLUIDES COUPLES
C     ======================================
C
C     1.1- INITIALISATIONS
C     --------------------
      LVERIF = .FALSE.
C
      DO 110 N=1,NPOINF
         ITRAV(N) = 0
  110 CONTINUE
C
C     1.2- CREATION DE LA TABLE NUM_GLOG --> NUM_LOC_COUPLE
C     -----------------------------------------------------
      DO 120 N=NWDN,NWDN+NWNCF1-1
         ITRAV(NCOUPF(N,1)) = N
  120 CONTINUE
C
C
C     1.3- TRANSFORMATION DE LA TABLE DES ELEMENTS
C     --------------------------------------------
      DO 130 M=1,NWDMA1
         DO 131 N=NWDE,NWDE+NWECF1-1
           NODESF(N,M) = ITRAV (NODESF(N,M))
  131    CONTINUE
  130 CONTINUE
C
C
C
C     2. MAILLAGE DES NOEUDS FLUIDES NON COUPLES SOUMIS AU RAYT
C     =========================================================
C
C     2.1- INITIALISATIONS
C     --------------------
C
      DO 210 N=1,NPOINF
         ITRAV(N) = 0
  210 CONTINUE
C
C
C     2.2- CREATION DE LA TABLE NUM_GLOG --> NUM_LOC_NON_COUPLE_RAYT
C     --------------------------------------------------------------
      DO 220 N=NWDRN,NWDRN+NWNRF1-1
         ITRAV(NRAPF(N,1)) = N
  220 CONTINUE
C
C
C     2.3- TRANSFORMATION DE LA TABLE DES ELEMENTS
C     --------------------------------------------
      DO 230 M=1,NWDMA1
         DO 231 N=NWDRE,NWDRE+NWERF1-1
           NODRAF(N,M) = ITRAV (NODRAF(N,M))
  231    CONTINUE
  230 CONTINUE
C
C
C-------
C FORMAT
C-------
C
C----
C FIN
C----
C
      RETURN
      END
