C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MADIF3,SSI=0
C
                     SUBROUTINE MADIF3
C                    *****************
C
C     ------------------------------------------------------
     *( XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES DE DIFFUSION     *
C                    PROBLEMES BIDIMENSIONNELS ET TRIDIMENSIONNEL      *
C                    POUR LES CAS ANISOTROPES                          *
C                                                                      *
C        la matrice de conductivite dans le repere globale             *
C        s'exprime donc de la facon suivante :                         *
C                                                                      *
C              | AKXX  AKXY  AKXZ |                                    *
C              | AKYX  AKYY  AKYZ |                                    *
C              | AKZX  AKZY  AKZZ |                                    *
C                                                                      *
C        Cette matrice est toujours symetriques, c'est a dire          *
C        que AKXY = AKYX (il n'esxiste pas de materiaux qui ne         *
C        satisfasse pas cette proprietee.                              *
C        On ne stocke donc que la matrice triangulaire superieure      *
C                                                                      *
C        Les AKXX sont toujours variables en temps et en espace        *
C        il seront donc discretise en iso-P2                           *
C                                                                      *
C                                                                      *
C      Ce sous programme constitue une extension de travaux effectuees *
C      par F. JAUBERTEAU et J.P. GREGOIRE, portant sur l'integration   *
C      analytique des matrices elementaires par les formules de        *
C      Zienkiewicz                                                     *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !   PHYSOL  !  TR  ! D  ! Tableau contenant les propri physiques   !
C   !           !  TR  ! D  !   On utilise uniquement PHYSOL(n,>=3)    !
C   !           !      !    !   contient les valeurs des kii sui isotro!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                      
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : MATELE
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C    
C***********************************************************************
C
C..Variables internes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
      INTEGER NPOUE,NPPEL,NBPHYS
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)  
      DOUBLE PRECISION COEFMA(NPOINS),XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS),VOLUME(NELEMS)    
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C..Variables internes
      DOUBLE PRECISION ZERO,COEFF,S3,S18,S24
      INTEGER I,NCA
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10      
      DOUBLE PRECISION R1,R2,R3
      DOUBLE PRECISION AKXX1,AKXX2,AKXX3,AKXX4,AKXX5,AKXX6
      DOUBLE PRECISION AKXX7,AKXX8,AKXX9,AKXX10
      DOUBLE PRECISION AKYY1,AKYY2,AKYY3,AKYY4,AKYY5,AKYY6
      DOUBLE PRECISION AKYY7,AKYY8,AKYY9,AKYY10
      DOUBLE PRECISION AKZZ1,AKZZ2,AKZZ3,AKZZ4,AKZZ5,AKZZ6
      DOUBLE PRECISION AKZZ7,AKZZ8,AKZZ9,AKZZ10
      DOUBLE PRECISION AKXY1,AKXY2,AKXY3,AKXY4,AKXY5,AKXY6
      DOUBLE PRECISION AKXY7,AKXY8,AKXY9,AKXY10
      DOUBLE PRECISION AKXZ1,AKXZ2,AKXZ3,AKXZ4,AKXZ5,AKXZ6
      DOUBLE PRECISION AKXZ7,AKXZ8,AKXZ9,AKXZ10
      DOUBLE PRECISION AKYZ1,AKYZ2,AKYZ3,AKYZ4,AKYZ5,AKYZ6
      DOUBLE PRECISION AKYZ7,AKYZ8,AKYZ9,AKYZ10
      DOUBLE PRECISION X1K11,X1K12,X1K22,X2K11,X2K12,X2K22
      DOUBLE PRECISION X3K11,X3K12,X3K22,X4K11,X4K12,X4K22
      DOUBLE PRECISION X5K11,X5K12,X5K22,X6K11,X6K12,X6K22
      DOUBLE PRECISION X7K11,X7K12,X7K22,X8K11,X8K12,X8K22
      DOUBLE PRECISION X1K13,X1K23,X1K33,X2K13,X2K23,X2K33
      DOUBLE PRECISION X3K13,X3K23,X3K33,X4K13,X4K23,X4K33
      DOUBLE PRECISION X5K13,X5K23,X5K33,X6K13,X6K23,X6K33
      DOUBLE PRECISION X7K13,X7K23,X7K33,X8K13,X8K23,X8K33
      DOUBLE PRECISION DX1,DX2,DX3,DX4,DY1,DY2,DY3,DY4
      DOUBLE PRECISION DZ1,DZ2,DZ3,DZ4
      DOUBLE PRECISION X75,Y75,Z75,X78,Y78,Z78
      DOUBLE PRECISION X69,Y69,Z69,X65,Y65,Z65
      DOUBLE PRECISION X710,Y710,Z710,X76,Y76,Z76
      DOUBLE PRECISION X810,Y810,Z810,X89,Y89,Z89
      DOUBLE PRECISION AKXXE,AKYYE,AKZZE,AKXYE,AKXZE,AKYZE
C
      LOGICAL LVERIF
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      S3  = 1.D0 / 3.D0
      S18 = 1.D0 / 18.D0
      S24 = 1.D0 / 24.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
C     
C     1- CAS BIDIMENSIONNEL
C     ======================
C        
      IF ( NDIM . EQ . 2 ) THEN
C     
C       1.1 CAS BIDIMENSIONNEL CARTESIEN
C       --------------------------------
C
        IF (IAXISY.EQ.0) THEN    
C
C
          DO 110 I=1,NELEMS
C
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)
C
C
            IF(NDPROP.EQ.1) THEN
              AKXX1 = PHYSOL(N1,1,3)   
              AKXX2 = PHYSOL(N2,1,3)   
              AKXX3 = PHYSOL(N3,1,3)   
              AKXX4 = PHYSOL(N4,1,3)   
              AKXX5 = PHYSOL(N5,1,3)   
              AKXX6 = PHYSOL(N6,1,3)   
C
              AKYY1 = PHYSOL(N1,1,4)   
              AKYY2 = PHYSOL(N2,1,4)   
              AKYY3 = PHYSOL(N3,1,4)   
              AKYY4 = PHYSOL(N4,1,4)   
              AKYY5 = PHYSOL(N5,1,4)   
              AKYY6 = PHYSOL(N6,1,4)   
C
              AKXY1 = PHYSOL(N1,1,5)   
              AKXY2 = PHYSOL(N2,1,5)   
              AKXY3 = PHYSOL(N3,1,5)   
              AKXY4 = PHYSOL(N4,1,5)   
              AKXY5 = PHYSOL(N5,1,5)   
              AKXY6 = PHYSOL(N6,1,5)   
C
           ELSEIF(NDPROP.EQ.2) THEN
              AKXXE = PHYSOL(I,1,3)
              AKYYE = PHYSOL(I,1,4)
              AKXYE = PHYSOL(I,1,5)
C
              AKXX1 = AKXXE
              AKXX2 = AKXXE
              AKXX3 = AKXXE
              AKXX4 = AKXXE
              AKXX5 = AKXXE
              AKXX6 = AKXXE
C
              AKYY1 = AKYYE
              AKYY2 = AKYYE
              AKYY3 = AKYYE
              AKYY4 = AKYYE
              AKYY5 = AKYYE
              AKYY6 = AKYYE
C
              AKXY1 = AKXYE
              AKXY2 = AKXYE
              AKXY3 = AKXYE
              AKXY4 = AKXYE
              AKXY5 = AKXYE
              AKXY6 = AKXYE
C
           ELSE
              AKXX1 = PHYSOL(I,1,3)              
              AKXX2 = PHYSOL(I,2,3)              
              AKXX3 = PHYSOL(I,3,3)              
              AKXX4 = PHYSOL(I,4,3)              
              AKXX5 = PHYSOL(I,5,3)              
              AKXX6 = PHYSOL(I,6,3) 
C
              AKYY1 = PHYSOL(I,1,4)
              AKYY2 = PHYSOL(I,2,4)          
              AKYY3 = PHYSOL(I,3,4)          
              AKYY4 = PHYSOL(I,4,4)          
              AKYY5 = PHYSOL(I,5,4)          
              AKYY6 = PHYSOL(I,6,4)    
C
              AKXY1 = PHYSOL(I,1,5)
              AKXY2 = PHYSOL(I,2,5)
              AKXY3 = PHYSOL(I,3,5)
              AKXY4 = PHYSOL(I,4,5)
              AKXY5 = PHYSOL(I,5,5)
              AKXY6 = PHYSOL(I,6,5)
            ENDIF
C      
C
C
           X1K11 = AKXX1 + AKXX4 + AKXX6
           X1K12 = AKXY1 + AKXY4 + AKXY6
           X1K22 = AKYY1 + AKYY4 + AKYY6
           X2K11 = AKXX2 + AKXX4 + AKXX5
           X2K12 = AKXY2 + AKXY4 + AKXY5
           X2K22 = AKYY2 + AKYY4 + AKYY5
           X3K11 = AKXX3 + AKXX5 + AKXX6
           X3K12 = AKXY3 + AKXY5 + AKXY6
           X3K22 = AKYY3 + AKYY5 + AKYY6
           X4K11 = AKXX4 + AKXX5 + AKXX6
           X4K12 = AKXY4 + AKXY5 + AKXY6
           X4K22 = AKYY4 + AKYY5 + AKYY6
C
C
          DX1 = - (COORDS(N6,2)-COORDS(N4,2))
          DY1 =   (COORDS(N6,1)-COORDS(N4,1))
C
          DX2 = - (COORDS(N4,2)-COORDS(N5,2))
          DY2 =   (COORDS(N4,1)-COORDS(N5,1))
C
          DX3 = - (COORDS(N5,2)-COORDS(N6,2)) 
          DY3 =   (COORDS(N5,1)-COORDS(N6,1))
C
C          Calcul des termes diagonaux
C          ~~~~~~~~~~~~~~~~~~~~~~~~~~~
        COEFF = S3 / VOLUME(I)
C                                                                       
       WCT(I,1) = COEFF*(DX1**2*X1K11+2*DY1*DX1*X1K12+DY1**2*X1K22) 
       WCT(I,2) = COEFF*(DX2**2*X2K11+2*DY2*DX2*X2K12+DY2**2*X2K22) 
       WCT(I,3) = COEFF*(DX3**2*X3K11+2*DY3*DX3*X3K12+DY3**2*X3K22) 
       WCT(I,4) = COEFF*(DX2**2*X1K11+2*DY2*DX2*X1K12+DY2**2*X1K22+DX1**
     &2*X2K11+2*DY1*DX1*X2K12+DY1**2*X2K22+DX3**2*X4K11+2*DY3*DX3*X4K12+
     &DY3**2*X4K22) 
       WCT(I,5) = COEFF*(DX3**2*X2K11+2*DY3*DX3*X2K12+DY3**2*X2K22+DX2**
     &2*X3K11+2*DY2*DX2*X3K12+DY2**2*X3K22+DX1**2*X4K11+2*DY1*DX1*X4K12+
     &DY1**2*X4K22)  
       WCT(I,6) = COEFF*(DX3**2*X1K11+2*DY3*DX3*X1K12+DY3**2*X1K22+DX1**
     &2*X3K11+2*DY1*DX1*X3K12+DY1**2*X3K22+DX2**2*X4K11+2*DY2*DX2*X4K12+
     &DY2**2*X4K22) 
C
C           Calcul des termes extra-diagonaux
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
      XMAT(I,1) = COEFF*(DX1*DX2*X1K11+DY1*DX2*X1K12+DX1*DY2*X1K12+DY1*D
     &Y2*X1K22)
      XMAT(I,2) = COEFF*(DX1*DX3*X1K11+DY1*DX3*X1K12+DX1*DY3*X1K12+DY1*D
     &Y3*X1K22)
C
      XMAT(I,3) = COEFF*(DX2*DX1*X2K11+DY2*DX1*X2K12+DX2*DY1*X2K12+DY2*D
     &Y1*X2K22)
      XMAT(I,4) = COEFF*(DX2*DX3*X2K11+DY2*DX3*X2K12+DX2*DY3*X2K12+DY2*D
     &Y3*X2K22)
C
      XMAT(I,5) = COEFF*(DX3*DX2*X3K11+DY3*DX2*X3K12+DX3*DY2*X3K12+DY3*D
     &Y2*X3K22)
      XMAT(I,6) = COEFF*(DX3*DX1*X3K11+DY3*DX1*X3K12+DX3*DY1*X3K12+DY3*D
     &Y1*X3K22)
C
      XMAT(I,7) = COEFF*(DX1*DX3*X2K11+DY1*DX3*X2K12+DX1*DY3*X2K12+DY1*D
     &Y3*X2K22+DX3*DX1*X4K11+DY3*DX1*X4K12+DX3*DY1*X4K12+DY3*DY1*X4K22)
      XMAT(I,8) = COEFF*(DX2*DX3*X1K11+DY2*DX3*X1K12+DX2*DY3*X1K12+DY2*D
     &Y3*X1K22+DX3*DX2*X4K11+DY3*DX2*X4K12+DX3*DY2*X4K12+DY3*DY2*X4K22)
C
      XMAT(I,9) = COEFF*(DX2*DX1*X3K11+DY2*DX1*X3K12+DX2*DY1*X3K12+DY2*D
     &Y1*X3K22+DX1*DX2*X4K11+DY1*DX2*X4K12+DX1*DY2*X4K12+DY1*DY2*X4K22) 
C
  110     CONTINUE
C
C       1.2- CAS AXISYMETRIQUE (DONC 2D) 
C       --------------------------------
        ELSE    
C
         DO 120 I=1,NELEMS
C
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)
C
          COEFF = S24 / VOLUME(I) 
C
           R1 = COEFF * ABS(COORDS(N1,NCA))
           R2 = COEFF * ABS(COORDS(N2,NCA))
           R3 = COEFF * ABS(COORDS(N3,NCA))
C
            IF(NDPROP.EQ.1) THEN
              AKXX1 = PHYSOL(N1,1,3)   
              AKXX2 = PHYSOL(N2,1,3)   
              AKXX3 = PHYSOL(N3,1,3)   
              AKXX4 = PHYSOL(N4,1,3)   
              AKXX5 = PHYSOL(N5,1,3)   
              AKXX6 = PHYSOL(N6,1,3)   
C
              AKYY1 = PHYSOL(N1,1,4)   
              AKYY2 = PHYSOL(N2,1,4)   
              AKYY3 = PHYSOL(N3,1,4)   
              AKYY4 = PHYSOL(N4,1,4)   
              AKYY5 = PHYSOL(N5,1,4)   
              AKYY6 = PHYSOL(N6,1,4)   
C
              AKXY1 = PHYSOL(N1,1,5)   
              AKXY2 = PHYSOL(N2,1,5)   
              AKXY3 = PHYSOL(N3,1,5)   
              AKXY4 = PHYSOL(N4,1,5)   
              AKXY5 = PHYSOL(N5,1,5)   
              AKXY6 = PHYSOL(N6,1,5)   
C
           ELSEIF(NDPROP.EQ.2) THEN
              AKXXE = PHYSOL(I,1,3)
              AKYYE = PHYSOL(I,1,4)
              AKXYE = PHYSOL(I,1,5)
C
              AKXX1 = AKXXE
              AKXX2 = AKXXE
              AKXX3 = AKXXE
              AKXX4 = AKXXE
              AKXX5 = AKXXE
              AKXX6 = AKXXE
C
              AKYY1 = AKYYE
              AKYY2 = AKYYE
              AKYY3 = AKYYE
              AKYY4 = AKYYE
              AKYY5 = AKYYE
              AKYY6 = AKYYE
C
              AKXY1 = AKXYE
              AKXY2 = AKXYE
              AKXY3 = AKXYE
              AKXY4 = AKXYE
              AKXY5 = AKXYE
              AKXY6 = AKXYE
C
           ELSE
              AKXX1 = PHYSOL(I,1,3)              
              AKXX2 = PHYSOL(I,2,3)              
              AKXX3 = PHYSOL(I,3,3)              
              AKXX4 = PHYSOL(I,4,3)              
              AKXX5 = PHYSOL(I,5,3)              
              AKXX6 = PHYSOL(I,6,3) 
C
              AKYY1 = PHYSOL(I,1,4)
              AKYY2 = PHYSOL(I,2,4)          
              AKYY3 = PHYSOL(I,3,4)          
              AKYY4 = PHYSOL(I,4,4)          
              AKYY5 = PHYSOL(I,5,4)          
              AKYY6 = PHYSOL(I,6,4)    
C
              AKXY1 = PHYSOL(I,1,5)
              AKXY2 = PHYSOL(I,2,5)
              AKXY3 = PHYSOL(I,3,5)
              AKXY4 = PHYSOL(I,4,5)
              AKXY5 = PHYSOL(I,5,5)
              AKXY6 = PHYSOL(I,6,5)
           ENDIF
C
C
           X1K11 =   AKXX1*(6*R1+R2+R3) + AKXX4*(5*R1+2*R2+R3) 
     &             + AKXX6*(5*R1+R2+2*R3)
           X1K12 =   AKXY1*(6*R1+R2+R3) + AKXY4*(5*R1+2*R2+R3) 
     &             + AKXY6*(5*R1+R2+2*R3)
           X1K22 =   AKYY1*(6*R1+R2+R3) + AKYY4*(5*R1+2*R2+R3) 
     &             + AKYY6*(5*R1+R2+2*R3)
C
           X2K11 =   AKXX2*(R1+6*R2+R3) + AKXX4*(2*R1+5*R2+R3) 
     &             + AKXX5*(R1+5*R2+2*R3)
           X2K12 =   AKXY2*(R1+6*R2+R3) + AKXY4*(2*R1+5*R2+R3) 
     &             + AKXY5*(R1+5*R2+2*R3)
           X2K22 =   AKYY2*(R1+6*R2+R3) + AKYY4*(2*R1+5*R2+R3) 
     &             + AKYY5*(R1+5*R2+2*R3)
C
           X3K11 =   AKXX3*(R1+R2+6*R3) + AKXX5*(R1+2*R2+5*R3) 
     &             + AKXX6*(2*R1+R2+5*R3)
           X3K12 =   AKXY3*(R1+R2+6*R3) + AKXY5*(R1+2*R2+5*R3) 
     &             + AKXY6*(2*R1+R2+5*R3)
           X3K22 =   AKYY3*(R1+R2+6*R3) + AKYY5*(R1+2*R2+5*R3) 
     &             + AKYY6*(2*R1+R2+5*R3)
C
           X4K11 =   AKXX4*(3*R1+3*R2+2*R3) + AKXX5*(2*R1+3*R2+3*R3) 
     &             + AKXX6*(3*R1+2*R2+3*R3)
           X4K12 =   AKXY4*(3*R1+3*R2+2*R3) + AKXY5*(2*R1+3*R2+3*R3) 
     &             + AKXY6*(3*R1+2*R2+3*R3)
           X4K22 =   AKYY4*(3*R1+3*R2+2*R3) + AKYY5*(2*R1+3*R2+3*R3) 
     &             + AKYY6*(3*R1+2*R2+3*R3)
C
          DX1 = - (COORDS(N6,2)-COORDS(N4,2))
          DY1 =   (COORDS(N6,1)-COORDS(N4,1))
C
          DX2 = - (COORDS(N4,2)-COORDS(N5,2))
          DY2 =   (COORDS(N4,1)-COORDS(N5,1))
C
          DX3 = - (COORDS(N5,2)-COORDS(N6,2)) 
          DY3 =   (COORDS(N5,1)-COORDS(N6,1))
C
C          Calcul des termes diagonaux
C          ~~~~~~~~~~~~~~~~~~~~~~~~~~~
C                                                                       
       WCT(I,1) = (DX1**2*X1K11+2*DY1*DX1*X1K12+DY1**2*X1K22) 
       WCT(I,2) = (DX2**2*X2K11+2*DY2*DX2*X2K12+DY2**2*X2K22) 
       WCT(I,3) = (DX3**2*X3K11+2*DY3*DX3*X3K12+DY3**2*X3K22) 
       WCT(I,4) = (DX2**2*X1K11+2*DY2*DX2*X1K12+DY2**2*X1K22+DX1**
     &2*X2K11+2*DY1*DX1*X2K12+DY1**2*X2K22+DX3**2*X4K11+2*DY3*DX3*X4K12+
     &DY3**2*X4K22) 
       WCT(I,5) = (DX3**2*X2K11+2*DY3*DX3*X2K12+DY3**2*X2K22+DX2**
     &2*X3K11+2*DY2*DX2*X3K12+DY2**2*X3K22+DX1**2*X4K11+2*DY1*DX1*X4K12+
     &DY1**2*X4K22)  
       WCT(I,6) = (DX3**2*X1K11+2*DY3*DX3*X1K12+DY3**2*X1K22+DX1**
     &2*X3K11+2*DY1*DX1*X3K12+DY1**2*X3K22+DX2**2*X4K11+2*DY2*DX2*X4K12+
     &DY2**2*X4K22) 
C
C           Calcul des termes extra-diagonaux
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
      XMAT(I,1) = (DX1*DX2*X1K11+DY1*DX2*X1K12+DX1*DY2*X1K12+DY1*D
     &Y2*X1K22)
      XMAT(I,2) = (DX1*DX3*X1K11+DY1*DX3*X1K12+DX1*DY3*X1K12+DY1*D
     &Y3*X1K22)
C
      XMAT(I,3) = (DX2*DX1*X2K11+DY2*DX1*X2K12+DX2*DY1*X2K12+DY2*D
     &Y1*X2K22)
      XMAT(I,4) = (DX2*DX3*X2K11+DY2*DX3*X2K12+DX2*DY3*X2K12+DY2*D
     &Y3*X2K22)
C
      XMAT(I,5) = (DX3*DX2*X3K11+DY3*DX2*X3K12+DX3*DY2*X3K12+DY3*D
     &Y2*X3K22)
      XMAT(I,6) = (DX3*DX1*X3K11+DY3*DX1*X3K12+DX3*DY1*X3K12+DY3*D
     &Y1*X3K22)
C
      XMAT(I,7) = (DX1*DX3*X2K11+DY1*DX3*X2K12+DX1*DY3*X2K12+DY1*D
     &Y3*X2K22+DX3*DX1*X4K11+DY3*DX1*X4K12+DX3*DY1*X4K12+DY3*DY1*X4K22)
      XMAT(I,8) = (DX2*DX3*X1K11+DY2*DX3*X1K12+DX2*DY3*X1K12+DY2*D
     &Y3*X1K22+DX3*DX2*X4K11+DY3*DX2*X4K12+DX3*DY2*X4K12+DY3*DY2*X4K22)
C
      XMAT(I,9) = (DX2*DX1*X3K11+DY2*DX1*X3K12+DX2*DY1*X3K12+DY2*D
     &Y1*X3K22+DX1*DX2*X4K11+DY1*DX2*X4K12+DX1*DY2*X4K12+DY1*DY2*X4K22) 
C
C
  120     CONTINUE
C
C
        ENDIF
C
C
C
C
C     2- CAS TRIDIMENSIONNEL
C     ======================
      ELSE
C     
         DO 200 I=1,NELEMS
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
           N7 = NODES(I,7)
           N8 = NODES(I,8)
           N9 = NODES(I,9)
           N10 = NODES(I,10)
C
           IF(NDPROP.EQ.1) THEN
             AKXX1  =  PHYSOL(N1,1,3)
             AKXX2  =  PHYSOL(N2,1,3)
             AKXX3  =  PHYSOL(N3,1,3)
             AKXX4  =  PHYSOL(N4,1,3)
             AKXX5  =  PHYSOL(N5,1,3)
             AKXX6  =  PHYSOL(N6,1,3)
             AKXX7  =  PHYSOL(N7,1,3)
             AKXX8  =  PHYSOL(N8,1,3)
             AKXX9  =  PHYSOL(N9,1,3)
             AKXX10 =  PHYSOL(N10,1,3)
C
             AKYY1  =  PHYSOL(N1,1,4)
             AKYY2  =  PHYSOL(N2,1,4)
             AKYY3  =  PHYSOL(N3,1,4)
             AKYY4  =  PHYSOL(N4,1,4)
             AKYY5  =  PHYSOL(N5,1,4)
             AKYY6  =  PHYSOL(N6,1,4)
             AKYY7  =  PHYSOL(N7,1,4)
             AKYY8  =  PHYSOL(N8,1,4)
             AKYY9  =  PHYSOL(N9,1,4)
             AKYY10 =  PHYSOL(N10,1,4)
C
             AKZZ1  =  PHYSOL(N1,1,5)
             AKZZ2  =  PHYSOL(N2,1,5)
             AKZZ3  =  PHYSOL(N3,1,5)
             AKZZ4  =  PHYSOL(N4,1,5)
             AKZZ5  =  PHYSOL(N5,1,5)
             AKZZ6  =  PHYSOL(N6,1,5)
             AKZZ7  =  PHYSOL(N7,1,5)
             AKZZ8  =  PHYSOL(N8,1,5)
             AKZZ9  =  PHYSOL(N9,1,5)
             AKZZ10 =  PHYSOL(N10,1,5)
C
             AKXY1  =  PHYSOL(N1,1,6)
             AKXY2  =  PHYSOL(N2,1,6)
             AKXY3  =  PHYSOL(N3,1,6)
             AKXY4  =  PHYSOL(N4,1,6)
             AKXY5  =  PHYSOL(N5,1,6)
             AKXY6  =  PHYSOL(N6,1,6)
             AKXY7  =  PHYSOL(N7,1,6)
             AKXY8  =  PHYSOL(N8,1,6)
             AKXY9  =  PHYSOL(N9,1,6)
             AKXY10 =  PHYSOL(N10,1,6)
C
             AKXZ1  =  PHYSOL(N1,1,7)
             AKXZ2  =  PHYSOL(N2,1,7)
             AKXZ3  =  PHYSOL(N3,1,7)
             AKXZ4  =  PHYSOL(N4,1,7)
             AKXZ5  =  PHYSOL(N5,1,7)
             AKXZ6  =  PHYSOL(N6,1,7)
             AKXZ7  =  PHYSOL(N7,1,7)
             AKXZ8  =  PHYSOL(N8,1,7)
             AKXZ9  =  PHYSOL(N9,1,7)
             AKXZ10 =  PHYSOL(N10,1,7)
C
             AKYZ1  =  PHYSOL(N1,1,8)
             AKYZ2  =  PHYSOL(N2,1,8)
             AKYZ3  =  PHYSOL(N3,1,8)
             AKYZ4  =  PHYSOL(N4,1,8)
             AKYZ5  =  PHYSOL(N5,1,8)
             AKYZ6  =  PHYSOL(N6,1,8)
             AKYZ7  =  PHYSOL(N7,1,8)
             AKYZ8  =  PHYSOL(N8,1,8)
             AKYZ9  =  PHYSOL(N9,1,8)
             AKYZ10 =  PHYSOL(N10,1,8)
C
           ELSEIF(NDPROP.EQ.2) THEN
             AKXXE  = PHYSOL(I,1,3)
             AKYYE  = PHYSOL(I,1,4)
             AKZZE  = PHYSOL(I,1,5)
             AKXYE  = PHYSOL(I,1,6)
             AKXZE  = PHYSOL(I,1,7)
             AKYZE  = PHYSOL(I,1,8)
C
             AKXX1  = AKXXE
             AKXX2  = AKXXE
             AKXX3  = AKXXE
             AKXX4  = AKXXE
             AKXX5  = AKXXE
             AKXX6  = AKXXE
             AKXX7  = AKXXE
             AKXX8  = AKXXE
             AKXX9  = AKXXE
             AKXX10 = AKXXE
C
             AKYY1  = AKYYE
             AKYY2  = AKYYE
             AKYY3  = AKYYE
             AKYY4  = AKYYE
             AKYY5  = AKYYE
             AKYY6  = AKYYE
             AKYY7  = AKYYE
             AKYY8  = AKYYE
             AKYY9  = AKYYE
             AKYY10 = AKYYE
C
             AKZZ1  = AKZZE
             AKZZ2  = AKZZE
             AKZZ3  = AKZZE
             AKZZ4  = AKZZE
             AKZZ5  = AKZZE
             AKZZ6  = AKZZE
             AKZZ7  = AKZZE
             AKZZ8  = AKZZE
             AKZZ9  = AKZZE
             AKZZ10 = AKZZE
C
             AKXY1  = AKXYE
             AKXY2  = AKXYE
             AKXY3  = AKXYE
             AKXY4  = AKXYE
             AKXY5  = AKXYE
             AKXY6  = AKXYE
             AKXY7  = AKXYE
             AKXY8  = AKXYE
             AKXY9  = AKXYE
             AKXY10 = AKXYE
C
             AKXZ1  = AKXZE
             AKXZ2  = AKXZE
             AKXZ3  = AKXZE
             AKXZ4  = AKXZE
             AKXZ5  = AKXZE
             AKXZ6  = AKXZE
             AKXZ7  = AKXZE
             AKXZ8  = AKXZE
             AKXZ9  = AKXZE
             AKXZ10 = AKXZE
C
             AKYZ1  = AKYZE
             AKYZ2  = AKYZE
             AKYZ3  = AKYZE
             AKYZ4  = AKYZE
             AKYZ5  = AKYZE
             AKYZ6  = AKYZE
             AKYZ7  = AKYZE
             AKYZ8  = AKYZE
             AKYZ9  = AKYZE
             AKYZ10 = AKYZE
           ELSE
             AKXX1  = PHYSOL(I,1,3)
             AKXX2  = PHYSOL(I,2,3)
             AKXX3  = PHYSOL(I,3,3)
             AKXX4  = PHYSOL(I,4,3)
             AKXX5  = PHYSOL(I,5,3)
             AKXX6  = PHYSOL(I,6,3)
             AKXX7  = PHYSOL(I,7,3)
             AKXX8  = PHYSOL(I,8,3)
             AKXX9  = PHYSOL(I,9,3)
             AKXX10 = PHYSOL(I,10,3)
C
             AKYY1  = PHYSOL(I,1,4)
             AKYY2  = PHYSOL(I,2,4)
             AKYY3  = PHYSOL(I,3,4)
             AKYY4  = PHYSOL(I,4,4)
             AKYY5  = PHYSOL(I,5,4)
             AKYY6  = PHYSOL(I,6,4)
             AKYY7  = PHYSOL(I,7,4)
             AKYY8  = PHYSOL(I,8,4)
             AKYY9  = PHYSOL(I,9,4)
             AKYY10 = PHYSOL(I,10,4)
C
             AKZZ1  = PHYSOL(I,1,5)
             AKZZ2  = PHYSOL(I,2,5)
             AKZZ3  = PHYSOL(I,3,5)
             AKZZ4  = PHYSOL(I,4,5)
             AKZZ5  = PHYSOL(I,5,5)
             AKZZ6  = PHYSOL(I,6,5)
             AKZZ7  = PHYSOL(I,7,5)
             AKZZ8  = PHYSOL(I,8,5)
             AKZZ9  = PHYSOL(I,9,5)
             AKZZ10 = PHYSOL(I,10,5)
C
             AKXY1  = PHYSOL(I,1,6)
             AKXY2  = PHYSOL(I,2,6)
             AKXY3  = PHYSOL(I,3,6)
             AKXY4  = PHYSOL(I,4,6)
             AKXY5  = PHYSOL(I,5,6)
             AKXY6  = PHYSOL(I,6,6)
             AKXY7  = PHYSOL(I,7,6)
             AKXY8  = PHYSOL(I,8,6)
             AKXY9  = PHYSOL(I,9,6)
             AKXY10 = PHYSOL(I,10,6)
C
             AKXZ1  = PHYSOL(I,1,7)
             AKXZ2  = PHYSOL(I,2,7)
             AKXZ3  = PHYSOL(I,3,7)
             AKXZ4  = PHYSOL(I,4,7)
             AKXZ5  = PHYSOL(I,5,7)
             AKXZ6  = PHYSOL(I,6,7)
             AKXZ7  = PHYSOL(I,7,7)
             AKXZ8  = PHYSOL(I,8,7)
             AKXZ9  = PHYSOL(I,9,7)
             AKXZ10 = PHYSOL(I,10,7)
C
             AKYZ1  = PHYSOL(I,1,8)
             AKYZ2  = PHYSOL(I,2,8)
             AKYZ3  = PHYSOL(I,3,8)
             AKYZ4  = PHYSOL(I,4,8)
             AKYZ5  = PHYSOL(I,5,8)
             AKYZ6  = PHYSOL(I,6,8)
             AKYZ7  = PHYSOL(I,7,8)
             AKYZ8  = PHYSOL(I,8,8)
             AKYZ9  = PHYSOL(I,9,8)
             AKYZ10 = PHYSOL(I,10,8)
          ENDIF
C
C
          X1K11 = AKXX1 + AKXX5 + AKXX7 + AKXX8
          X1K12 = AKXY1 + AKXY5 + AKXY7 + AKXY8
          X1K13 = AKXZ1 + AKXZ5 + AKXZ7 + AKXZ8
          X1K22 = AKYY1 + AKYY5 + AKYY7 + AKYY8
          X1K23 = AKYZ1 + AKYZ5 + AKYZ7 + AKYZ8
          X1K33 = AKZZ1 + AKZZ5 + AKZZ7 + AKZZ8
C
          X2K11 = AKXX2 + AKXX5 + AKXX6 + AKXX9
          X2K12 = AKXY2 + AKXY5 + AKXY6 + AKXY9
          X2K13 = AKXZ2 + AKXZ5 + AKXZ6 + AKXZ9
          X2K22 = AKYY2 + AKYY5 + AKYY6 + AKYY9
          X2K23 = AKYZ2 + AKYZ5 + AKYZ6 + AKYZ9
          X2K33 = AKZZ2 + AKZZ5 + AKZZ6 + AKZZ9
C
          X3K11 = AKXX3 + AKXX6 + AKXX7 + AKXX10
          X3K12 = AKXY3 + AKXY6 + AKXY7 + AKXY10
          X3K13 = AKXZ3 + AKXZ6 + AKXZ7 + AKXZ10
          X3K22 = AKYY3 + AKYY6 + AKYY7 + AKYY10
          X3K23 = AKYZ3 + AKYZ6 + AKYZ7 + AKYZ10
          X3K33 = AKZZ3 + AKZZ6 + AKZZ7 + AKZZ10
C
          X4K11 = AKXX4 + AKXX8 + AKXX9 + AKXX10
          X4K12 = AKXY4 + AKXY8 + AKXY9 + AKXY10
          X4K13 = AKXZ4 + AKXZ8 + AKXZ9 + AKXZ10
          X4K22 = AKYY4 + AKYY8 + AKYY9 + AKYY10
          X4K23 = AKYZ4 + AKYZ8 + AKYZ9 + AKYZ10
          X4K33 = AKZZ4 + AKZZ8 + AKZZ9 + AKZZ10
C
          X5K11 = AKXX5 + AKXX6 + AKXX7 + AKXX8
          X5K12 = AKXY5 + AKXY6 + AKXY7 + AKXY8
          X5K13 = AKXZ5 + AKXZ6 + AKXZ7 + AKXZ8
          X5K22 = AKYY5 + AKYY6 + AKYY7 + AKYY8
          X5K23 = AKYZ5 + AKYZ6 + AKYZ7 + AKYZ8
          X5K33 = AKZZ5 + AKZZ6 + AKZZ7 + AKZZ8
C
          X6K11 = AKXX5 + AKXX6 + AKXX8 + AKXX9
          X6K12 = AKXY5 + AKXY6 + AKXY8 + AKXY9
          X6K13 = AKXZ5 + AKXZ6 + AKXZ8 + AKXZ9
          X6K22 = AKYY5 + AKYY6 + AKYY8 + AKYY9
          X6K23 = AKYZ5 + AKYZ6 + AKYZ8 + AKYZ9
          X6K33 = AKZZ5 + AKZZ6 + AKZZ8 + AKZZ9
C
          X7K11 = AKXX6 + AKXX7 + AKXX8 + AKXX10
          X7K12 = AKXY6 + AKXY7 + AKXY8 + AKXY10
          X7K13 = AKXZ6 + AKXZ7 + AKXZ8 + AKXZ10
          X7K22 = AKYY6 + AKYY7 + AKYY8 + AKYY10
          X7K23 = AKYZ6 + AKYZ7 + AKYZ8 + AKYZ10
          X7K33 = AKZZ6 + AKZZ7 + AKZZ8 + AKZZ10
C
          X8K11 = AKXX6 + AKXX8 + AKXX9 + AKXX10
          X8K12 = AKXY6 + AKXY8 + AKXY9 + AKXY10
          X8K13 = AKXZ6 + AKXZ8 + AKXZ9 + AKXZ10
          X8K22 = AKYY6 + AKYY8 + AKYY9 + AKYY10
          X8K23 = AKYZ6 + AKYZ8 + AKYZ9 + AKYZ10
          X8K33 = AKZZ6 + AKZZ8 + AKZZ9 + AKZZ10
C       
          COEFF = S18 / VOLUME(I)
C
          X75 = COORDS(N5,1) - COORDS(N7,1)
          Y75 = COORDS(N5,2) - COORDS(N7,2)
          Z75 = COORDS(N5,3) - COORDS(N7,3)
C
          X78 = COORDS(N8,1) - COORDS(N7,1)
          Y78 = COORDS(N8,2) - COORDS(N7,2)
          Z78 = COORDS(N8,3) - COORDS(N7,3)
C
          X69 = COORDS(N9,1) - COORDS(N6,1)
          Y69 = COORDS(N9,2) - COORDS(N6,2)
          Z69 = COORDS(N9,3) - COORDS(N6,3)
C
          X65 = COORDS(N5,1) - COORDS(N6,1)
          Y65 = COORDS(N5,2) - COORDS(N6,2)
          Z65 = COORDS(N5,3) - COORDS(N6,3)
C
          X710= COORDS(N10,1) - COORDS(N7,1)
          Y710= COORDS(N10,2) - COORDS(N7,2)
          Z710= COORDS(N10,3) - COORDS(N7,3)
C
          X76 = COORDS(N6,1) - COORDS(N7,1)
          Y76 = COORDS(N6,2) - COORDS(N7,2)
          Z76 = COORDS(N6,3) - COORDS(N7,3)
C
          X89 = COORDS(N9,1) - COORDS(N8,1)
          Y89 = COORDS(N9,2) - COORDS(N8,2)
          Z89 = COORDS(N9,3) - COORDS(N8,3)
C
          X810= COORDS(N10,1) - COORDS(N8,1)
          Y810= COORDS(N10,2) - COORDS(N8,2)
          Z810= COORDS(N10,3) - COORDS(N8,3)
C
          DX1 =   (Y75*Z78 - Z75*Y78)
          DY1 = - (X75*Z78 - Z75*X78)
          DZ1 =   (X75*Y78 - Y75*X78)
C
          DX2 =   (Y69*Z65 - Z69*Y65)
          DY2 = - (X69*Z65 - Z69*X65)
          DZ2 =   (X69*Y65 - Y69*X65)
C
          DX3 =   (Y710*Z76 - Z710*Y76)
          DY3 = - (X710*Z76 - Z710*X76)
          DZ3 =   (X710*Y76 - Y710*X76)
C
          DX4 =   (Y89*Z810 - Z89*Y810)
          DY4 = - (X89*Z810 - Z89*X810)
          DZ4 =   (X89*Y810 - Y89*X810)
C
C
C
C          Calcul des termes diagonaux
C          ~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
      WCT(I,1) = COEFF*(DX1**2*X1K11+2*DY1*DX1*X1K12+2*DZ1*DX1*X1K13+DY
     &1**2*X1K22+2*DZ1*DY1*X1K23+DZ1**2*X1K33)                               
      WCT(I,2) = COEFF*(DX2**2*X2K11+2*DY2*DX2*X2K12+2*DZ2*DX2*X2K13+DY
     &2**2*X2K22+2*DZ2*DY2*X2K23+DZ2**2*X2K33)                               
      WCT(I,3) = COEFF*(DX3**2*X3K11+2*DY3*DX3*X3K12+2*DZ3*DX3*X3K13+DY
     &3**2*X3K22+2*DZ3*DY3*X3K23+DZ3**2*X3K33)                             
      WCT(I,4) =  COEFF*(DX4**2*X4K11+2*DY4*DX4*X4K12+2*DZ4*DX4*X4K13+DY
     &4**2*X4K22+2*DZ4*DY4*X4K23+DZ4**2*X4K33)                          
      WCT(I,5) = COEFF*(DX2**2*X1K11+2*DY2*DX2*X1K12+2*DZ2*DX2*X1K13+DY
     &2**2*X1K22+2*DZ2*DY2*X1K23+DZ2**2*X1K33+DX1**2*X2K11+2*DY1*DX1*X2K
     &12+2*DZ1*DX1*X2K13+DY1**2*X2K22+2*DZ1*DY1*X2K23+DZ1**2*X2K33+(DX1+
     &DX2)**2*X5K11+2*(DY1+DY2)*(DX1+DX2)*X5K12+2*(DZ1+DZ2)*(DX1+DX2)*X5
     &K13+(DY1+DY2)**2*X5K22+2*(DZ1+DZ2)*(DY1+DY2)*X5K23+(DZ1+DZ2)**2*X5
     &K33+(DX1+DX2)**2*X6K11+2*(DY1+DY2)*(DX1+DX2)*X6K12+2*(DZ1+DZ2)*(DX
     &1+DX2)*X6K13+(DY1+DY2)**2*X6K22+2*(DZ1+DZ2)*(DY1+DY2)*X6K23+(DZ1+D
     &Z2)**2*X6K33)            
       WCT(I,6) = COEFF*(2*DZ2*DX2*X3K13+DZ3**2*X6K33+2*DZ3*DY3*X6K23+DY
     &3**2*X6K22+2*DZ3*DX3*X6K13+2*DY3*DX3*X6K12+DX3**2*X6K11+2*DZ3*DX3*
     &X2K13+DX2**2*X7K11+2*DY2*DX2*X7K12+2*DZ2*DX2*X7K13+DY2**2*X7K22+2*
     &DZ2*DY2*X7K23+DZ2**2*X7K33+2*DZ4*DY4*X8K23+DZ4**2*X8K33+DX4**2*X8K
     &11+2*DY4*DX4*X8K12+2*DZ4*DX4*X8K13+DY4**2*X8K22+DX3**2*X2K11+2*DY3
     &*DX3*X2K12+DY3**2*X2K22+2*DZ3*DY3*X2K23+DZ3**2*X2K33+DX2**2*X3K11+
     &2*DY2*DX2*X3K12+DY2**2*X3K22+2*DZ2*DY2*X3K23+DZ2**2*X3K33+DX1**2*X
     &5K11+2*DY1*DX1*X5K12+2*DZ1*DX1*X5K13+DY1**2*X5K22+2*DZ1*DY1*X5K23+
     &DZ1**2*X5K33) 
      WCT(I,7) = COEFF*(DX3**2*X1K11+2*DY3*DX3*X1K12+2*DZ3*DX3*X1K13+DY
     &3**2*X1K22+2*DZ3*DY3*X1K23+DZ3**2*X1K33+DX1**2*X3K11+2*DY1*DX1*X3K
     &12+2*DZ1*DX1*X3K13+DY1**2*X3K22+2*DZ1*DY1*X3K23+DZ1**2*X3K33+(-DX2
     &-DX4)**2*X5K11+2*(-DY2-DY4)*(-DX2-DX4)*X5K12+2*(-DZ2-DZ4)*(-DX2-DX
     &4)*X5K13+(-DY2-DY4)**2*X5K22+2*(-DZ2-DZ4)*(-DY2-DY4)*X5K23+(-DZ2-D
     &Z4)**2*X5K33+(-DX2-DX4)**2*X7K11+2*(-DY2-DY4)*(-DX2-DX4)*X7K12+2*(
     &-DZ2-DZ4)*(-DX2-DX4)*X7K13+(-DY2-DY4)**2*X7K22+2*(-DZ2-DZ4)*(-DY2-
     &DY4)*X7K23+(-DZ2-DZ4)**2*X7K33)                 
      WCT(I,8) = COEFF*(DZ4**2*X5K33+DY1**2*X8K22+2*DY4*DX4*X1K12+DX4**
     &2*X1K11+2*DZ4*DX4*X1K13+DY4**2*X1K22+2*DZ4*DY4*X1K23+DZ4**2*X1K33+
     &DZ3**2*X7K33+DX3**2*X7K11+2*DY3*DX3*X7K12+2*DZ3*DX3*X7K13+DY3**2*X
     &7K22+2*DZ3*DY3*X7K23+2*DY2*DX2*X6K12+2*DZ2*DX2*X6K13+DX2**2*X6K11+
     &DY2**2*X6K22+DX1**2*X8K11+2*DY1*DX1*X8K12+2*DZ1*DX1*X8K13+DZ1**2*X
     &8K33+2*DZ1*DY1*X8K23+DZ2**2*X6K33+2*DZ2*DY2*X6K23+DX1**2*X4K11+2*D
     &Y1*DX1*X4K12+2*DZ1*DX1*X4K13+DY1**2*X4K22+2*DZ1*DY1*X4K23+DZ1**2*X
     &4K33+DX4**2*X5K11+2*DY4*DX4*X5K12+2*DZ4*DX4*X5K13+DY4**2*X5K22+2*D
     &Z4*DY4*X5K23)
      WCT(I,9) = COEFF*(DX4**2*X2K11+2*DY4*DX4*X2K12+2*DZ4*DX4*X2K13+DY
     &4**2*X2K22+2*DZ4*DY4*X2K23+DZ4**2*X2K33+DX2**2*X4K11+2*DY2*DX2*X4K
     &12+2*DZ2*DX2*X4K13+DY2**2*X4K22+2*DZ2*DY2*X4K23+DZ2**2*X4K33+(-DX1
     &-DX3)**2*X6K11+2*(-DY1-DY3)*(-DX1-DX3)*X6K12+2*(-DZ1-DZ3)*(-DX1-DX
     &3)*X6K13+(-DY1-DY3)**2*X6K22+2*(-DZ1-DZ3)*(-DY1-DY3)*X6K23+(-DZ1-D
     &Z3)**2*X6K33+(-DX1-DX3)**2*X8K11+2*(-DY1-DY3)*(-DX1-DX3)*X8K12+2*(
     &-DZ1-DZ3)*(-DX1-DX3)*X8K13+(-DY1-DY3)**2*X8K22+2*(-DZ1-DZ3)*(-DY1-
     &DY3)*X8K23+(-DZ1-DZ3)**2*X8K33)              
      WCT(I,10) = COEFF*(DX4**2*X3K11+2*DY4*DX4*X3K12+2*DZ4*DX4*X3K13+
     &DY4**2*X3K22+2*DZ4*DY4*X3K23+DZ4**2*X3K33+DX3**2*X4K11+2*DY3*DX3*X
     &4K12+2*DZ3*DX3*X4K13+DY3**2*X4K22+2*DZ3*DY3*X4K23+DZ3**2*X4K33+(DX
     &3+DX4)**2*X7K11+2*(DY3+DY4)*(DX3+DX4)*X7K12+2*(DZ3+DZ4)*(DX3+DX4)*
     &X7K13+(DY3+DY4)**2*X7K22+2*(DZ3+DZ4)*(DY3+DY4)*X7K23+(DZ3+DZ4)**2*
     &X7K33+(DX3+DX4)**2*X8K11+2*(DY3+DY4)*(DX3+DX4)*X8K12+2*(DZ3+DZ4)*(
     &DX3+DX4)*X8K13+(DY3+DY4)**2*X8K22+2*(DZ3+DZ4)*(DY3+DY4)*X8K23+(DZ3
     &+DZ4)**2*X8K33)   
C
C          Calcul des termes extra-diagonaux
C          ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C  
      XMAT(I,1) = COEFF*(DX1*DX2*X1K11+DY1*DX2*X1K12+DZ1*DX2*X1K13+DX1*D
     &Y2*X1K12+DY1*DY2*X1K22+DZ1*DY2*X1K23+DX1*DZ2*X1K13+DY1*DZ2*X1K23+D
     &Z1*DZ2*X1K33)                              
      XMAT(I,2) = COEFF*(DX1*DX3*X1K11+DY1*DX3*X1K12+DZ1*DX3*X1K13+DX1*D
     &Y3*X1K12+DY1*DY3*X1K22+DZ1*DY3*X1K23+DX1*DZ3*X1K13+DY1*DZ3*X1K23+D
     &Z1*DZ3*X1K33)                                   
      XMAT(I,3) = COEFF*(DX1*DX4*X1K11+DY1*DX4*X1K12+DZ1*DX4*X1K13+DX1*D
     &Y4*X1K12+DY1*DY4*X1K22+DZ1*DY4*X1K23+DX1*DZ4*X1K13+DY1*DZ4*X1K23+D
     &Z1*DZ4*X1K33)                               
C
      XMAT(I,4) = COEFF*(DX2*DX1*X2K11+DY2*DX1*X2K12+DZ2*DX1*X2K13+DX2*D
     &Y1*X2K12+DY2*DY1*X2K22+DZ2*DY1*X2K23+DX2*DZ1*X2K13+DY2*DZ1*X2K23+D
     &Z2*DZ1*X2K33)                               
      XMAT(I,5) = COEFF*(DX2*DX3*X2K11+DY2*DX3*X2K12+DZ2*DX3*X2K13+DX2*D
     &Y3*X2K12+DY2*DY3*X2K22+DZ2*DY3*X2K23+DX2*DZ3*X2K13+DY2*DZ3*X2K23+D
     &Z2*DZ3*X2K33)                                   
      XMAT(I,6) = COEFF*(DX2*DX4*X2K11+DY2*DX4*X2K12+DZ2*DX4*X2K13+DX2*D
     &Y4*X2K12+DY2*DY4*X2K22+DZ2*DY4*X2K23+DX2*DZ4*X2K13+DY2*DZ4*X2K23+D
     &Z2*DZ4*X2K33)                         
C
      XMAT(I,7) = COEFF*(DX3*DX2*X3K11+DY3*DX2*X3K12+DZ3*DX2*X3K13+DX3*D
     &Y2*X3K12+DY3*DY2*X3K22+DZ3*DY2*X3K23+DX3*DZ2*X3K13+DY3*DZ2*X3K23+D
     &Z3*DZ2*X3K33)                             
      XMAT(I,8) = COEFF*(DX3*DX1*X3K11+DY3*DX1*X3K12+DZ3*DX1*X3K13+DX3*D
     &Y1*X3K12+DY3*DY1*X3K22+DZ3*DY1*X3K23+DX3*DZ1*X3K13+DY3*DZ1*X3K23+D
     &Z3*DZ1*X3K33)                          
      XMAT(I,9) = COEFF*(DX3*DX4*X3K11+DY3*DX4*X3K12+DZ3*DX4*X3K13+DX3*
     &DY4*X3K12+DY3*DY4*X3K22+DZ3*DY4*X3K23+DX3*DZ4*X3K13+DY3*DZ4*X3K23+
     &DZ3*DZ4*X3K33)                              
C
      XMAT(I,10) =COEFF*(DX4*DX1*X4K11+DY4*DX1*X4K12+DZ4*DX1*X4K13+DX4*D
     &Y1*X4K12+DY4*DY1*X4K22+DZ4*DY1*X4K23+DX4*DZ1*X4K13+DY4*DZ1*X4K23+D
     &Z4*DZ1*X4K33)                            
      XMAT(I,11) =COEFF*(DX4*DX2*X4K11+DY4*DX2*X4K12+DZ4*DX2*X4K13+DX4*D
     &Y2*X4K12+DY4*DY2*X4K22+DZ4*DY2*X4K23+DX4*DZ2*X4K13+DY4*DZ2*X4K23+D
     &Z4*DZ2*X4K33)                            
      XMAT(I,12) =COEFF*(DX4*DX3*X4K11+DY4*DX3*X4K12+DZ4*DX3*X4K13+DX4*
     &DY3*X4K12+DY4*DY3*X4K22+DZ4*DY3*X4K23+DX4*DZ3*X4K13+DY4*DZ3*X4K23+
     &DZ4*DZ3*X4K33)                        
C
      XMAT(I,13) =COEFF*((DY1+DY2)*DZ3*X6K23+DY1*DZ3*X2K23+DX1*DX3*X2K11
     &+(DX1+DX2)*DY3*X6K12+(DX1+DX2)*DX3*X6K11+(DZ1+DZ2)*DY3*X6K23+DY1*D
     &X3*X2K12+DX1*DY3*X2K12+(DZ1+DZ2)*DX3*X6K13+DZ1*DX3*X2K13+DY1*DY3*X
     &2K22+DZ1*DY3*X2K23+DX1*DZ3*X2K13+DZ1*DZ3*X2K33-(DX1+DX2)*DX1*X5K11
     &-(DY1+DY2)*DX1*X5K12-(DZ1+DZ2)*DX1*X5K13-(DX1+DX2)*DY1*X5K12-(DY1+
     &DY2)*DY1*X5K22-(DZ1+DZ2)*DY1*X5K23-(DX1+DX2)*DZ1*X5K13-(DY1+DY2)*D
     &Z1*X5K23-(DZ1+DZ2)*DZ1*X5K33+(DY1+DY2)*DX3*X6K12+(DY1+DY2)*DY3*X6K
     &22+(DX1+DX2)*DZ3*X6K13+(DZ1+DZ2)*DZ3*X6K33) 
      XMAT(I,14) =COEFF*(DX2*DX3*X1K11+DY2*DX3*X1K12+DZ2*DX3*X1K13+DX2*D
     &Y3*X1K12+DY2*DY3*X1K22+DZ2*DY3*X1K23+DX2*DZ3*X1K13+DY2*DZ3*X1K23+D
     &Z2*DZ3*X1K33+(DX1+DX2)*(-DX2-DX4)*X5K11+(DY1+DY2)*(-DX2-DX4)*X5K12
     &+(DZ1+DZ2)*(-DX2-DX4)*X5K13+(DX1+DX2)*(-DY2-DY4)*X5K12+(DY1+DY2)*(
     &-DY2-DY4)*X5K22+(DZ1+DZ2)*(-DY2-DY4)*X5K23+(DX1+DX2)*(-DZ2-DZ4)*X5
     &K13+(DY1+DY2)*(-DZ2-DZ4)*X5K23+(DZ1+DZ2)*(-DZ2-DZ4)*X5K33)          
      XMAT(I,15) =COEFF*(DX2*DY4*X1K12+DX2*DZ4*X1K13+DY2*DY4*X1K22+DY2*D
     &Z4*X1K23+(DX1+DX2)*DZ4*X5K13+(DX1+DX2)*DY4*X5K12-(DY1+DY2)*DY2*X6K
     &22+DY2*DX4*X1K12+DX2*DX4*X1K11+DZ2*DX4*X1K13+DZ2*DY4*X1K23+DZ2*DZ4
     &*X1K33+(DX1+DX2)*DX4*X5K11+(DY1+DY2)*DX4*X5K12+(DZ1+DZ2)*DX4*X5K13
     &+(DY1+DY2)*DY4*X5K22+(DZ1+DZ2)*DY4*X5K23+(DY1+DY2)*DZ4*X5K23+(DZ1+
     &DZ2)*DZ4*X5K33-(DX1+DX2)*DX2*X6K11-(DY1+DY2)*DX2*X6K12-(DZ1+DZ2)*D
     &X2*X6K13-(DX1+DX2)*DY2*X6K12-(DZ1+DZ2)*DY2*X6K23-(DX1+DX2)*DZ2*X6K
     &13-(DY1+DY2)*DZ2*X6K23-(DZ1+DZ2)*DZ2*X6K33)  
      XMAT(I,16) =COEFF*(DX1*DX4*X2K11+DY1*DX4*X2K12+DZ1*DX4*X2K13+DX1*D
     &Y4*X2K12+DY1*DY4*X2K22+DZ1*DY4*X2K23+DX1*DZ4*X2K13+DY1*DZ4*X2K23+D
     &Z1*DZ4*X2K33+(DX1+DX2)*(-DX1-DX3)*X6K11+(DY1+DY2)*(-DX1-DX3)*X6K12
     &+(DZ1+DZ2)*(-DX1-DX3)*X6K13+(DX1+DX2)*(-DY1-DY3)*X6K12+(DY1+DY2)*(
     &-DY1-DY3)*X6K22+(DZ1+DZ2)*(-DY1-DY3)*X6K23+(DX1+DX2)*(-DZ1-DZ3)*X6
     &K13+(DY1+DY2)*(-DZ1-DZ3)*X6K23+(DZ1+DZ2)*(-DZ1-DZ3)*X6K33)
C
      XMAT(I,17) =COEFF*(DZ2*(-DY2-DY4)*X7K23+DY2*DZ1*X3K23+DZ2*DX1*X3K1
     &3+DX2*DY1*X3K12+DZ2*(-DZ2-DZ4)*X7K33+DX2*(-DX2-DX4)*X7K11+DY2*(-DX
     &2-DX4)*X7K12+DZ2*(-DX2-DX4)*X7K13+DX2*(-DY2-DY4)*X7K12+DY2*(-DY2-D
     &Y4)*X7K22+DX2*(-DZ2-DZ4)*X7K13+DY2*(-DZ2-DZ4)*X7K23+DX2*DX1*X3K11+
     &DY2*DX1*X3K12+DY2*DY1*X3K22+DZ2*DY1*X3K23+DX2*DZ1*X3K13+DZ2*DZ1*X3
     &K33-DX1*(-DX2-DX4)*X5K11-DY1*(-DX2-DX4)*X5K12-DZ1*(-DX2-DX4)*X5K13
     &-DX1*(-DY2-DY4)*X5K12-DY1*(-DY2-DY4)*X5K22-DZ1*(-DY2-DY4)*X5K23-DX
     &1*(-DZ2-DZ4)*X5K13-DY1*(-DZ2-DZ4)*X5K23-DZ1*(-DZ2-DZ4)*X5K33)      
      XMAT(I,18) =COEFF*(-DY3*DY2*X6K22-DX3*DY2*X6K12-DZ3*DX2*X6K13-DY3*
     &DX2*X6K12-DX3*DX2*X6K11-DZ3*DY2*X6K23-DZ3*DZ2*X6K33-DY3*DZ2*X6K23-
     &DX2*DX3*X7K11-DY2*DX3*X7K12-DZ2*DX3*X7K13-DX2*DY3*X7K12-DY2*DY3*X7
     &K22-DZ2*DY3*X7K23-DX2*DZ3*X7K13-DY2*DZ3*X7K23-DZ2*DZ3*X7K33-DX3*DZ
     &2*X6K13-DX4*DX1*X8K11-DY4*DX1*X8K12-DZ4*DX1*X8K13-DX4*DY1*X8K12-DY
     &4*DY1*X8K22-DZ4*DY1*X8K23-DX4*DZ1*X8K13-DY4*DZ1*X8K23-DZ4*DZ1*X8K3
     &3-DX1*DX4*X5K11-DY1*DX4*X5K12-DZ1*DX4*X5K13-DX1*DY4*X5K12-DY1*DY4*
     &X5K22-DZ1*DY4*X5K23-DX1*DZ4*X5K13-DY1*DZ4*X5K23-DZ1*DZ4*X5K33)    
      XMAT(I,19) =COEFF*(DZ3*DX4*X2K13+DX3*DZ4*X2K13+DX3*DY4*X2K12+DX3*(
     &-DY1-DY3)*X6K12+DZ3*(-DX1-DX3)*X6K13-DX4*(-DX1-DX3)*X8K11-DY4*(-DX
     &1-DX3)*X8K12-DZ4*(-DX1-DX3)*X8K13-DX4*(-DY1-DY3)*X8K12-DY4*(-DY1-D
     &Y3)*X8K22-DZ4*(-DY1-DY3)*X8K23-DX4*(-DZ1-DZ3)*X8K13-DY4*(-DZ1-DZ3)
     &*X8K23-DZ4*(-DZ1-DZ3)*X8K33+DX3*DX4*X2K11+DY3*DX4*X2K12+DY3*(-DX1-
     &DX3)*X6K12+DY3*DY4*X2K22+DZ3*DY4*X2K23+DY3*DZ4*X2K23+DZ3*DZ4*X2K33
     &+DX3*(-DX1-DX3)*X6K11+DY3*(-DZ1-DZ3)*X6K23+DX3*(-DZ1-DZ3)*X6K13+DZ
     &3*(-DY1-DY3)*X6K23+DY3*(-DY1-DY3)*X6K22+DZ3*(-DZ1-DZ3)*X6K33)  
      XMAT(I,20) = COEFF*(DZ2*DZ4*X3K33+DZ2*DX4*X3K13+DX2*(DX3+DX4)*X7K1
     &1+DY2*(DX3+DX4)*X7K12+DZ2*(DX3+DX4)*X7K13+DX2*(DY3+DY4)*X7K12+DY2*
     &(DY3+DY4)*X7K22+DZ2*(DY3+DY4)*X7K23+DX2*(DZ3+DZ4)*X7K13+DY2*(DZ3+D
     &Z4)*X7K23+DZ2*(DZ3+DZ4)*X7K33-DX4*(DX3+DX4)*X8K11-DY4*(DX3+DX4)*X8
     &K12-DZ4*(DX3+DX4)*X8K13-DX4*(DY3+DY4)*X8K12-DY4*(DY3+DY4)*X8K22-DZ
     &4*(DY3+DY4)*X8K23-DX4*(DZ3+DZ4)*X8K13-DY4*(DZ3+DZ4)*X8K23-DZ4*(DZ3
     &+DZ4)*X8K33+DX2*DX4*X3K11+DY2*DX4*X3K12+DX2*DY4*X3K12+DY2*DY4*X3K2
     &2+DZ2*DY4*X3K23+DX2*DZ4*X3K13+DY2*DZ4*X3K23)   
C
      XMAT(I,21) =COEFF*(DX3*DX4*X1K11+(-DY2-DY4)*DZ4*X5K23+(-DZ2-DZ4)*D
     &Y4*X5K23+(-DY2-DY4)*DX4*X5K12+DY3*DZ4*X1K23+DX3*DY4*X1K12+DZ3*DX4*
     &X1K13+(-DX2-DX4)*DX4*X5K11+(-DZ2-DZ4)*DZ4*X5K33+(-DZ2-DZ4)*DX4*X5K
     &13+DY3*DX4*X1K12-(-DX2-DX4)*DX3*X7K11-(-DY2-DY4)*DX3*X7K12-(-DZ2-D
     &Z4)*DX3*X7K13-(-DX2-DX4)*DY3*X7K12-(-DY2-DY4)*DY3*X7K22-(-DZ2-DZ4)
     &*DY3*X7K23-(-DX2-DX4)*DZ3*X7K13-(-DY2-DY4)*DZ3*X7K23-(-DZ2-DZ4)*DZ
     &3*X7K33+DY3*DY4*X1K22+DZ3*DY4*X1K23+DX3*DZ4*X1K13+DZ3*DZ4*X1K33+(-
     &DX2-DX4)*DY4*X5K12+(-DY2-DY4)*DY4*X5K22+(-DX2-DX4)*DZ4*X5K13)  
      XMAT(I,22) = COEFF*(DX1*DX4*X3K11+DY1*DX4*X3K12+DZ1*DX4*X3K13+DX1*
     &DY4*X3K12+DY1*DY4*X3K22+DZ1*DY4*X3K23+DX1*DZ4*X3K13+DY1*DZ4*X3K23+
     &DZ1*DZ4*X3K33+(-DX2-DX4)*(DX3+DX4)*X7K11+(-DY2-DY4)*(DX3+DX4)*X7K1
     &2+(-DZ2-DZ4)*(DX3+DX4)*X7K13+(-DX2-DX4)*(DY3+DY4)*X7K12+(-DY2-DY4)
     &*(DY3+DY4)*X7K22+(-DZ2-DZ4)*(DY3+DY4)*X7K23+(-DX2-DX4)*(DZ3+DZ4)*X
     &7K13+(-DY2-DY4)*(DZ3+DZ4)*X7K23+(-DZ2-DZ4)*(DZ3+DZ4)*X7K33)               
C
      XMAT(I,23) =COEFF*(DY1*(-DY1-DY3)*X8K22+DY1*(-DZ1-DZ3)*X8K23+DX1*(
     &-DY1-DY3)*X8K12+DX1*DZ2*X4K13+DZ1*DZ2*X4K33+DX1*DX2*X4K11-DX2*(-DX
     &1-DX3)*X6K11-DY2*(-DX1-DX3)*X6K12-DZ2*(-DX1-DX3)*X6K13+DX1*(-DX1-D
     &X3)*X8K11+DY1*(-DX1-DX3)*X8K12+DZ1*(-DX1-DX3)*X8K13+DZ1*(-DY1-DY3)
     &*X8K23+DX1*(-DZ1-DZ3)*X8K13+DZ1*(-DZ1-DZ3)*X8K33-DX2*(-DY1-DY3)*X6
     &K12-DY2*(-DY1-DY3)*X6K22-DZ2*(-DY1-DY3)*X6K23+DY1*DX2*X4K12+DZ1*DX
     &2*X4K13+DX1*DY2*X4K12+DY1*DY2*X4K22+DZ1*DY2*X4K23+DY1*DZ2*X4K23-DY
     &2*(-DZ1-DZ3)*X6K23-DZ2*(-DZ1-DZ3)*X6K33-DX2*(-DZ1-DZ3)*X6K13)     
      XMAT(I,24) = COEFF*(DZ1*DY3*X4K23+DY1*DY3*X4K22+DZ1*(DZ3+DZ4)*X8K3
     &3-DX3*(DX3+DX4)*X7K11-DY3*(DX3+DX4)*X7K12-DZ3*(DX3+DX4)*X7K13-DX3*
     &(DY3+DY4)*X7K12-DY3*(DY3+DY4)*X7K22-DZ3*(DY3+DY4)*X7K23-DX3*(DZ3+D
     &Z4)*X7K13-DY3*(DZ3+DZ4)*X7K23-DZ3*(DZ3+DZ4)*X7K33+DX1*(DX3+DX4)*X8
     &K11+DY1*(DX3+DX4)*X8K12+DZ1*(DX3+DX4)*X8K13+DX1*(DY3+DY4)*X8K12+DY
     &1*(DY3+DY4)*X8K22+DZ1*(DY3+DY4)*X8K23+DX1*(DZ3+DZ4)*X8K13+DY1*(DZ3
     &+DZ4)*X8K23+DX1*DX3*X4K11+DY1*DX3*X4K12+DZ1*DX3*X4K13+DX1*DY3*X4K1
     &2+DX1*DZ3*X4K13+DY1*DZ3*X4K23+DZ1*DZ3*X4K33) 
C
      XMAT(I,25) = COEFF*(DX2*DX3*X4K11+DY2*DX3*X4K12+DZ2*DX3*X4K13+DX2*
     &DY3*X4K12+DY2*DY3*X4K22+DZ2*DY3*X4K23+DX2*DZ3*X4K13+DY2*DZ3*X4K23+
     &DZ2*DZ3*X4K33+(-DX1-DX3)*(DX3+DX4)*X8K11+(-DY1-DY3)*(DX3+DX4)*X8K1
     &2+(-DZ1-DZ3)*(DX3+DX4)*X8K13+(-DX1-DX3)*(DY3+DY4)*X8K12+(-DY1-DY3)
     &*(DY3+DY4)*X8K22+(-DZ1-DZ3)*(DY3+DY4)*X8K23+(-DX1-DX3)*(DZ3+DZ4)*X
     &8K13+(-DY1-DY3)*(DZ3+DZ4)*X8K23+(-DZ1-DZ3)*(DZ3+DZ4)*X8K33)
C                                                                         
  200    CONTINUE
C
      ENDIF                 
C
C-------
C FORMAT
C-------
C
C
      END

