C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LIMFCO
C                       *****************
C
C      -----------------------------------------------------
     * (NCOUPS,NBCOUS,NFCOUS,NFFLUS,NBFFLU,NDIRS,NBDIRS,
     *  NFECHS,NBFECH,NFRAYS,NBFRAY,
     *  NPRIOS,NBPRIO,
     *  NMOBIL,NBMOBS,NBCOPR,NREFS,NPOINS,NDIELE,NELEMS,NDMATS,NODES,
     *  NBFACE,NREFAC)
C      -----------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA NUMEROTATION LOCALE DES NOEUDS        *
C            PORTANT DES CONDITIONS AUX LIMITES DIFFERENTES            * 
C            ET DES NOEUDS PORTANT UN FLUX VOLUMIQUE                   *
C                                                                      *
C                                                                      *
C            CAS DU MODELE COQUE                                       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NCOUPS   ! TE ! R  ! Numero des noeuds solides couples            !
C !  NBCOUS   !  E ! D  ! Nombre de noeuds solides couples             !
C !  NFCOUS   ! TE ! R  ! Numero des faces  solides couples            !
C !  NFFLUS   ! TE ! R  ! Numero des faces  portant une C.L. de flux   !
C !  NBBFLU   !  E ! D  ! Nombre de faces  portant une C.L. de flux    !
C !  NDIRS    ! TE ! R  ! Numero des noeuds portant une C.L. Dirichlet !
C !  NBDIRS   !  E ! D  ! Nombre de noeuds portant une C.L. Dirichlet  !
C !  NBECHS   ! TE ! R  ! Numero des faces  avec C.L. coeff echange    ! 
C !  NBBECH   !  E ! D  ! Nombre de faces  avec C.L. coeff echange     ! 
C !  NFRAYS   ! TE ! R  ! Numero des faces  avec rayonnement           !
C !  NBFRAY   !  E ! D  ! Nombre de faces  avec rayonnement            !
C !  NPRIOS   ! TE ! R  ! Numero des noeuds periodiques                !
C !  NBPRIO   !  E ! D  ! Nombre de noeuds periodiques                 !
C !  NMOBIL   ! TE ! R  ! Numero des noeuds en mouvement               !
C !  NBMOBS   !  E ! D  ! Nombre de  noeuds en mouvement               !
C !  NBCOPR   !  E ! D  ! Nbre de correspondants pour les noeuds period!
C !  NREFS    ! TE ! D  ! References des noeuds solides                !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  NDIELE   !  E ! D  ! Dimension des elements                       !
C !  NELEMS   !  E ! D  ! Nombre d'elements du maillage                !
C !  NDMATS   !  E ! D  ! Nombre de noeuds des elements                !
C !  NODES    ! TE ! D  ! Table des elements                           !
C !  NBFACE   !  E ! D  ! Nombre de faces des elts vol solides         !
C !  NREFAC   ! TE ! D  ! References des faces                         !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIELE,NBCOUS,NBFFLU,NBDIRS,NBFECH,NBFRAY
      INTEGER NBCOPR,NBPRIO,NBMOBS
      INTEGER NELEMS
      INTEGER NCOUPS(NBCOUS),NFCOUS(NELEMS),NFFLUS(NBFFLU)
      INTEGER NDIRS(NBDIRS),NFECHS(NBFECH)
      INTEGER NMOBIL(NBMOBS,2),NFRAYS(NBFRAY)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NPOINS,NREFS(NPOINS)
      INTEGER NBFACE,NREFAC(NELEMS,NBFACE)
      INTEGER NDMATS,NODES(NELEMS,NDMATS)
C
C.. Variables internes
      INTEGER NUMREF,N,N1
      INTEGER NCOU,NDIR,NPR,NMOB
      INTEGER NFC,NFF,NFE,NFA,NBP
      LOGICAL ERR
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      DO 1 N=1,NBCOUS
        NCOUPS(N) = 0
    1 CONTINUE
C
      DO 2 N=1,NELEMS
        NFCOUS(N) = 0
    2 CONTINUE
C
      DO 3 N=1,NBFFLU
        NFFLUS(N) = 0
    3 CONTINUE
C
      DO 4 N=1,NBDIRS
        NDIRS(N) = 0
    4 CONTINUE
C
      DO 5 N=1,NBFECH
        NFECHS(N) = 0
    5 CONTINUE
C
      DO 7 N=1,NBFRAY
        NFRAYS(N) = 0
    7 CONTINUE
C
      DO 8 N=1,NBPRIO*(1+NBCOPR)
        NPRIOS(N,1) = 0
    8 CONTINUE
C
      DO 9 N=1,NBMOBS*2
        NMOBIL(N,1) = 0
    9 CONTINUE
C
      NBP = 6
C
C
      NCOU = 0
      NFC = 0
      NFF = 0
      NFE = 0
      NDIR = 0
      NFA = 0
      NPR = 0
      NMOB = 0
C
C
C
C     2- COMPTE DES NOEUDS SUIVANT LES CL
C     ===================================
C
C
      DO 200 N=1,NPOINS
C
        NCOU = NCOU + 1
        NCOUPS(NCOU) = N
C
C
        NUMREF = ABS(NREFS(N))
C
        DO 210 N1=1,NRFMAX
C
           IF (IREFSD(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NDIR = NDIR + 1
              NDIRS(NDIR) = N
           ENDIF
C
           IF (IREFPR(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NPR  = NPR  + 1
              NPRIOS(NPR,1) = N
           ENDIF
C
           IF (IREFMO(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NMOB = NMOB + 1
              NMOBIL(NMOB,1) = N
           ENDIF
C
  210   CONTINUE
  200  CONTINUE
C
C
C     3- COMPTE DES FACES (ET EVENT NOEUD) SUIVANT LES CL             
C     ===================================================

      DO 310 N=1,NELEMS
C
         NUMREF = NREFAC(N,1)
C
         DO 320 N1=1,NRFMAX
C
           IF (IREFSC(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFC = NFC + 1
              NFCOUS(NFC) = N
           ENDIF
C
           IF (IREFSF(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFF = NFF + 1
              NFFLUS(NFF) = N
           ENDIF
C
           IF (IREFSE(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFE = NFE + 1
              NFECHS(NFE) = N
           ENDIF
C
           IF (IREFRA(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFA = NFA + 1
              NFRAYS(NFA) = N
           ENDIF
C
  320  CONTINUE
  310 CONTINUE
C
C
C     4- CONTROLE DES DIMENSIONS
C     ==========================
C
      ERR = .FALSE.
C
      IF (NCOU.NE.NBCOUS) THEN
         WRITE(NFECRA,4000) 'noeuds couples',NCOU,NBCOUS
         ERR = .TRUE.
      ENDIF
      IF (NDIR.NE.NBDIRS) THEN
         WRITE(NFECRA,4000) 'noeuds Dirichlet',NDIR,NBDIRS
         ERR = .TRUE.
      ENDIF
      IF (NPR .NE.NBPRIO) THEN
         WRITE(NFECRA,4000) 'noeuds periodiques',NPR ,NBPRIO
         ERR = .TRUE.
      ENDIF
      IF (NMOB.NE.NBMOBS) THEN
         WRITE(NFECRA,4000) 'noeuds en mouvement',NMOB ,NBMOBS
         ERR = .TRUE.
      ENDIF
C
C
      IF (NFC.NE.NELEMS) THEN
         WRITE(NFECRA,4000) 'faces couplees',NFC,NELEMS
         ERR = .TRUE.
      ENDIF
      IF (NFF.NE.NBFFLU) THEN
         WRITE(NFECRA,4000) 'faces avec flux',NFF,NBFFLU
         ERR = .TRUE.
      ENDIF
      IF (NFE.NE.NBFECH) THEN
         WRITE(NFECRA,4000) 'faces avec coefficient d''echange',
     &                      NFE,NBFECH
         ERR = .TRUE.
      ENDIF
      IF (NFA.NE.NBFRAY) THEN
         WRITE(NFECRA,4000) 'faces avec rayonnement',NFA,NBFRAY
         ERR = .TRUE.
      ENDIF
C
C
C     5- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0)
     *  WRITE(NFECRA,5000) NBCOUS,NELEMS,NBFFLU,NBDIRS,
     *                     NBFECH,NBFRAY,
     *                     NBPRIO,NBMOBS
C
      IF (NBLBLA.EQ.10) THEN
        IF (NBCOUS.GT.0) THEN
          WRITE(NFECRA,5010) 
          WRITE(NFECRA,5001) (NCOUPS(N),N=1,NBCOUS)
        ENDIF
        IF (NBDIRS.GT.0) THEN
          WRITE(NFECRA,5020) 
          WRITE(NFECRA,5001) (NDIRS(N),N=1,NBDIRS)
        ENDIF
        IF (NBPRIO.GT.0) THEN
          WRITE(NFECRA,5050) 
          WRITE(NFECRA,5001) (NPRIOS(N,1),N=1,NBPRIO)
        ENDIF
        IF (NBMOBS.GT.0) THEN
          WRITE(NFECRA,5060) 
          WRITE(NFECRA,5001) (NMOBIL(N,1),N=1,NBMOBS)
        ENDIF
C
C
        IF (NELEMS.GT.0) THEN
          WRITE(NFECRA,5110) 
          WRITE(NFECRA,5001) (NFCOUS(N),N=1,NELEMS)
        ENDIF
        IF (NBFFLU.GT.0) THEN
          WRITE(NFECRA,5120) 
          WRITE(NFECRA,5001) (NFFLUS(N),N=1,NBFFLU)
        ENDIF
        IF (NBFECH.GT.0) THEN
          WRITE(NFECRA,5130) 
          WRITE(NFECRA,5001) (NFECHS(N),N=1,NBFECH)
        ENDIF
        IF (NBFRAY.GT.0) THEN
          WRITE(NFECRA,5150) 
          WRITE(NFECRA,5001) (NFRAYS(N),N=1,NBFRAY)
        ENDIF

      ENDIF
C
C     6- ARRET DU PROGRAMME EN CAS D'ERREUR DE DIMENSION
C     ==================================================
      IF (ERR) STOP

C--------
C FORMATS
C--------
C
 5000 FORMAT(/,' *** LIMFCO : Solide, nombre de ...:',/,
     &  8X,'- noeuds couples avec le fluide',23X,I6,/,
     &  8X,'- faces couplees avec le fluide',23X,I6,/,
     &  8X,'- faces avec condition de type flux',19X,I6,/, 
     &  8X,'- noeuds avec condition de Dirichlet',18X,I6,/, 
     &  8X,'- faces avec condition de type coefficient',
     &        ' d''echange  ',I6,/,
     &  8X,'- faces avec rayonnement',30X,I6,/,
     &  8X,'- noeuds periodiques',34X,I6,/,
     &  8X,'- noeuds en mouvement',33X,I6)
C 
 4000 FORMAT(/,' %% ERREUR LIMFCO : incoherence sur les ',A,/,
     &       '                    On en compte :',I9,/,
     &       '                    Il y en a ',I9,' de declare(e)s')
 5001 FORMAT(12I6)
 5010 FORMAT(/,'  Liste des noeuds solides couples :',/)
 5020 FORMAT(/,'  Liste des noeuds solides avec Dirichlet :',/)
 5050 FORMAT(/,'  Liste des noeuds solides periodiques :',/)
 5060 FORMAT(/,'  Liste des noeuds solides en mouvement :',/)
C
 5110 FORMAT(/,'  Liste des faces solides couplees  :',/)
 5120 FORMAT(/,'  Liste des faces solides avec flux :',/)
 5130 FORMAT(/,'  Liste des faces solides avec coefficient',
     &         ' d''echange :',/)
 5150 FORMAT(/,'  Liste des faces solides avec rayonnement')
C
C----
C FIN
C----
      END
