C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECSI2
C                       *****************
C
C     --------------------------------------------------------------
     *(NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN,IREF,INOEUD,IFACE,IELT,
     * NT5,IT5)
C     --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE SIMAIL                  *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C             Modifications par Y. Fournier pour prendre en compte     *
C             les aspects binaires Linux                               *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : LCOODP,CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "mobil.h"
#include "nlofct.h"
#include "divct.h"
#include "optct.h"
C
C***********************************************************************
C 
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN,NT5
      INTEGER IREF(NPOINS),INOEUD(NELEMS*NN),IFACE(NELEMS*NBFACE)
      INTEGER IELT(NELEMS),IT5(NT5)
C
C.. Variables internes
      INTEGER NDIMEF,NDSR,NDSD,NCOPNP
      INTEGER I,J,M(32),NU(10)
      INTEGER LE,L,NTRI,NTET,NT3
      INTEGER NBFAC,NBARET,NBSOM,IDEB,NNO,NPO,INING,NUMREF
      INTEGER IDEBE,NMAE,NDSDE
      LOGICAL ERR
C
      CHARACTER*4 CHAR4
      INTEGER NFSISY(4)
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C
C***********************************************************************
C     numerotation des faces d'un tetraedre dans SIMAIL :
C          face 1 : 1 3 2
C          face 2 : 1 4 3
C          face 3 : 1 2 4
C          face 4 : 2 3 4
C***********************************************************************
C
      DATA NFSISY /1,3,2,4/
C
C     0- INITIALISATIONS
C     ==================
      IF (NDIELE.EQ.2) THEN
         NBFAC=0
         NBARET=3
         NBSOM=3
         NN=6
      ELSE       
         NBFAC=4
         NBARET=6
         NBSOM=4
         NN=10
      ENDIF
C
#ifdef HAVE_C_IO
      CALL REWDBF (NFSGCT, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      REWIND (NFSGCT)
#endif
C
C     1- LECTURE DE L'ENREGISTREMENT AVANT LE TABLEAU 0
C     =================================================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      READ(NFSGCT,ERR=999) LE
#endif
C
C     Lecture du tableau "-1"
#ifdef HAVE_C_IO
      CALL REWDBF (NFSGCT, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, L, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      REWIND (NFSGCT)
      READ (NFSGCT,ERR=999) L, (M(I), I=1,LE)
#endif
      NT3=M(5)
C
C     2- LECTURE DU TABLEAU 0
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGCT,ERR=999) LE, (M(I), I=1,LE)
#endif
C
C     3- LECTURE DU TABLEAU 2
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGCT,ERR=999) LE,(M(I),I=1,LE)
#endif
C
      NDIMEF = M(1)
      NDSR = M(2)
      NDSD = M(3)
      NCOPNP = M(4)
      NELEMS = M(5)
      NTRI = M(8)
      NTET = M(10)
      NPOINS = M(15)
      NPSSP1 = M(22)
C
C     5- LECTURE DES TABLEAUX 3, 4 ET 5
C     =================================
C
C     5.0- Tableau 3
C     --------------
#ifdef HAVE_C_IO
      IF (NT3.GT.0) THEN
         NBRLUS = 0
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         IF (NBRLUS .LT. NBRTOT) THEN
            CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDIF
      ENDIF
#else
      IF (NT3.GT.0) READ(NFSGCT,ERR=999) LE
#endif

C     5.1- Tableau 4
C     --------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGCT,ERR=999) LE
#endif
C
C     5.2- Tableau 5
C     --------------
C
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, IT5, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGCT,ERR=999) LE,(IT5(I), I=1,LE)
#endif
C
C     5.3- Decryptage des references des noeuds
C     -----------------------------------------
C     
C
      IDEB = 0
C
      DO 530 I=1,NELEMS
C
         IDEBE = IDEB
C
         NMAE  = IT5(IDEB+2)
C
         NDSDE = IT5(IDEB+3)
         IELT(I) = NDSDE
C        En coque, ce numero sert de reference de face
         IF (NCTHFS.EQ.2) IFACE(I) = NDSDE
C
         NNO   = IT5(IDEB+4)
         DO 535 J=1,NNO
            NU(J) = IT5(IDEB+4+J)
            INOEUD((J-1)*NELEMS+I) = IT5(IDEB+4+J)
  535    CONTINUE
         NPO   = IT5(IDEB + 4 + NNO + 1)
C
         IF (NMAE.EQ.0) THEN
            IDEB = IDEB + 4 + NNO + 1 + NPO
         ELSE
            INING = IT5(IDEB + 4 + NNO + 1 + NPO + 1)
            IDEB = IDEB + 4 + NNO + 1 + NPO + 1
C         
            IF (INING.EQ.1 .AND. NDIELE.EQ.3) THEN
              DO 536 J=1,NBFAC
                IFACE((NFSISY(J)-1)*NELEMS+I) = IT5(IDEB + J)
  536         CONTINUE
            ENDIF
            IF (INING.EQ.1) IDEB = IDEB + NBFAC
C
            IF (INING.LE.2) THEN
              DO 532 J=1,NBARET
                 NUMREF = IT5(IDEB+J)
                 IREF(NU(NBSOM+J)) = NUMREF
                 IF (NDIELE.EQ.2 .AND. NCTHFS.NE.2) 
     &                        IFACE((J-1)*NELEMS+I) = NUMREF
  532         CONTINUE
              IDEB = IDEB + NBARET
            ENDIF
C
            IF (INING.LE.3) THEN
              DO 534 J=1,NBSOM
                 NUMREF = IT5(IDEB+J)
                 IREF(NU(J)) = NUMREF
  534         CONTINUE
              IDEB = IDEB + NBSOM
            ENDIF
C
          ENDIF
C
  530 CONTINUE
C
C
      RETURN
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
#else
 999  CONTINUE
      WRITE(NFECRA,9999)
      STOP
#endif
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT('  %% ERREUR LECSI2 : LE FICHIER NE CONTIENT PAS UNE S.D.',
     &       ' DE MAILLAGE ')
 1018 FORMAT('  %% ERREUR LECSI2 : DIMENSION DES MAILLAGES ',
     &       'INCOMPATIBLES')
 1020 FORMAT('  %% ERREUR LECSI2 : NUMERO(S) DE REFERENCES > 32')      
 1021 FORMAT('  %% ERREUR LECSI2 : NUMERO(S) DE SOUS-DOMAINES > 16')      
 1022 FORMAT('  %% ERREUR LECSI2 : LE MAILLAGE NE POSSEDE PAS DE'
     &                             ,' NOEUDS MILIEUX')      
 1023 FORMAT('  %% ERREUR LECSI2 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES')
C 
 3000 FORMAT(/,'%% ERREUR LECSI2 : LA DIMENSION DU TABLEAU DES ENTIERS',
     &         ' EST INSUFFISANTE ',/,
     &         '                   IL FAUT AU MINIMUM ',I9,' ENTIERS ')
 3010 FORMAT(/,'%% ERREUR LECSI2 : LA DIMENSION DU TABLEAU DES REELS',
     &         ' EST INSUFFISANTE ',/,
     &         '                   IL FAUT AU MINIMUM ',I9,' REELS ')
C 
 7010 FORMAT(/,'%% ERREUR LECSI2 : ERREUR DE MAILLAGE',/,
     &       20X,'En modele coque, toute la coque doit etre couplee ',
     &           'au fluide',/,
     &       20X,'Ici, la coque comporte ',I9,' elements',/,
     &       20X,'Il y en a ',I9,' de declares couples')
 7020 FORMAT(/,'%% ERREUR LECSI2 : ERREUR DE MAILLAGE',/,
     &       20X,'En modele coque, toute la coque doit etre couplee ',
     &           'au fluide',/,
     &       20X,'Ici, la coque comporte ',I9,' noeuds',/,
     &       20X,'Il y en a ',I9,' de declares couples')
#ifdef HAVE_C_IO
 9998 FORMAT(' %% ERREUR LECSI2 : erreur de lecture du maillage ',
     *       ' solide',/,'    de type : ',A)
#else
 9999 FORMAT(' %% ERREUR LECSI2 : erreur de lecture du maillage ',
     *       ' solide')
#endif
C
      END

