/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "tree.h"
# include "abs.h"
# include "interfaces.h"


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | ivoitj_3d                                                            |
  |         Detecter si deux point se voient                             |
  |======================================================================| */

void ivoitj_3d(struct node *arbre, struct node *noeud, struct node *noeud_arr,
	       double ro[],double rd[],double pt_arr[],int *intersect, double size_min,
	       int nelray, int npoinr, int *nodray, double * cooray, int *arrivee,
	    double dim_boite[])
{

    struct element *fa1;
    int numel;
    struct node  *n_en_cours;  /*    int n_en_cours;*/
    double xv,yv,zv,epsi;

    fa1 = noeud->lelement;
    n_en_cours =  noeud;   /*    n_en_cours =  noeud->name;*/
    epsi=1.E-6;

  /*  printf(">>> ivoitj_3d : on est dans la boite %d\n", noeud->name); 
    printf(">>> ivoitj_3d : xmin,xmax,ymin,ymax,zmin,zmax %f %f %f %f %f %f \n", 
	   noeud->xc-noeud->size,noeud->xc+noeud->size, 
	   noeud->yc-noeud->size,noeud->yc+noeud->size, 
	   noeud->zc-noeud->size,noeud->zc+noeud->size ); */

 /*   printf(" on est dans la boite %d \n", noeud->name); */
    if (abs(rd[0])<epsi && abs(rd[1])<epsi && abs(rd[2])<epsi)
      *arrivee = 1;
    else
      while (fa1 != NULL)
	{
	  numel = fa1->num;
	  /*	    printf(" on teste la facette %d\n",numel); */

 /*      printf(" ro, rd %f %f %f %f %f %f  \n", ro[0],ro[1],ro[2],rd[0]*1.e6,rd[1]*1.e6,rd[2]*1.e6); */
	  *intersect = ray_inter_triangle(arbre,n_en_cours,numel,ro,rd,
					    npoinr,nelray,nodray,cooray,arrivee);

	  if (*intersect==0)
	    {
	      fa1 = fa1->suivant;
	      continue;
	    }
	  else
	    {
	      /* printf(" >>> ivoitj_3d : intersection  avec l'element %d \n",*intersect); */
	      break;
	    }
	  
	} /* fin du while */
  



/* printf(" >> ivoitj_3d : test d'intersection : *intersect %d *arrivee %d\n", *intersect,*arrivee);*/
/*    if (!( *intersect || *arrivee ||(noeud->name==noeud_arr->name) )) */
    if (!( *intersect || *arrivee ||(noeud==noeud_arr) ))
	{
	    voxel_voisin_3d(&xv,&yv,&zv,noeud->xc,noeud->yc,noeud->zc,
			 noeud->sizx,noeud->sizy,noeud->sizz,
			 ro,rd,pt_arr,size_min);
	    if (abs(rd[0])<epsi && abs(rd[1])<epsi && abs(rd[2])<epsi)
	      {
		*arrivee=1;
		*intersect=0;
	/*	printf(" >> ivoitj_3d : on sort par rd nul\n"); */
	      }
	    else
	      {
		noeud = arbre;
		find_node_3d(&noeud,xv,yv,zv);
		if (in_boite(xv,yv,zv,dim_boite[0],dim_boite[1],
			     dim_boite[2],dim_boite[3],
			     dim_boite[4],dim_boite[5]))
		  ivoitj_3d(arbre,noeud,noeud_arr,ro,rd,pt_arr,intersect,size_min,
			 nelray,npoinr,nodray,cooray,arrivee,dim_boite);
		else
		  {
		    *intersect=0;
	/*	    printf(" >> ivoitj_3d : on est sorti de la boite\n"); */
		  }
	      }
	}
}






/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | ray_inter_triangle                                                   |
  |         detection de l'intersection entre un rayon et un triangle    |
  |======================================================================| */
int ray_inter_triangle(struct node *arbre,struct node  *n_en_cours,
		       int numel,double ro[],double rd[],
		       int npoinr,int nelray,int *nodray,double *cooray,
		       int *arrivee)
{

  int nelray2,npoinr2,na,nb,nc,i,j,k;
  double xa,ya,za,xb,yb,zb,xc,yc,zc,xab,yab,zab,xac,yac,zac;
  double a,b,c,d,t,den,epsi,xp,yp,zp,xn,den1;
  struct node *noeud;

  epsi=1.E-4;    
  npoinr2 = npoinr*2;    nelray2 = nelray*2;


  na = *(nodray+numel-1); nb = *(nodray+numel-1+nelray); 
  nc = *(nodray+numel-1+nelray2);
  xa= *(cooray+na-1); ya= *(cooray+na-1+npoinr); za= *(cooray+na-1+npoinr2);
  xb= *(cooray+nb-1); yb= *(cooray+nb-1+npoinr); zb= *(cooray+nb-1+npoinr2);
  xc= *(cooray+nc-1); yc= *(cooray+nc-1+npoinr); zc= *(cooray+nc-1+npoinr2);

  /* equation du plan du triangle */
  xab = xb-xa; yab = yb-ya; zab = zb-za;
  xac = xc-xa; yac = yc-ya; zac = zc-za;
  a = yab*zac-zab*yac;
  b = zab*xac-xab*zac;
  c = xab*yac-yab*xac;
  xn=sqrt(a*a+b*b+c*c);
  a /=xn; b /=xn; c /=xn;
  d = -(a*xa+b*ya+c*za);

  den = a*rd[0]+b*rd[1]+c*rd[2];
  den1=den/(sqrt(rd[0]*rd[0]+rd[1]*rd[1]+rd[2]*rd[2]));



 /*  printf( " den %f \n",den);*/

  if (abs(den1)<epsi)
      return(0);
  
  t = - (d  + a*ro[0]+b*ro[1]+c*ro[2] ) / den;   
  
/*  printf(" >> ray_inter_tria t = %f \n", t);   */

  if (t<epsi)     /* ==> le plan du triangle est derriere => pas d'intersection */
      return(0);

  else if (t>(1+epsi)) /* ==> le plan du triangle est trop loin  => pas d'intersection */
      return(0);


  xp = ro[0]+t*rd[0];  yp = ro[1]+t*rd[1]; zp = ro[2]+t*rd[2]; /* intersection */
  if (in_triangle(a,b,c,d,xa,ya,za,xab,yab,zab,xac,yac,zac,xp,yp,zp))
    {
      if (abs(t-1.)<epsi) 
	{      
	  noeud = arbre;
	  find_node_3d(&noeud,xp,yp,zp);
/*	  printf("recherche preliminaire : %d\n",noeud->name); */
	  for (i=-1;i<2;i=i+2)
	    for (j=-1;j<2;j=j+2)
	      for (k=-1;k<2;k=k+2)
		{
		  noeud = arbre;
		  find_node_3d(&noeud,xp+epsi*i,yp+epsi*j,zp+epsi*k);
/*		  printf("i,j,k,noeud->name n_en_cours %d %d %d %d %d xp yp zp %f %f %f \n",
			 i,j,k,noeud->name,n_en_cours,xp,yp,zp); */

		  if (noeud == n_en_cours) 
		    {*arrivee = 1;}
		}

	  return(0); 
	}
      else
	return(numel);
    }
  else
    return(0);
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | voxel_voisin_3d                                                      |
  |         Recherche du voxel voisin                                    |
  |======================================================================| */

void voxel_voisin_3d (double *xv,double *yv, double *zv, 
		      double xc, double yc, double zc,
		      double dx,double dy,double dz,
		      double ro[], double rd[], double pt_arr[],
		      double size_min)

{
    int it;
    double t,tt[3],orient[3],xpi,ypi,zpi,ddx,ddy,ddz,size,epsv,xn;

    size = size_min/4.;
    epsv=1.E-10;

    if (abs(rd[0])<epsv)
	tt[0] = 1.E6;  
    else
	{
	    t=(xc+dx-ro[0])/rd[0]; tt[0]=t; orient[0] = 1.;                  /* plan x=xc+dx */
	    t=(xc-dx-ro[0])/rd[0]; if(t>tt[0]) {tt[0]=t; orient[0] = -1.;}   /* plan x=xc-dx */
	}

    if (abs(rd[1])<epsv)
	tt[1] = 1.E6;  
    else
	{
	    t=(yc+dy-ro[1])/rd[1]; tt[1]=t; orient[1] = 1.;                  /* plan y=yc+dy */
	    t=(yc-dy-ro[1])/rd[1]; if(t>tt[1]) {tt[1]=t; orient[1] = -1.;}   /* plan y=yc-dy */
	}

    if (abs(rd[2])<epsv)
	tt[2] = 1.E6;  
    else
	{
	    t=(zc+dz-ro[2])/rd[2]; tt[2]=t; orient[2] = 1.;                  /* plan z=zc+dz */
	    t=(zc-dz-ro[2])/rd[2]; if(t>tt[2]) {tt[2]=t; orient[2] = -1.;}   /* plan z=zc-dz */
	}


    it = 0; t=tt[0];
    if (tt[1]<t) {it=1; t= tt[1];}
    if (tt[2]<t) {it=2; t= tt[2];}

    xpi = ro[0] + t*rd[0]; ypi = ro[1] + t*rd[1]; zpi = ro[2] + t*rd[2];

    if (abs(tt[0]-tt[1])<epsv && abs(tt[2]-tt[1])<epsv)
	{ddx=orient[0]*size; ddy=orient[1]*size; ddz=orient[2]*size;}

    else if (abs(tt[0]-tt[1])<epsv && abs(tt[0]-t)<epsv)
	{ddx=orient[0]*size; ddy=orient[1]*size; ddz=0.;}

    else if (abs(tt[2]-tt[1])<epsv && abs(tt[1]-t)<epsv)
	{ddx=0.; ddy=orient[1]*size; ddz=orient[2]*size;}

    else if (abs(tt[2]-tt[0])<epsv && abs(tt[0]-t)<epsv)
	{ddx=orient[0]*size; ddy=0. ; ddz=orient[2]*size;}

    else if (it==0)
	{ddx=orient[0]*size; ddy=0. ; ddz=0.;}

    else if (it==1)
	{ddx=0.; ddy=orient[1]*size; ddz=0.;}

    else if (it==2)
	{ddx=0.; ddy=0. ; ddz=orient[2]*size;}


    if (abs(xpi-ro[0])<epsv && abs(ypi-ro[1])<epsv  && abs(zpi-ro[2])<epsv )
	{
	    xn = sqrt(rd[0]*rd[0]+rd[1]*rd[1]+rd[2]*rd[2]);
	    *xv = xpi + rd[0]/xn*size;        
	    *yv = ypi + rd[1]/xn*size;    
	    *zv = zpi + rd[2]/xn*size;    
	}
    else
	{
	    *xv = xpi + ddx;         
	    *yv = ypi + ddy;
	    *zv = zpi + ddz;
	}

    ro[0] = xpi;
    ro[1] = ypi;
    ro[2] = zpi;

    rd[0] = pt_arr[0] - xpi;
    rd[1] = pt_arr[1] - ypi;
    rd[2] = pt_arr[2] - zpi;   
/*    printf(">>> ivoitj_3d : intersection avec boite %f %f %f \n",xpi,ypi,zpi);  */


}
