C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=EVAFAC,SSI=0
C
                        SUBROUTINE EVAFAC
C                       *****************
C
C     -------------------------------------------------------
     * (NN,NDIELE,NELE,NREFAC,LFFLU,LFCOU,LFRES,LFRAY,NBFACE)
C     -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       EVALUATION DES TYPES DE FACETTES D'UN ELEMENT EN 2D ET 3D      *
C       On utilise ici les references des facettes                     *
C       Les facttes peuvent etre :                                     *
C               - couplees                                             *
C               - avec condition de flux                               *
C               - avec condition d'echange mais portant des Dirichlet  *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NN     !   E  ! D  ! NUMERO DE L'ELEMENT COURANT                 !
C   ! NELE   !   E  ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE               !
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS                      !
C   ! NREFAC !   E  ! M  ! REFERENCES DES FACES (ARETES EN 2D)         !
C   ! LFFLUi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS AVEC CONDITION DE FLUX           !
C   ! LFCOUi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS COUPLES                          !
C   ! LFRESi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS AVEC RESIST DE CONTACT           !
C   ! LFRAYi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS AVEC RAYONNEMENT                 !
C   ! NBFACE !   E  ! D  ! NOMBRE DE FACES DES ELEMENTS                !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : XMAILL 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
C
C**********************************************************************
C
      INTEGER NDX
      PARAMETER (NDX= 10)
C
C.. Variables externes
      INTEGER NN,NDIELE,NELE,NBFACE,NREFAC(NELE,NDIELE+1)
      LOGICAL LFFLU(NBFACE),LFCOU(NBFACE),LFRES(NBFACE),LFRAY(NBFACE)

C.. Variables internes
      INTEGER NR(NDX),M,L,N
C
C**********************************************************************
C
C     0. INITIALISATIONS
C     ==================
C
      DO N=1,NBFACE
        LFFLU(N) = .FALSE.
        LFCOU(N) = .FALSE.
        LFRES(N) = .FALSE.
        LFRAY(N) = .FALSE.
        NR(N) = NREFAC(NN,N)
      ENDDO

C
C     1. BOUCLE SUR LES FACES
C     =======================
C
       DO L=1,NBFACE
        DO M=1,NRFMAX
C
        IF ( IREFSC(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFSF(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFSE(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRE(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRI(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRA(M).NE.0 .AND. ABS(NR(L)).EQ.M )
     &       LFFLU(L) = .TRUE.
C
         IF ( IREFSC(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LFCOU(L) = .TRUE.
C
         IF ( IREFRE(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LFRES(L) = .TRUE.
C
         IF ( IREFRA(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LFRAY(L) = .TRUE.
C
        ENDDO
      ENDDO
C
C
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END

