# PlaylistParserPLS.py 
#  
#  Copyright (c) 2005 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import urllib
import pyid3lib
import os
import sys
import gtk
import Utils

def parse_playlists(dev_path):
	playlists = []
	songs = []
	playlist_size = 0
	playlist_name = u"Unknown"

	path = dev_path + "/Music"
	
	if os.path.exists(path) and os.path.isdir(path):
		for file in os.listdir(path):

			if file.endswith("pls") and not file.startswith("."):
				playlist_name = file.split (".pls")[0]

				pls = open(path + "/" + file, "r")

				lines = pls.readlines()[:]

				playlists.append( [playlist_name, playlist_size, songs] )

				for line in lines:
					if line.startswith ("File"):
						song_location = dev_path + "/Music/" + line.split("=")[1].strip("\n")

						if not os.path.exists(song_location):
							continue

						song_size = Utils.get_song_size(song_location)
						playlists[-1][1] += song_size

						songs.append( (song_location, song_size) )
		
				pls.close()

	return playlists
