"""symeig test module.

Run all tests with:
>>> import symeig
>>> symeig.test()

"""

import sys
import numpy
import unittest
import test_symeig

_err_str = """\nIMPORTANT: some tests use random numbers. This could
occasionally lead to failures due to numerical degeneracies.
To rule this out, please run the tests more than once.
If you get reproducible failures please report a bug!
"""

test_suites = {'symeig': test_symeig.get_suite()}

def test(suitename = 'all', verbosity = 2, seed = None):
    if seed is None:
        seed = int(numpy.random.randint(2**31-1))

    numpy.random.seed(seed)
        
    sys.stderr.write("Random Seed: " + str(seed)+'\n')
    if suitename == 'all':
        suite = unittest.TestSuite(test_suites.values())
    else:
        suite = test_suites[suitename]
    res = unittest.TextTestRunner(verbosity=verbosity).run(suite)
    if len(res.errors+res.failures) > 0:
        sys.stderr.write(_err_str)
    sys.stderr.write("\nRandom Seed was: " + str(seed)+'\n')
