#!/usr/bin/env python
"""Run all tests"""

__author__ = "Martin Alnes <martinal@simula.no>"
__date__ = "2008-09-04 -- 2008-09-04"

import os, glob

# disable most log output
import sfc
sfc.set_logging_level("error")

# define test set
tests = glob.glob("*.py")
skip = set(["test.py", "template.py", "cell_assembly.py"])
tests = (t for t in tests if not (t in skip or t.startswith("_")))

# two ways of running tests
separate = True
if separate:
    # run all test from commandline (separate python processes)
    for test in tests:
        cmd = "python %s" % test
        print "Running '%s'" % cmd
        os.system(cmd)
else:
    # collect test classes
    classes = []
    for test in tests:
        classes.extend(test.tests)

    # run all tests
    verbosity = 0
    suites = [unittest.makeSuite(c) for c in classes]
    testsuites = unittest.TestSuite(suites)
    unittest.TextTestRunner(verbosity=verbosity).run(testsuites)

