
import math 
from dolfin import *

dolfin_set("form compiler", "sfc")

class Source(Function): 
    def eval(self, values, x): 
        values[0] = -1.0+((0.5)*x[0]+(0.5)*x[1])**6


class Solution(Function): 
    def eval(self, values, x): 
        values[0] = (0.5*(x[0] + x[1]))**2     

class DirichletBoundary(SubDomain): 
    def inside(self, x, on_boundary): 
        return bool(on_boundary)

# Geometry
N = 80  
P = 4 

mesh = UnitSquare(N,N)

# Function spaces
X = FunctionSpace(mesh, 'CG', 1)

# function 
U = Function(X)

# Basis functions 
v = TestFunction(X)
u = TrialFunction(X)

# Source term 
source = Source(X)

# Forms
L = inner(grad(U),grad(U))*dx + U**P*dx + source*U*dx 
F = derivative(L, U, v)
J = derivative(F, U, u)

# Analytical solution 
solution = Solution(X)
sol = project(solution,X)


# Solve nonlinear variational problem
dirichlet_boundary = DirichletBoundary()
bc = DirichletBC(X, solution, dirichlet_boundary)
#problem = VariationalProblem(J, F, bc, nonlinear=True)

problem = VariationalProblem(J, F, bc, nonlinear=True)
problem.solve(U)

plot(sol)
plot(U)
interactive()

# Write solution to file
file = File("u.pvd") 
file << U 

file = File("u0.pvd") 
file << sol 


