/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SCANTHREAD_H
#define SCANTHREAD_H


#include "scanning.h"
#include "config.h"
#include "myevents.h"
#include "swsglobals.h"

#include <kmainwindow.h>

#include <qthread.h>
#include <qmutex.h>
#include <iostream>

using namespace std;

/**
@author Ivn Forcada Atienza
*/
class ScanThread : public QThread {
private:
	 KMainWindow*	parentobject;
	 const char * 	objname;
	 char 		iface[32];
	 QMutex 	mut;
public:
	ScanThread(KMainWindow * p, const char * n, char * ifc = "lo");
	~ScanThread();
	
	virtual void run();
	void setIface(char * i);
	char * getIface(char * temp);
	const char * name() { return objname; };
	void setName(const char * n ) { objname = qstrdup(n); };
	KMainWindow * parent() { return parentobject; }; 	

};

#endif
