//
// C++ Implementation: configpopupmenu
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "configpopupmenu.h"

configPopupMenu::configPopupMenu(QWidget *parent, const char *name, QString e, QString m, bool w, QString ifc) : KPopupMenu(parent, name)
{
	qDebug("Creating configPopupMenu (%s)...", m.ascii());

	essid = e;
	mac = m;
	iface = ifc;
	wep = w;
	shownConfiguredMenu = false;
	apActions = new KActionCollection (this, "apActions");

	this->insertTitle(SmallIcon(wep?"redled":"greenled"), "  " + essid + " (" + mac + ")", -1, 0);
	//Create actions:
	asociateAction = new KAction(i18n("Asociate with") + " " + iface, "connect_creating", KShortcut("Ctrl+A"), parentWidget(),
				SLOT(asociate()), apActions, "action_asociate");
	asociateAction->plug(this);
	this->insertSeparator();

	showChartAction = new KAction(i18n("Show chart"), "color_line", KShortcut("Ctrl+G"), parentWidget(),
				SLOT(showChart()), apActions, "action_showchart");
	showChartAction->plug(this);
	this->insertSeparator();

	configureAction = new KAction(i18n("Configure"), "edit", KShortcut("Ctrl+C"), parentWidget(),
				SLOT(showConfig()), apActions, "action_configure");
	configureAction->plug(this);
	changeAction = new KAction(i18n("Change configuration"), "edit", KShortcut("Ctrl+M"), parentWidget(),
				SLOT(showConfig()), apActions, "action_change");
	changeAction->plug(this);
	removeAction = new KAction(i18n("Remove configuration"), "eraser", KShortcut("Ctrl+D"), parentWidget(),
				SLOT(removeConfig()), apActions, "action_revove");
	removeAction->plug(this);

	this->insertSeparator();
	this->insertItem( SmallIcon("cancel"), i18n("Cancel") );

	AddMenu(false); // Add a default menu, modified if necesary in update()
	update();	
}

configPopupMenu::~configPopupMenu()
{
	qDebug("Deleting configPopupMenu (%s)...", mac.ascii());

	asociateAction->unplugAll();
	changeAction->unplugAll();
	removeAction->unplugAll();
	showChartAction->unplugAll();
	configureAction->unplugAll();

	delete asociateAction;
	delete changeAction;
	delete removeAction;
	delete showChartAction;
	delete configureAction;
}

void configPopupMenu::update()
{
// 	qDebug ("Updating (%s)", mac.ascii());
	
	bool configured = isConfigured(essid, mac);
	
	if (configured != shownConfiguredMenu) // If something changed:
		AddMenu(configured);
}

void configPopupMenu::AddMenu(bool configured)
{ // Deletes the current menu and creates the right one

        if (configured)
	{
		asociateAction->setEnabled(TRUE);
		changeAction->setEnabled(TRUE);
		removeAction->setEnabled(TRUE);
		configureAction->setEnabled(FALSE);
		shownConfiguredMenu = true;
        }
	else
	{
		asociateAction->setEnabled(FALSE);
		changeAction->setEnabled(FALSE);
		removeAction->setEnabled(FALSE);
		configureAction->setEnabled(TRUE);
		shownConfiguredMenu = false;
	}
}

bool configPopupMenu::isConfigured(QString essid, QString mac)
{
	mac = mac;
	// Query that uses the default (and unique) database connection of the application
	QSqlQuery q("SELECT count(*) FROM networks WHERE essid = '" + essid + "'");
	if (q.lastError().type() != 0) 
	{	
		q.lastError().showMessage();
		return false;
	}
	q.first();
	if (q.value(0).toInt() > 0) 
		return true;	//if the mac exist in the db, then it has been already configured
	else
		return false;	//otherwise not
}
