/* $Id: mouse.c,v 1.1.1.1 2001/07/08 13:32:59 cegger Exp $
******************************************************************************

   SVGAlib wrapper for LibGGI - mouse handling

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <internal/svgaggi.h>

static int dowrap = 0;
static int scalefactor = 1;

static int buttons = 0;
static int cur_x = 0;
static int cur_y = 0;
static int cur_z = 0;
static int cur_rx = 0;
static int cur_ry = 0;
static int cur_rz = 0;

static int xmin = 0;
static int xmax = 32767;
static int ymin = 0;
static int ymax = 32767;
static int zmin = 0;
static int zmax = 32767;
static int rxmin = 0;
static int rxmax = 32767;
static int rymin = 0;
static int rymax = 32767;
static int rzmin = 0;
static int rzmax = 32767;


/*
***************************************************************************
 Internal routines
***************************************************************************
*/

static void
default_mousehandler(int button, int dx, int dy, int dz, int drx, int dry, int drz)
{
	cur_x += dx;
	cur_y += dy;
	cur_z += dz;
	buttons = button;
	if (cur_x / scalefactor > xmax) {
		if (dowrap & MOUSE_WRAPX) cur_x -= (xmax - xmin) * scalefactor;
		else cur_x = xmax * scalefactor;
	}
	if (cur_x / scalefactor < xmin) {
		if (dowrap & MOUSE_WRAPY) cur_x += (xmax - xmin) * scalefactor;
		else cur_x = xmin * scalefactor;
	}
	if (cur_y / scalefactor > ymax) {
		if (dowrap & MOUSE_WRAPX) cur_y -= (ymax - ymin) * scalefactor;
		else cur_y = ymax * scalefactor;
	}
	if (cur_y / scalefactor < ymin) {
		if (dowrap & MOUSE_WRAPY) cur_y += (ymax - ymin) * scalefactor;
		else cur_y = ymin * scalefactor;
	}
	if (cur_z / scalefactor > zmax) {
		if (dowrap & MOUSE_WRAPZ) cur_z -= (zmax - zmin) * scalefactor;
		else cur_z = zmax * scalefactor;
	}
	if (cur_z / scalefactor < zmin) {
		if (dowrap & MOUSE_WRAPZ) cur_z += (zmax - zmin) * scalefactor;
		else cur_z = zmin * scalefactor;
	}
	switch (dowrap & MOUSE_ROT_COORDS) {
	case MOUSE_ROT_INFINITESIMAL:
		cur_rx = drx;
		cur_ry = dry;
		cur_rz = drz;
		break;
	case MOUSE_ROT_RX_RY_RZ:
		cur_rx += drx;
		cur_ry += dry;
		cur_rz += drz;
		break;
	}
	if (cur_rx / scalefactor > rxmax) {
		if (dowrap & MOUSE_WRAPRX) {
			cur_rx -= (rxmax - rxmin) * scalefactor;
		} else {
			cur_rx = rxmax * scalefactor;
		}
	}
	if (cur_rx / scalefactor < rxmin) {
		if (dowrap & MOUSE_WRAPRX) {
			cur_rx += (rxmax - rxmin) * scalefactor;
		} else {
			cur_rx = rxmin * scalefactor;
		}
	}
	if (cur_ry / scalefactor > rymax) {
		if (dowrap & MOUSE_WRAPRY) {
			cur_ry -= (rymax - rymin) * scalefactor;
		} else {
			cur_ry = rymax * scalefactor;
		}
	}
	if (cur_ry / scalefactor < rymin) {
		if (dowrap & MOUSE_WRAPRY) {
			cur_ry += (rymax - rymin) * scalefactor;
		} else {
			cur_ry = rymin * scalefactor;
		}
	}
	if (cur_rz / scalefactor > rzmax) {
		if (dowrap & MOUSE_WRAPRZ) {
			cur_rz -= (rzmax - rzmin) * scalefactor;
		} else {
			cur_rz = rzmax * scalefactor;
		}
	}
	if (cur_rz / scalefactor < rzmin) {
		if (dowrap & MOUSE_WRAPRZ) {
			cur_rz += (rzmax - rzmin) * scalefactor;
		} else {
			cur_rz = rzmin * scalefactor;
		}
	}
}

void (*_ggigsw_mousehandler) (int, int, int, int, int, int, int)
	= default_mousehandler;


/*
***************************************************************************
 Exported functions
***************************************************************************
*/

int
mouse_init(char *dev, int type, int samplerate)
{
	mouse_init_return_fd(dev, type, samplerate);
	return 0;
}

int
mouse_init_return_fd(char *dev, int type, int samplerate)
{
	/* Reset mouse handler */
	_ggigsw_mousehandler = default_mousehandler;
	
	return 0; /* FIXME */
}

void
mouse_seteventhandler(__mouse_handler handler)
{
	_ggigsw_mousehandler = handler;
}

void
mouse_close(void)
{
}

int
mouse_update(void)
{
	return _ggigsw_getmouseevent(0);
}

void
mouse_waitforupdate(void)
{
	_ggigsw_getmouseevent(1);
}

void
mouse_setdefaulteventhandler(void)
{
	_ggigsw_mousehandler = default_mousehandler;
}

void
mouse_setposition(int x, int y)
{
	cur_x = x;
	cur_y = y;
}

void
mouse_setposition_6d(int x, int y, int z,
		     int rx, int ry, int rz, int dim_mask)
{
	if (dim_mask & MOUSE_XDIM) cur_x = x * scalefactor;
	if (dim_mask & MOUSE_YDIM) cur_y = y * scalefactor;
	if (dim_mask & MOUSE_ZDIM) cur_z = z * scalefactor;
	if (dim_mask & MOUSE_RXDIM) cur_rx = rx * scalefactor;
	if (dim_mask & MOUSE_RYDIM) cur_ry = ry * scalefactor;
	if (dim_mask & MOUSE_RZDIM) cur_rz = rz * scalefactor;
}

void
mouse_setxrange(int x1, int x2)
{
	xmin = x1;
	xmax = x2;
}

void
mouse_setyrange(int y1, int y2)
{
	ymin = y1;
	ymax = y2;
}

void
mouse_setrange_6d(int x1, int x2, int y1, int y2, int z1, int z2,
		  int rx1, int rx2, int ry1, int ry2, int rz1, int rz2,
		  int dim_mask)
{
	if (dim_mask & MOUSE_XDIM) {
		xmin = x1;
		xmax = x2;
	}
	if (dim_mask & MOUSE_YDIM) {
		ymin = y1;
		ymax = y2;
	}
	if (dim_mask & MOUSE_ZDIM) {
		zmin = z1;
		zmax = z2;
	}
	if (dim_mask & MOUSE_RXDIM) {
		rxmin = rx1;
		rxmax = rx2;
	}
	if (dim_mask & MOUSE_RYDIM) {
		rymin = ry1;
		rymax = ry2;
	}
	if (dim_mask & MOUSE_RZDIM) {
		rzmin = rz1;
		rzmax = rz2;
	}
}

void
mouse_setscale(int s)
{
	if (scalefactor > 0) {
		cur_x = (cur_x*s)/scalefactor;
		cur_y = (cur_y*s)/scalefactor;
		cur_z = (cur_z*s)/scalefactor;
		cur_rx = (cur_rx*s)/scalefactor;
		cur_ry = (cur_ry*s)/scalefactor;
		cur_rz = (cur_rz*s)/scalefactor;
		scalefactor = s;
	}
}

void
mouse_setwrap(int state)
{
	dowrap = state;
}

int
mouse_getx(void)
{
	return cur_x / scalefactor;
}

int
mouse_gety(void)
{
	return cur_y / scalefactor;
}

void
mouse_getposition_6d(int *x, int *y, int *z,
		     int *rx, int *ry, int *rz)
{
	if (x) *x = cur_x / scalefactor;
	if (y) *y = cur_y / scalefactor;
	if (z) *z = cur_z / scalefactor;
	if (rx) *rx = cur_rx / scalefactor;
	if (ry) *ry = cur_ry / scalefactor;
	if (rz) *rz = cur_rz / scalefactor;
}

int
mouse_getbutton(void)
{
	return buttons;
}
