/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class DropTableConstantAction
extends DDLSingleTableConstantAction {
    private final long conglomerateNumber;
    private final String fullTableName;
    private final String tableName;
    private final SchemaDescriptor sd;
    private final boolean cascade;

    DropTableConstantAction(String string, String string2, SchemaDescriptor schemaDescriptor, long l, UUID uUID, int n) {
        super(uUID);
        this.fullTableName = string;
        this.tableName = string2;
        this.sd = schemaDescriptor;
        this.conglomerateNumber = l;
        this.cascade = n == 0;
    }

    public String toString() {
        return "DROP TABLE " + this.fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Serializable serializable;
        TableDescriptor tableDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        if (this.sd != null && this.sd.getSchemaName().equals("SESSION")) {
            tableDescriptor = languageConnectionContext.getTableDescriptorForDeclaredGlobalTempTable(this.tableName);
            if (tableDescriptor == null) {
                tableDescriptor = dataDictionary.getTableDescriptor(this.tableName, this.sd);
            }
            if (tableDescriptor == null) {
                throw StandardException.newException("X0X05.S", this.fullTableName);
            }
            if (tableDescriptor.getTableType() == 3) {
                dependencyManager.invalidateFor(tableDescriptor, 1, languageConnectionContext);
                transactionController.dropConglomerate(tableDescriptor.getHeapConglomerateId());
                languageConnectionContext.dropDeclaredGlobalTempTable(this.tableName);
                return;
            }
        }
        if (this.conglomerateNumber != 0L) {
            this.lockTableForDDL(transactionController, this.conglomerateNumber, true);
        }
        dataDictionary.startWriting(languageConnectionContext);
        tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        long l = tableDescriptor.getHeapConglomerateId();
        this.lockTableForDDL(transactionController, l, true);
        GenericDescriptorList genericDescriptorList = dataDictionary.getTriggerDescriptors(tableDescriptor);
        Enumeration enumeration = genericDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (TriggerDescriptor)enumeration.nextElement();
            ((TriggerDescriptor)serializable).drop(languageConnectionContext);
        }
        serializable = tableDescriptor.getColumnDescriptorList();
        int n = ((ArrayList)serializable).size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = ((ColumnDescriptorList)serializable).elementAt(i);
            if (columnDescriptor.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
            dependencyManager.clearDependencies(languageConnectionContext, defaultDescriptor);
        }
        dataDictionary.dropAllColumnDescriptors(this.tableId, transactionController);
        dataDictionary.dropAllTableAndColPermDescriptors(this.tableId, transactionController);
        this.dropAllConstraintDescriptors(tableDescriptor, activation);
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            int n3;
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (conglomerateDescriptor.getConglomerateNumber() == l) continue;
            long l2 = conglomerateDescriptor.getConglomerateNumber();
            for (n3 = 0; n3 < n2 && lArray[n3] != l2; ++n3) {
            }
            if (n3 != n2) continue;
            lArray[n2++] = l2;
            transactionController.dropConglomerate(l2);
            dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), conglomerateDescriptor.getUUID(), transactionController);
        }
        dependencyManager.invalidateFor(tableDescriptor, 1, languageConnectionContext);
        dataDictionary.dropTableDescriptor(tableDescriptor, this.sd, transactionController);
        dataDictionary.dropAllConglomerateDescriptors(tableDescriptor, transactionController);
        transactionController.dropConglomerate(l);
    }

    private void dropAllConstraintDescriptors(TableDescriptor tableDescriptor, Activation activation) throws StandardException {
        ConstraintDescriptor constraintDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n = 0;
        while (n < constraintDescriptorList.size()) {
            constraintDescriptor = constraintDescriptorList.elementAt(n);
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                ++n;
                continue;
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            constraintDescriptor.drop(languageConnectionContext, true);
        }
        while (constraintDescriptorList.size() > 0) {
            constraintDescriptor = constraintDescriptorList.elementAt(0);
            constraintDescriptor.drop(languageConnectionContext, false);
            if (this.cascade) {
                ConstraintDescriptorList constraintDescriptorList2 = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
                for (n = 0; n < constraintDescriptorList2.size(); ++n) {
                    ConstraintDescriptor constraintDescriptor2 = constraintDescriptorList2.elementAt(n);
                    dependencyManager.invalidateFor(constraintDescriptor2, 19, languageConnectionContext);
                    constraintDescriptor2.drop(languageConnectionContext, true);
                    activation.addWarning(StandardException.newWarning("01500", constraintDescriptor2.getConstraintName(), constraintDescriptor2.getTableDescriptor().getName()));
                }
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, constraintDescriptor);
        }
    }
}

