/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Node;
import cadyts.utilities.visualization.network.VisLinkData;
import cadyts.utilities.visualization.network.VisNodeData;
import java.util.HashMap;
import java.util.Map;

public class VisNetworkData {
    private double minEasting;
    private double maxEasting;
    private double minNorthing;
    private double maxNorthing;
    private final Map<Node, VisNodeData> nodeData = new HashMap<Node, VisNodeData>();
    private final Map<Link, VisLinkData> linkData = new HashMap<Link, VisLinkData>();

    VisNetworkData() {
    }

    void setMinEasting(double minEasting) {
        this.minEasting = minEasting;
    }

    void setMaxEasting(double maxEasting) {
        this.maxEasting = maxEasting;
    }

    void setMinNorthing(double minNorthing) {
        this.minNorthing = minNorthing;
    }

    void setMaxNorthing(double maxNorthing) {
        this.maxNorthing = maxNorthing;
    }

    double getMinEasting() {
        return this.minEasting;
    }

    double getMaxEasting() {
        return this.maxEasting;
    }

    double getMinNorthing() {
        return this.minNorthing;
    }

    double getMaxNorthing() {
        return this.maxNorthing;
    }

    VisNodeData getVisNodeData(Node node) {
        VisNodeData result = this.nodeData.get(node);
        if (result == null) {
            result = new VisNodeData();
            this.nodeData.put(node, result);
        }
        return result;
    }

    VisLinkData getVisLinkData(Link link) {
        VisLinkData result = this.linkData.get(link);
        if (result == null) {
            result = new VisLinkData();
            this.linkData.put(link, result);
        }
        return result;
    }
}

