/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import cadyts.utilities.math.Vector;
import java.io.Serializable;

public class Matrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Vector[] rows;

    private Matrix(Vector[] rows) {
        this.rows = rows;
    }

    public Matrix(int rowCnt, int colCnt) {
        if (rowCnt < 1) {
            throw new IllegalArgumentException("matrix must have at least one row");
        }
        this.rows = new Vector[rowCnt];
        int i = 0;
        while (i < rowCnt) {
            this.rows[i] = new Vector(colCnt);
            ++i;
        }
    }

    public static Matrix newDiagonal(int dim, double val) {
        Matrix result = new Matrix(dim, dim);
        int i = 0;
        while (i < dim) {
            result.getRow(i).set(i, val);
            ++i;
        }
        return result;
    }

    public static Matrix newDiagonal(Vector diagonal) {
        Matrix result = new Matrix(diagonal.size(), diagonal.size());
        int i = 0;
        while (i < diagonal.size()) {
            result.getRow(i).set(i, diagonal.get(i));
            ++i;
        }
        return result;
    }

    public Matrix copyEnlarged(int rowEnlargement, int columnEnlargement) {
        if (rowEnlargement < 0) {
            throw new IllegalArgumentException("row enlargement must not be negative");
        }
        if (columnEnlargement < 0) {
            throw new IllegalArgumentException("column enlargement must not be negative");
        }
        Vector[] newRows = new Vector[this.rows.length + rowEnlargement];
        int row = 0;
        while (row < this.rows.length) {
            newRows[row] = this.rows[row].copyEnlarged(columnEnlargement);
            ++row;
        }
        row = this.rows.length;
        while (row < newRows.length) {
            newRows[row] = new Vector(newRows[0].size());
            ++row;
        }
        return new Matrix(newRows);
    }

    public Matrix copy() {
        return this.copyEnlarged(0, 0);
    }

    public Matrix newImmutableView() {
        Matrix result = new Matrix(new Vector[this.rowSize()]);
        int i = 0;
        while (i < this.rowSize()) {
            result.rows[i] = this.rows[i].newImmutableView();
            ++i;
        }
        return result;
    }

    public int rowSize() {
        return this.rows.length;
    }

    public int columnSize() {
        return this.rows[0].size();
    }

    public Vector getRow(int i) {
        return this.rows[i];
    }

    public double frobeniusNorm() {
        double result = 0.0;
        Vector[] vectorArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector row = vectorArray[n2];
            result += row.innerProd(row);
            ++n2;
        }
        return Math.sqrt(result);
    }

    public void mult(double value) {
        Vector[] vectorArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector row = vectorArray[n2];
            row.mult(value);
            ++n2;
        }
    }

    public void add(Matrix other, double weight) {
        int i = 0;
        while (i < this.rowSize()) {
            this.rows[i].add(other.rows[i], weight);
            ++i;
        }
    }

    public void clear() {
        Vector[] vectorArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector row = vectorArray[n2];
            row.clear();
            ++n2;
        }
    }

    public void addOuterProduct(Vector other1, Vector other2, double weight) {
        if (other1.size() != this.rowSize()) {
            throw new IllegalArgumentException("size of first vector must equal matrix row dimension");
        }
        if (other2.size() != this.columnSize()) {
            throw new IllegalArgumentException("size of second vector must equal matrix column dimension");
        }
        int i = 0;
        while (i < other1.size()) {
            this.getRow(i).add(other2, other1.get(i) * weight);
            ++i;
        }
    }

    public Vector timesVectorFromLeft(Vector other, Vector result) {
        if (other.size() != this.rowSize()) {
            throw new IllegalArgumentException("other vector must have same size as row dimension of this matrix");
        }
        if (result.size() != this.columnSize()) {
            throw new IllegalArgumentException("result vector must be of same dimension as column dimension of this matrix");
        }
        int l = 0;
        while (l < other.size()) {
            result.add(this.getRow(l), other.get(l));
            ++l;
        }
        return result;
    }

    public Vector timesVectorFromLeft(Vector other) {
        return this.timesVectorFromLeft(other, new Vector(this.columnSize()));
    }

    public void round(int decimals) {
        Vector[] vectorArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector row = vectorArray[n2];
            row.round(decimals);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.rowSize() - 1) {
            result.append(this.rows[i].toString());
            result.append("\n");
            ++i;
        }
        result.append(this.rows[this.rowSize() - 1].toString());
        return result.toString();
    }

    public void symmetrize() {
        int i = 0;
        while (i < this.rowSize()) {
            Vector iRow = this.getRow(i);
            int j = 0;
            while (j < i) {
                Vector jRow = this.getRow(j);
                double cov = 0.5 * (iRow.get(j) + jRow.get(i));
                iRow.set(j, cov);
                jRow.set(i, cov);
                ++j;
            }
            ++i;
        }
    }

    public void setColumn(int j, Vector column) {
        int i = 0;
        while (i < this.rowSize()) {
            this.getRow(i).set(j, column.get(i));
            ++i;
        }
    }

    public boolean isAllZeros() {
        Vector[] vectorArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector row = vectorArray[n2];
            if (!row.isAllZeros()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toSingleLineString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        while (i < this.rowSize()) {
            result.append(this.rows[i].toString());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public Vector timesVectorFromRight(Vector other, Vector result) {
        int i = 0;
        while (i < this.rowSize()) {
            result.set(i, this.getRow(i).innerProd(other));
            ++i;
        }
        return result;
    }

    public Vector timesVectorFromRight(Vector other) {
        return this.timesVectorFromRight(other, new Vector(this.rowSize()));
    }

    public Matrix newTransposed() {
        Matrix result = new Matrix(this.columnSize(), this.rowSize());
        int i = 0;
        while (i < this.rowSize()) {
            Vector fromRow_i = this.getRow(i);
            int j = 0;
            while (j < this.columnSize()) {
                result.getRow(j).set(i, fromRow_i.get(j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Matrix product(Matrix _A, Matrix _B) {
        if (_A.columnSize() != _B.rowSize()) {
            throw new IllegalArgumentException("column size of first argument does not equal row size of second argument");
        }
        Matrix _C = new Matrix(_A.rowSize(), _B.columnSize());
        int i = 0;
        while (i < _C.rowSize()) {
            Vector _A_row_i = _A.getRow(i);
            Vector _C_row_i = _C.getRow(i);
            int k = 0;
            while (k < _A.columnSize()) {
                _C_row_i.add(_B.getRow(k), _A_row_i.get(k));
                ++k;
            }
            ++i;
        }
        return _C;
    }
}

