/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.matsim;

import cadyts.utilities.math.MathHelpers;
import cadyts.utilities.math.Matrix;
import cadyts.utilities.math.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ExpBetaPlanChanger {
    private double utilityScale = 1.0;
    private final Vector coeff;
    private final Vector asc;
    private final Matrix attr;
    private int currentChoice;
    private final Vector utilities;
    private final Vector choiceProbs;
    private final Matrix dProbs_dCoeffs;
    private final Matrix dProbs_dASCs;
    private boolean consistent;
    private boolean inSmoothConditions;

    public ExpBetaPlanChanger(int choiceSetSize, int attributeCount) {
        this.coeff = new Vector(attributeCount);
        this.asc = new Vector(choiceSetSize);
        this.attr = new Matrix(choiceSetSize, attributeCount);
        this.utilities = new Vector(choiceSetSize);
        this.choiceProbs = new Vector(choiceSetSize);
        this.dProbs_dCoeffs = new Matrix(choiceSetSize, attributeCount);
        this.dProbs_dASCs = new Matrix(choiceSetSize, choiceSetSize);
        this.consistent = false;
    }

    public void setUtilityScale(double value) {
        this.consistent = false;
        this.utilityScale = value;
    }

    public void setCoefficient(int attrIndex, double value) {
        this.consistent = false;
        this.coeff.set(attrIndex, value);
    }

    public void setASC(int choiceIndex, double value) {
        this.consistent = false;
        this.asc.set(choiceIndex, value);
    }

    public void setAttribute(int choiceIndex, int attrIndex, double value) {
        this.consistent = false;
        this.attr.getRow(choiceIndex).set(attrIndex, value);
    }

    public void setCurrentChoice(int currentChoice) {
        this.consistent = false;
        this.currentChoice = currentChoice;
    }

    public void enforcedUpdate() {
        int i = 0;
        while (i < this.getChoiceSetSize()) {
            double v = this.coeff.innerProd(this.attr.getRow(i)) + this.asc.get(i);
            this.utilities.set(i, v);
            ++i;
        }
        boolean[] inSmoothConditions = new boolean[this.getChoiceSetSize()];
        this.inSmoothConditions = true;
        double pSum = 0.0;
        double currentUtility = this.utilities.get(this.currentChoice);
        int i2 = 0;
        while (i2 < this.getChoiceSetSize()) {
            if (i2 != this.currentChoice) {
                double p = Math.min(1.0, 0.01 * Math.exp(0.5 * this.utilityScale * (this.utilities.get(i2) - currentUtility)));
                this.inSmoothConditions &= p < 1.0;
                inSmoothConditions[i2] = p < 1.0;
                this.choiceProbs.set(i2, p /= (double)this.getChoiceSetSize());
                pSum += p;
            }
            ++i2;
        }
        this.choiceProbs.set(this.currentChoice, 1.0 - pSum);
        this.dProbs_dCoeffs.clear();
        Vector attrCurrent = this.attr.getRow(this.currentChoice);
        Vector dProbsCurrent_dCoeffs = this.dProbs_dCoeffs.getRow(this.currentChoice);
        int i3 = 0;
        while (i3 < this.getChoiceSetSize()) {
            if (i3 != this.currentChoice && inSmoothConditions[i3]) {
                Vector dProbi_dCoeff = this.dProbs_dCoeffs.getRow(i3);
                double probi = this.choiceProbs.get(i3);
                Vector attri = this.attr.getRow(i3);
                int j = 0;
                while (j < this.getAttrCount()) {
                    double dProbi_dCoeffj = probi * 0.5 * this.utilityScale * (attri.get(j) - attrCurrent.get(j));
                    dProbi_dCoeff.set(j, dProbi_dCoeffj);
                    dProbsCurrent_dCoeffs.add(j, -dProbi_dCoeffj);
                    ++j;
                }
            }
            ++i3;
        }
        this.dProbs_dASCs.clear();
        this.consistent = true;
    }

    public void conditionalUpdate() {
        if (!this.consistent) {
            this.enforcedUpdate();
        }
    }

    public int getChoiceSetSize() {
        return this.choiceProbs.size();
    }

    public int getAttrCount() {
        return this.coeff.size();
    }

    public Vector getCoeff() {
        return this.coeff.newImmutableView();
    }

    public Vector getASC() {
        return this.asc.newImmutableView();
    }

    public Vector getProbs() {
        this.conditionalUpdate();
        return this.choiceProbs.newImmutableView();
    }

    public Vector getUtils() {
        this.conditionalUpdate();
        return this.utilities.newImmutableView();
    }

    public Matrix get_dProbs_dCoeffs() {
        this.conditionalUpdate();
        return this.dProbs_dCoeffs.newImmutableView();
    }

    public Matrix get_dProbs_dASCs() {
        this.conditionalUpdate();
        return this.dProbs_dASCs.newImmutableView();
    }

    public boolean getInSmoothConditions() {
        this.conditionalUpdate();
        return this.inSmoothConditions;
    }

    public int draw(Random rnd) {
        return MathHelpers.draw(this.getProbs(), rnd);
    }

    public int getParameterSize(boolean withASC) {
        return this.getAttrCount() + (withASC ? this.getChoiceSetSize() : 0);
    }

    public int getParameterSize(List<Integer> attributeIndices, boolean withASC) {
        return attributeIndices.size() + (withASC ? this.getChoiceSetSize() : 0);
    }

    public double getParameter(int j) {
        if (j < this.getAttrCount()) {
            return this.getCoeff().get(j);
        }
        return this.getASC().get(j - this.getAttrCount());
    }

    public Vector getParameters(boolean withASC) {
        Vector result = new Vector(this.getParameterSize(withASC));
        int j = 0;
        while (j < result.size()) {
            result.set(j, this.getParameter(j));
            ++j;
        }
        return result;
    }

    public void setParameter(int j, double value) {
        this.consistent = false;
        if (j < this.getAttrCount()) {
            this.setCoefficient(j, value);
        } else {
            this.setASC(j - this.getAttrCount(), value);
        }
    }

    public void setParameters(Vector parameters, List<Integer> attributeIndices) {
        if (parameters.size() != attributeIndices.size()) {
            throw new IllegalArgumentException("arguments must have the same dimension");
        }
        this.consistent = false;
        int j = 0;
        while (j < parameters.size()) {
            this.setParameter(attributeIndices.get(j), parameters.get(j));
            ++j;
        }
    }

    public Matrix get_dProb_dParameters(List<Integer> attributeIndices, boolean withASC) {
        this.conditionalUpdate();
        Matrix result = new Matrix(this.getChoiceSetSize(), this.getParameterSize(attributeIndices, withASC));
        int i = 0;
        while (i < this.getChoiceSetSize()) {
            Vector resulti = result.getRow(i);
            Vector dProbi_dCoeff = this.get_dProbs_dCoeffs().getRow(i);
            Vector dProbi_dASC = this.get_dProbs_dASCs().getRow(i);
            int l = 0;
            for (int j : attributeIndices) {
                resulti.set(l++, dProbi_dCoeff.get(j));
            }
            if (withASC) {
                int i2 = 0;
                while (i2 < this.getChoiceSetSize()) {
                    resulti.set(l++, dProbi_dASC.get(i2));
                    ++i2;
                }
            }
            ++i;
        }
        return result;
    }

    public List<Matrix> get_d2P_dbdb(double delta, List<Integer> attributeIndices, boolean withASC) {
        ArrayList<Matrix> result = new ArrayList<Matrix>(this.getChoiceSetSize());
        int paramSize = this.getParameterSize(attributeIndices, withASC);
        int i = 0;
        while (i < this.getChoiceSetSize()) {
            result.add(new Matrix(paramSize, paramSize));
            ++i;
        }
        Matrix dP_db0 = this.get_dProb_dParameters(attributeIndices, withASC).copy();
        int resultIndex = 0;
        for (int r : attributeIndices) {
            double br0 = this.getParameter(r);
            this.setParameter(r, br0 + delta);
            int i2 = 0;
            while (i2 < this.getChoiceSetSize()) {
                Vector d2Pi_dbrdb = ((Matrix)result.get(i2)).getRow(resultIndex);
                d2Pi_dbrdb.add(this.get_dProb_dParameters(attributeIndices, withASC).getRow(i2), 1.0);
                d2Pi_dbrdb.add(dP_db0.getRow(i2), -1.0);
                d2Pi_dbrdb.mult(1.0 / delta);
                ++i2;
            }
            this.setParameter(r, br0);
            ++resultIndex;
        }
        return result;
    }
}

