/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import trafficdefinition.Accident;
import ui.AffectedLanesTableModel;
import ui.controls.SimTimeEdit;

public class PnlAccidentProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Accident currentAccident = null;
    private JLabel lblEndingTime = null;
    private JLabel lblNameTitle = null;
    private JLabel lblStartingTime = null;
    private SimTimeEdit steTimeEnding = null;
    private SimTimeEdit steTimeStarting = null;
    private JTextField txtName = null;
    private JLabel lblEdge = null;
    private JLabel lblEdgeValue = null;
    private JCheckBox chkEnabled = null;
    private JLabel lblAffectedLanes = null;
    private JScrollPane scrlLanes = null;
    private JTable tblAffectedLanes = null;

    public PnlAccidentProperties() {
        this.initialize();
    }

    public void setAccident(Accident accident) {
        this.currentAccident = accident;
        this.txtName.setText(this.currentAccident.getName());
        this.lblEdgeValue.setText(this.currentAccident.getEdge().getId());
        this.steTimeStarting.setValue(this.currentAccident.getStartingTime());
        this.steTimeEnding.setValue(this.currentAccident.getEndingTime());
        this.chkEnabled.setSelected(this.currentAccident.isEnabled());
        this.tblAffectedLanes.setModel(new AffectedLanesTableModel(this.currentAccident.getAffectedLanes()));
    }

    private SimTimeEdit getSteTimeEnding() {
        if (this.steTimeEnding == null) {
            this.steTimeEnding = new SimTimeEdit();
            this.steTimeEnding.setPreferredSize(new Dimension(166, 45));
            this.steTimeEnding.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlAccidentProperties.this.currentAccident.setEndingTime(PnlAccidentProperties.this.steTimeEnding.getValue());
                }
            });
        }
        return this.steTimeEnding;
    }

    private SimTimeEdit getSteTimeStarting() {
        if (this.steTimeStarting == null) {
            this.steTimeStarting = new SimTimeEdit();
            this.steTimeStarting.setPreferredSize(new Dimension(166, 45));
            this.steTimeStarting.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlAccidentProperties.this.currentAccident.setStartingTime(PnlAccidentProperties.this.steTimeStarting.getValue());
                }
            });
        }
        return this.steTimeStarting;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlAccidentProperties.this.currentAccident.setName(PnlAccidentProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
        gridBagConstraints111.fill = 1;
        gridBagConstraints111.gridy = 6;
        gridBagConstraints111.weightx = 1.0;
        gridBagConstraints111.weighty = 1.0;
        gridBagConstraints111.gridwidth = 2;
        gridBagConstraints111.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints111.gridx = 0;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints9.gridwidth = 2;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridy = 5;
        this.lblAffectedLanes = new JLabel();
        this.lblAffectedLanes.setText("Affected lanes:");
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.anchor = 18;
        gridBagConstraints31.gridy = 4;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridy = 1;
        this.lblEdgeValue = new JLabel();
        this.lblEdgeValue.setText("Edge");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.insets = new Insets(3, 10, 0, 5);
        gridBagConstraints13.anchor = 18;
        gridBagConstraints13.gridy = 1;
        this.lblEdge = new JLabel();
        this.lblEdge.setText("Edge:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridy = 3;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints12.gridy = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 3;
        this.lblEndingTime = new JLabel();
        this.lblEndingTime.setText("Ending time:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(3, 10, 0, 5);
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 2;
        this.lblStartingTime = new JLabel();
        this.lblStartingTime.setText("Starting time:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(272, 277);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblStartingTime, gridBagConstraints11);
        this.add((Component)this.lblEndingTime, gridBagConstraints3);
        this.add((Component)this.getSteTimeStarting(), gridBagConstraints12);
        this.add((Component)this.getSteTimeEnding(), gridBagConstraints2);
        this.add((Component)this.lblEdge, gridBagConstraints13);
        this.add((Component)this.lblEdgeValue, gridBagConstraints21);
        this.add((Component)this.getChkEnabled(), gridBagConstraints31);
        this.add((Component)this.lblAffectedLanes, gridBagConstraints9);
        this.add((Component)this.getScrlLanes(), gridBagConstraints111);
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlAccidentProperties.this.currentAccident.setEnabled(PnlAccidentProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }

    private JScrollPane getScrlLanes() {
        if (this.scrlLanes == null) {
            this.scrlLanes = new JScrollPane();
            this.scrlLanes.setPreferredSize(new Dimension(40, 40));
            this.scrlLanes.setViewportView(this.getTblAffectedLanes());
        }
        return this.scrlLanes;
    }

    private JTable getTblAffectedLanes() {
        if (this.tblAffectedLanes == null) {
            this.tblAffectedLanes = new JTable();
            this.tblAffectedLanes.setBounds(new Rectangle(0, 0, 28, 40));
        }
        return this.tblAffectedLanes;
    }
}

