/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import roadnetwork.Lane;
import roadnetwork.RoadNetworkElement;
import shapes.Line2DExt;
import shapes.Polygon2D;
import trafficdefinition.TrafficDefinitionElement;

public class Edge
extends RoadNetworkElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<TrafficDefinitionElement> dependentTrafficElements = null;
    private List<Line2DExt> dividers = new ArrayList<Line2DExt>();
    private String from = "";
    private List<Lane> lanes = new ArrayList<Lane>();
    private float length = 0.0f;
    private int priority = 0;
    private float speedLimit = 0.0f;
    private String to = "";

    public void AddDependentTrafficElement(TrafficDefinitionElement t) {
        if (this.dependentTrafficElements == null) {
            this.dependentTrafficElements = new ArrayList<TrafficDefinitionElement>();
        }
        if (!this.dependentTrafficElements.contains(t)) {
            this.dependentTrafficElements.add(t);
        }
    }

    public void AddLane(Lane l) {
        this.lanes.add(l);
    }

    public void CalculateShape() {
        double halfwidth = 1.6 * (double)this.lanes.size();
        int parts = Integer.MAX_VALUE;
        for (Lane l : this.lanes) {
            parts = Math.min(parts, l.GetTotalPoints());
        }
        ArrayList<Point2D.Double> leftPoints = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> rightPoints = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> previousLanePoints = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> nextLanePoints = new ArrayList<Point2D.Double>();
        int i = 0;
        while (i < parts) {
            Point2D.Double newRightPoint;
            Point2D.Double newLeftPoint;
            previousLanePoints.clear();
            nextLanePoints.clear();
            if (i == parts - 1) {
                for (Lane l : this.lanes) {
                    previousLanePoints.add(l.GetPoint(i));
                    nextLanePoints.add(l.GetPoint(i - 1));
                }
            } else {
                for (Lane l : this.lanes) {
                    previousLanePoints.add(l.GetPoint(i));
                    nextLanePoints.add(l.GetPoint(i + 1));
                }
            }
            Point2D.Double lineStart = new Point2D.Double();
            Point2D.Double lineEnd = new Point2D.Double();
            int dp = 0;
            while (dp < this.lanes.size() - 1) {
                lineStart.x = (((Point2D.Double)previousLanePoints.get((int)dp)).x + ((Point2D.Double)previousLanePoints.get((int)(dp + 1))).x) / 2.0;
                lineStart.y = (((Point2D.Double)previousLanePoints.get((int)dp)).y + ((Point2D.Double)previousLanePoints.get((int)(dp + 1))).y) / 2.0;
                lineEnd.x = (((Point2D.Double)nextLanePoints.get((int)dp)).x + ((Point2D.Double)nextLanePoints.get((int)(dp + 1))).x) / 2.0;
                lineEnd.y = (((Point2D.Double)nextLanePoints.get((int)dp)).y + ((Point2D.Double)nextLanePoints.get((int)(dp + 1))).y) / 2.0;
                this.dividers.add(new Line2DExt(lineStart, lineEnd));
                ++dp;
            }
            Point2D.Double previousCenter = this.PointsCenter(previousLanePoints);
            Point2D.Double nextCenter = this.PointsCenter(nextLanePoints);
            if (previousCenter.y == nextCenter.y) {
                newLeftPoint = new Point2D.Double(previousCenter.x, previousCenter.y - halfwidth);
                newRightPoint = new Point2D.Double(previousCenter.x, previousCenter.y + halfwidth);
            } else if (previousCenter.x == nextCenter.x) {
                newLeftPoint = new Point2D.Double(previousCenter.x - halfwidth, previousCenter.y);
                newRightPoint = new Point2D.Double(previousCenter.x + halfwidth, previousCenter.y);
            } else {
                double m = -(nextCenter.x - previousCenter.x) / (nextCenter.y - previousCenter.y);
                newLeftPoint = new Point2D.Double(halfwidth / Math.sqrt(m * m + 1.0) + previousCenter.x, previousCenter.y + m * halfwidth / Math.sqrt(m * m + 1.0));
                newRightPoint = new Point2D.Double(-halfwidth / Math.sqrt(m * m + 1.0) + previousCenter.x, previousCenter.y - m * halfwidth / Math.sqrt(m * m + 1.0));
            }
            leftPoints.add(newLeftPoint);
            rightPoints.add(newRightPoint);
            ++i;
        }
        double[] f = new double[parts * 2 * 2];
        int v = 0;
        for (Point2D.Double k : rightPoints) {
            f[v++] = k.x;
            f[v++] = k.y;
        }
        int k = leftPoints.size() - 1;
        while (k >= 0) {
            f[v++] = ((Point2D.Double)leftPoints.get((int)k)).x;
            f[v++] = ((Point2D.Double)leftPoints.get((int)k)).y;
            --k;
        }
        this.shape = new Polygon2D.Double(f);
    }

    public int DistanceFrom(Edge e) {
        return (int)Math.round(this.lanes.get(0).GetPoint(0).distance(e.lanes.get(0).GetPoint(0)));
    }

    public double DistanceFrom(Point2D.Double point) {
        return this.lanes.get(0).GetPoint(0).distance(point);
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        super.Draw(g, zoomFactor, isDeleted, isSelected);
        Color prev = g.getColor();
        g.setColor(Color.YELLOW);
        if (zoomFactor > 2.0) {
            Stroke previous = g.getStroke();
            float[] dashes = new float[]{1.0f, 2.0f};
            g.setStroke(new BasicStroke(0.1f, 0, 0, 10.0f, dashes, 0.0f));
            for (Line2D.Double double_ : this.dividers) {
                g.draw(double_);
            }
            g.setStroke(previous);
        }
        g.setColor(prev);
    }

    public String getFrom() {
        return this.from;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public float getLength() {
        return this.length;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public String getTo() {
        return this.to;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Edge</b> " + this.id + "<br>" + "<b>Priority:</b> " + this.priority + "<br>" + "<b>Speed limit:</b> " + this.speedLimit + "<br>" + "</html>";
    }

    public boolean HasDependentTrafficElements() {
        return this.dependentTrafficElements != null;
    }

    public List<TrafficDefinitionElement> getDependentTrafficElements() {
        return this.dependentTrafficElements;
    }

    public void RemoveDependentTrafficElement(TrafficDefinitionElement t) {
        if (this.dependentTrafficElements != null && this.dependentTrafficElements.contains(t)) {
            this.dependentTrafficElements.remove(t);
            if (this.dependentTrafficElements.isEmpty()) {
                this.dependentTrafficElements = null;
            }
        }
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setSpeedLimit(float speed) {
        this.speedLimit = speed;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String toString() {
        return "Edge " + this.id;
    }

    private Point2D.Double PointsCenter(List<Point2D.Double> points) {
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        for (Point2D.Double p : points) {
            center.x += p.x;
            center.y += p.y;
        }
        center.x /= (double)points.size();
        center.y /= (double)points.size();
        return center;
    }
}

