/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import classes.Project;
import helpers.ApplicationSettings;
import helpers.StreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import roadnetwork.Edge;
import simulation.Simulation;

public class MultipleTripExpander {
    public static String ExpandTrips(List<Edge> tripEdges) throws Exception {
        Simulation sim = Project.getCurrentlyLoadedProject().getSimulation();
        String simulationPath = sim.getExportPath();
        String roadNetworkFile = String.valueOf(sim.getName()) + ".net.xml";
        File tripsToExpand = new File(String.valueOf(simulationPath) + File.separator + "tripstoexpand.tmp");
        File expandedTrips = new File(String.valueOf(simulationPath) + File.separator + "expandedtrips.tmp");
        File expandedTripsAlt = new File(String.valueOf(simulationPath) + File.separator + "expandedtrips.tmp.alt");
        BufferedWriter tripout = new BufferedWriter(new FileWriter(tripsToExpand));
        tripout.write("<tripdefs>\n");
        int i = 1;
        while (i < tripEdges.size()) {
            tripout.write("<tripdef id=\"" + String.valueOf(i) + "\" " + "depart=\"" + String.valueOf(i) + "\" " + "from=\"" + tripEdges.get(i - 1).getId() + "\" " + "to=\"" + tripEdges.get(i).getId() + "\" />\n");
            ++i;
        }
        tripout.write("</tripdefs>");
        tripout.close();
        ArrayList<String> args = new ArrayList<String>();
        args.add("\"" + ApplicationSettings.getDUARouterPath() + "\"");
        args.add("-t=\"tripstoexpand.tmp\"");
        args.add("-n=\"" + roadNetworkFile + "\"");
        args.add("-o=\"expandedtrips.tmp\"");
        args.add("--continue-on-unbuild");
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(new File(simulationPath));
        Process dua = pb.start();
        StreamGobbler gi = new StreamGobbler(dua.getInputStream());
        StreamGobbler ge = new StreamGobbler(dua.getErrorStream());
        gi.start();
        ge.start();
        int exitvalue = dua.waitFor();
        gi.stop();
        ge.stop();
        List<String> gir = gi.getReadLines();
        List<String> ger = ge.getReadLines();
        for (String s : ger) {
            System.out.println(s);
        }
        ArrayList<String> allEdges = new ArrayList<String>();
        BufferedReader generatedRoutes = new BufferedReader(new FileReader(expandedTrips));
        String line = null;
        int routesFound = 0;
        while ((line = generatedRoutes.readLine()) != null) {
            int i2;
            if (!line.contains("<route>")) continue;
            String[] routeEdges = line.substring(line.indexOf("<route>") + 7, line.indexOf("</route>")).split(" ");
            if (++routesFound == 1) {
                i2 = 0;
                while (i2 < routeEdges.length) {
                    allEdges.add(routeEdges[i2]);
                    ++i2;
                }
                continue;
            }
            i2 = 1;
            while (i2 < routeEdges.length) {
                allEdges.add(routeEdges[i2]);
                ++i2;
            }
        }
        if (expandedTrips.exists()) {
            expandedTrips.delete();
        }
        if (expandedTripsAlt.exists()) {
            expandedTripsAlt.delete();
        }
        if (tripsToExpand.exists()) {
            tripsToExpand.delete();
        }
        StringBuilder resultBuilder = new StringBuilder();
        for (String s : allEdges) {
            resultBuilder.append(String.valueOf(s) + " ");
        }
        return resultBuilder.toString();
    }
}

