/* ====================================================================
 * Copyright (c) 2003-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "stdafx.h"

// cppunit
#include <cppunit/TextTestRunner.h>
#include <cppunit/TestResult.h>
#include <cppunit/CompilerOutputter.h>
#ifdef _WIN32
#include "debugstream.h"
#endif // _WIN32

// sc
#include "util/apr.h"

///////////////////////////////////////////////////////////////////////////////
// tests..

#include "merge/LineTokenizerTest.h"
#include "lib/TextModelTest.h"
#include "lib/TextModelTestRemove.h"
#include "lib/TabTest.h"
#include "lib/StringUtilTest.h"
#include "svn/DiffTest.h"
#include "svn/ClientStaticTest.h"
#include "util/FileTest.h"
#include "util/CommandArgsTest.h"
#include "util/UtfTest.h"
#include "util/CompareTest.h"

///////////////////////////////////////////////////////////////////////////////
// entry point

int main(int argc, char* argv[])
{
  apr::initialize( argc, argv );
  //apr_pool_t *pool = apr::createPool();

  CppUnit::TextTestRunner runner;
#ifdef _WIN32  
  dostream ostream;
  runner.setOutputter( new CppUnit::CompilerOutputter(&runner.result(),ostream) ); 
#endif // _WIN32


  // build test suite tree
  CppUnit::TestSuite *all = new CppUnit::TestSuite( "all" );
  {
    CppUnit::TestSuite *merge = new CppUnit::TestSuite( "merge" );
    all->addTest(merge);
    {
      merge->addTest( LineTokenizerTest::suite() );
    }

    CppUnit::TestSuite *lib = new CppUnit::TestSuite( "lib" );
    all->addTest(lib);
    {
      lib->addTest( TextModelTest::suite() );
      lib->addTest( TextModelTestRemove::suite() );
      lib->addTest( TabTest::suite() );
      lib->addTest( StringUtilTest::suite() );
    }

    CppUnit::TestSuite *svn = new CppUnit::TestSuite( "svn" );
    all->addTest(svn);
    {
      svn->addTest( DiffTest::suite() );
      svn->addTest( ClientStaticTest::suite() );
    }

    CppUnit::TestSuite *util = new CppUnit::TestSuite( "util" );
    all->addTest(util);
    {
      util->addTest( CompareTest::suite() );
      util->addTest( FileTest::suite() );
      util->addTest( CommandArgsTest::suite() );
      util->addTest( UtfTest::suite() );
    }
  }

  // all->findTest( "sc" )
  runner.addTest( all/*->findTest( "ProjectSorterTest" )*/ );

  // run test...
  bool success = runner.run();

  return success ? EXIT_SUCCESS :  EXIT_FAILURE;
}
