/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTMODEL_H
#define _TEXTMODEL_H

// sc
#include "BlockInfo.h"
#include "LineEnd.h"
#include "util/types.h"
class Line;
class Cursor;

namespace sc
{
class String;
}


class TextModel
{
public:
  virtual ~TextModel() {}

  virtual const sc::String& getSourceName() = 0;

  virtual const Line& getLine( sc::Size lineNr ) = 0;
  virtual BlockInfo getBlockInfo( int block ) = 0;
  virtual sc::Size getLineCnt() = 0;
  virtual sc::Size getColumnCnt() = 0;
  virtual LineEnd getLineEnd() = 0;
  virtual unsigned int getTabWidth() = 0;

  /** @name block manipulation.*/
  //@{
  virtual int replaceBlock( int block, TextModel* src ) = 0;
  //@}

  /** @name cursor related methods. */
  //@{
  virtual const Cursor& getCursor() = 0;
  virtual const Cursor& getCursor2() = 0;
  virtual void setCursor( const Cursor& c ) = 0;
  virtual void setCursor2( const Cursor& c ) = 0;
  virtual Cursor moveCursorRight( bool moveC2 ) = 0;
  virtual Cursor moveCursorLeft( bool moveC2 ) = 0;
  virtual Cursor moveCursorDown( bool moveC2 ) = 0;
  virtual Cursor moveCursorUp( bool moveC2 ) = 0;
  virtual int getLastColumn() = 0;
  virtual void setLastColumn( int col ) = 0;
  virtual Cursor calcNearestCursorPos( const Cursor& c ) = 0;
  //@}

  /** @name text manipulation. */
  //@{
  /** Add text at the current cursor position. If some text is highlighted
   *  it is replaced by the new text.
   */
  virtual void addText( const sc::String& s ) = 0;

  /** Remove a character left from the current cursor position (ie. backspace).
    * If some text is highlighted it will be removed instead of the character.
    */
  virtual void removeTextLeft() = 0;

  /** Remove a character right from the current cursor position (ie. del).
    * If some text is highlighted it will be removed instead of the character.
    */
  virtual void removeTextRight() = 0;

  /** Get the highlighted text. If there is no highlighted text the result
    * string is empty.
    */
  virtual sc::String getHighlightedText() = 0;
  //@}

  /** @name undo related methods. */
  //@{
  /** undo the last text manipulation. */
  virtual void undo() = 0;

  /** redo the last text manipulation. */
  virtual void redo() = 0;

  /** undo buffer is not empty. */
  virtual bool hasUndo() = 0;

  /** clear undo buffer. */
  virtual void clearUndo() = 0;
  //@}
};

#endif // _TEXTMODEL_H
