/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "WcStatusInfo.h"


WcStatusInfo::WcStatusInfo( const sc::String& path, const svn::Date& date, const svn::WcStatuss& statuss )
: _path(path), _date(date), _statuss(statuss)
{
}

const sc::String& WcStatusInfo::getPath() const
{
  return _path;
}

const svn::Date& WcStatusInfo::getDate() const
{
  return _date;
}

const svn::WcStatuss& WcStatusInfo::getWcStatuss() const
{
  return _statuss;
}

unsigned long WcStatusInfo::getAge() const
{
  // in millisenconds..
  return (unsigned long)((apr_time_now() - _date) / 1000);
}

bool WcStatusInfo::isEmpty() const
{
  return _path.isEmpty();
}

void WcStatusInfo::operator=( const WcStatusInfo& src )
{
  _path = src._path;
  _date = src._date;
  _statuss = src._statuss;
}

bool WcStatusInfo::operator==( const WcStatusInfo& info )
{
  return _path == info._path
    &&   _date == info._date;
}
