/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _CONFLICTMARKERWIDGET_H
#define _CONFLICTMARKERWIDGET_H

#include <qwidget.h>

class QPopupMenu;

class ConflictMarkerWidget : public QWidget
{
  typedef QWidget super;

public:
  enum State
  {
    None          = 0x00,
    Left          = 0x01,
    LeftTop       = 0x02,
    LeftLeftTop   = 0x03,
    Right         = 0x04,
    RightTop      = 0x08,
    RightRightTop = 0x0c
  };

  ConflictMarkerWidget( QWidget * parent, const char * name = 0 );
  virtual ~ConflictMarkerWidget();

  QSize sizeHint() const;

  void setState( int );
  int getState() const;

  int getConflict() const;
  void setConflict( int );

protected:
  void mousePressEvent( QMouseEvent* e );
  void focusInEvent( QFocusEvent* e );
  void resizeEvent( QResizeEvent* e );
  void paintEvent( QPaintEvent* e );

private:
  QPopupMenu* _popup;

  int _columns;
  int _conflict;
  int _state;

  static QColor _bgConflict;
  static QColor _bgSolved;
  static QColor _fg;
};

#endif //_CONFLICTMARKERWIDGET_H

