/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
 
// sc
#include "Utility.h"
#include "config.h"
#ifdef _WIN32
#include "win32st/Stacktrace.h"
#endif // _WIN32
 
// qt
#include <qapplication.h>
#include <qregexp.h>
#include <qtextcodec.h>

// gettext
#ifdef _WIN32
#include <libintl.h>
#endif // _WIN32

// sys
#include <locale.h>


static QString _appName;

void setAppName( const QString& name )
{
  _appName = name;
}

QString getDataDir()
{
#ifdef _MACOSX
  return qApp->applicationDirPath() + "/../Resources";
#elif defined(_WIN32)
  return qApp->applicationDirPath();
#else
  return qApp->applicationDirPath() + "/../share/subcommander";
#endif
}

QString getMergePath()
{
  QString path = qApp->applicationDirPath();

#if defined(_MACOSX)
  path += "/../../../submerge.app/Contents/MacOS/submerge";

#elif defined(_WIN32)

# if defined(_DEBUG)
  path += "/submergeD";
# else
  path += "/submerge";
# endif // _DEBUG

#else // ! _WIN32
  path += "/submerge";

#endif // _WIN32

  return path;
}


QString getAppName()
{
  return _appName;
}

QString getLongAppName()
{
  if( _appName == "subcommander" )
  {
    return "subcommander";
  }
  else if( _appName == "submerge" )
  {
    return "submerge";
  }
  else
  {
    return "unknown";
  }
}

QString getIconDir()
{
  return getDataDir() + "/icons/default/";
}

void initStackProcess()
{
#ifdef _WIN32
  Stacktrace::setupProcess();
#endif // _WIN32
}

void stopStackProcess()
{
#ifdef _WIN32
  Stacktrace::shutdownProcess();
#endif // _WIN32
}

void initStackThread()
{
#ifdef _WIN32
  Stacktrace::setupThread();
#endif // _WIN32
}

void stopStackThread()
{
#ifdef _WIN32
  Stacktrace::shutdownThread();
#endif // _WIN32
}

void setDumpOnException( bool b )
{
#ifdef _WIN32
  Stacktrace::setDump(b);
#endif // _WIN32
}

bool getDumpOnException()
{
#ifdef _WIN32
  return Stacktrace::getDump();
#else
  return false;
#endif // _WIN32
}


// some magic to make sc/svn i18n aware  

void setLocale()
{
#ifndef _WIN32
  QString loc = QTextCodec::locale();
  loc += ".UTF-8";

  // set LANG if not set (on MacOSX the setlocale below doesn't work if LANG
  // is not set).
  setenv( "LANG", loc, 0 );
#endif // _WIN32

  // C programs default to the "C" locale. We are supposed to be i18n-aware,
  // so it should inherit the default locale of our environment.
  /*const char* l =*/ setlocale(LC_ALL, "");
}

// overwrite the subversion locale directory to our installation directory
// for Windows and MacOSX

void setLocalePath( const QString& appPath )
{
#ifdef ENABLE_NLS

  QString localePath = appPath;
  
#if defined(_MACOSX)

  localePath += "/../Resources/locale";

#elif defined(_WIN32)

  localePath += "/share/locale";

#else

  localePath += "/../share/locale";

#endif

#if defined(_WIN32) || (defined(_MACOSX) && defined(MACOSX_BUNDLED_SVN_NLS)) 

  #define SVN_PACKAGE_NAME "subversion"
  /*const char* svn_btd  =*/ bindtextdomain( SVN_PACKAGE_NAME, (const char*)localePath.local8Bit() );    
  /*const char* svn_btdc =*/ bind_textdomain_codeset( SVN_PACKAGE_NAME, "UTF-8" );
#endif

  #define SC_PACKAGE_NAME "Subcommander"
  /*const char* sc_btd  =*/ bindtextdomain( SC_PACKAGE_NAME, (const char*)localePath.local8Bit() );    
  /*const char* sc_btdc =*/ bind_textdomain_codeset( SC_PACKAGE_NAME, "UTF-8" );
  
#endif // ENABLE_NLS
}

QString getDateFormat()
{
  // Sun Aug 27 16:32:54 2006
  return _q("ddd MMM dd hh:mm:ss yyyy");
}

static const char* neon_version = "";

void setNeonVersion( const char* v )
{
  neon_version = v;
}

QString getNeonVersion()
{
  return QString(neon_version).left(12);
}
