/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "MainWindow.h"
#include "ScModel.h"
#include "Repository.h"
#include "ConfigManager.h"
#include "sublib/Utility.h"
#include "sublib/ErrorDialog.h"
#include "sublib/MacStyle.h"
#include "sublib/TargetRepository.h"
#include "sublib/MsgHandler.h"
#include "svn/svn.h"
#include "util/apr.h"
#include "util/Exception.h"

// qt
#include <qapplication.h>
#include <qstylefactory.h>

// neon
#include <neon/ne_socket.h>
#include <neon/ne_utils.h>

// openssl
#include <openssl/evp.h>
#include <openssl/err.h>

// cleanup neon/ssl stuff to avoid a lot of noise when running with
// memory leak detection.

void exit_ssl()
{
  /* clean up (memory) allocations by SSL_library_init(),
  an SSL_library_exit() wouldn't be bad... */
  EVP_cleanup(); 

  /* clean up (memory) allocations by SSL_load_error_strings */
  ERR_free_strings();
}

void exit_neon()
{
  ne_sock_exit();
}



int main( int argc, char* argv[] )
{
#if 0
  QStringList styles = QStyleFactory::keys();
  printf( "%s\n", (const char*)styles.join("/") );

  QStyle* windows   = QStyleFactory::create("Windows");
  QStyle* motif     = QStyleFactory::create("Motif");
  QStyle* motifplus = QStyleFactory::create("MotifPlus");
  QStyle* cde       = QStyleFactory::create("CDE");
  QStyle* sgi       = QStyleFactory::create("SGI");
  QStyle* platinum  = QStyleFactory::create("Platinum");
  //QStyle* windowsxp = QStyleFactory::create("WindowsXP"); crashes...

  QStyle* style = QApplication::setStyle( "Platinum" );
#endif

  QApplication* app = 0;
  try
  {
    setLocale();
    
    // init stacktrace
    initStackProcess();

    // init apr
    apr::initialize(argc,argv);

    // init target repository
    TargetRepository::setup();

    // init qt
    app = new QApplication( argc, argv );
    setAppName("subcommander");

    // redirect qDebug etc.
    installMessageHandler();

#if !defined(Q_WS_X11)
    QApplication::setStyle( new MacStyle() );
#endif // Q_WS_X11

    // about dialog
    setNeonVersion( ne_version_string() );
  }
  catch( sc::Exception& e )
  {
    // no way to bring up a dialog if something went wrong
    // in the basic initialization.

    fprintf( stderr, e.getError()->getMessage() );
    return EXIT_FAILURE;
  }

  try
  {
    // read config
    ConfigManager config;
    config.load();

    // set font
    // if we set the font allthough it is the same font as the default (system) font
    // we get a different font in popup menus. Looks like a bug in Qt 3.
    if( qApp->font() != config.getGeneralFont() )
    {
      QApplication::setFont( config.getGeneralFont() );
    }

    // adjust locale path
    setLocalePath( config.getL10n() ? app->applicationDirPath() : "/no_l10n" );

    // set the working copy admin directory name
    svn::setAspDotNetAdmDir( config.getAspDotNetHack() );

    // setup main model
    ScModel model( &config );

    // setup gui
    MainWindow* mw = new MainWindow(&model,&config);
    qApp->setMainWidget(mw);

    // run gui
    mw->show();
    mw->runWcAutoUpdate();
    long result = app->exec();

    delete mw;
    delete app;

    config.save();

    exit_ssl();
    exit_neon();

    TargetRepository::teardown();
    stopStackProcess();

    return result;
  }
  catch( sc::Exception& e )
  {
    ErrorDialog* dlg = new ErrorDialog( e );
    dlg->exec();

    return EXIT_FAILURE;
  }
}


#if 0
// boost
#include <boost/function.hpp>
#include <boost/bind.hpp>

typedef boost::function<void (int, int)> callback_t; 

class foo
{
public:
  void callback( int a, int b )
  {
    int y = a + b;
  }
};

class bar
{
public:
  void callthecallback( boost::function<void (int, int)> cb )
  {
    cb( 1, 2 );
  }

  void callthecallback2( callback_t cb )
  {
    cb( 1, 2 );
  }
};

void x( int a, int b )
{
  int y = a + b;
}

  bar b;
  foo f;

  b.callthecallback( x );
  b.callthecallback( boost::bind(foo::callback,&f,_1,_2) );
#endif
