/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TOOLSSETTINGSINFO_H
#define _SC_TOOLSSETTINGSINFO_H

// sc
#include "sublib/settings/SettingsInfoBase.h"
#include "util/String.h"
class ToolsSettings;
class SettingsWidget;

// qt
#include <qstring.h>


class ToolsSettingsInfo : public SettingsInfoBase
{
public:
  ToolsSettingsInfo( const QString& title, const QString& id, ToolsSettings* ts, int sortIndex );
  ~ToolsSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString       _title;
  QString       _id;

  int           _sortIndex;

  ToolsSettings* _ts;

  sc::String     _diffCmd;
  sc::String     _mergeCmd;
};


#endif //  _SC_TOOLSSETTINGSINFO_H
