/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_IMPORTPARAM_H
#define _SC_IMPORTPARAM_H

// sc
#include "ScParam.h"
#include "svn/CommitInfo.h"
#include "util/String.h"


/**
 * Parameter class for ImportCmd.
 */
class ImportParam : public ScParam
{
public:
  /**
   * construct a ImportParam object.
   */
  ImportParam( const sc::String& path, const sc::String& url, bool recurse )
    : _url(url), _path(path), _recurse(recurse)
  {
  }

  ~ImportParam()
  {
  }

  const sc::String& getUrl() const
  {
    return _url;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(ImportParam);

private:
  // in
  sc::String           _url;
  sc::String           _path;
  bool                 _recurse;

  // out
  svn::CommitInfo       _info;
};

#endif // _SC_CHECKOUTPARAM_H
