/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CheckoutDialog.h"
#include "RevisionWidget.h"
#include "ExternProvider.h"
#include "sublib/Gui.h"
#include "sublib/ExternButton.h"
#include "util/String.h"

// qt
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qtooltip.h>
#include <qcheckbox.h>



CheckoutDialog::CheckoutDialog( ExternProvider* p, bool recurse, bool add,
  QWidget *parent )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _p(p)
{
  setCaption( _q("subcommander:checkout") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("checkout options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,2,3);
    gl->setMargin(0);
    gl->setRowStretch( 1, 1 );
    {
      {
        QLabel* l = new QLabel(this);
        _rep      = new QComboBox(this);
        _repEx    = new ExternButton(this);

        l->setBuddy(_rep);
        l->setText( _q("&repository url:") );
        _rep->setEditable(true);
        _rep->setAutoCompletion(true);
        //_rep->setInsertionPolicy( QComboBox::AtCurrent ); hmm, does not work?

        gl->addWidget(l,0,0);
        gl->addWidget(_rep,0,1); 
        gl->addWidget(_repEx,0,2); 

        connect( _rep, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _rep, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _rep, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _repEx, SIGNAL(clicked()), SLOT(repExtern()) );

        QToolTip::add( _rep, _q("the repository folder you like to checkout") );
      }
      {
        QLabel* l = new QLabel(this);
        _wc       = new QComboBox(this);
        _wcEx     = new ExternButton(this);

        l->setBuddy(_wcEx);
        l->setText( _q("&working copy path:") );
        l->setFixedWidth( l->sizeHint().width() );
        _wc->setEditable(true);
        _wc->setAutoCompletion(true);

        gl->addWidget(l,1,0);
        gl->addWidget(_wc,1,1); 
        gl->addWidget(_wcEx,1,2); 

        connect( _wc, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        connect( _wcEx, SIGNAL(clicked()), SLOT(selectWcPath()) );

        QToolTip::add( _wc, _q("the local folder where you like to place the checkout") );
      }
    }

    QHBoxLayout* h1 = new QHBoxLayout;
    h1->setAlignment(Qt::AlignTop);
    vbl->addLayout(h1);
    {
      _rwPeg = new RevisionWidget(true,"NDS","H",0,this);
      _rwPeg->setTitle(_q("peg revision: "));

      _rw    = new RevisionWidget(false,"SDN","H",0,this);

      h1->addWidget( _rwPeg );
      h1->addWidget( _rw );
    }

    QHBoxLayout* h2 = new QHBoxLayout;
    h2->setAlignment(Qt::AlignTop);
    vbl->addLayout(h2);
    {
      _recurse = new QCheckBox(_q("&recursive"),this);
      _recurse->setChecked(recurse);

      _autoAdd = new QCheckBox(_q("&add to project"),this);
      _autoAdd->setChecked(add);

      if( ! add )
      {
        _autoAdd->setDisabled(true);
      }

      h2->addWidget(_recurse);
      h2->addWidget(_autoAdd);
      h2->addStretch(1);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      _ca = new QPushButton(this);
      _ca->setText( _q("&Cancel") );
      hu->addWidget(_ca);

      hu->addSpacing(getSizeGripSpacing());
      
      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( _ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

CheckoutDialog::~CheckoutDialog()
{
}

void CheckoutDialog::selectWcPath()
{
  sc::String res;

  if( _p->selectPath( this, sc::String(_wc->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _wc->insertItem( QString::fromUtf8(res), 0 );
  }
}

void CheckoutDialog::setRepositoryUrl( const QString& url )
{
  _rep->insertItem( url, 0 );
}

QString CheckoutDialog::getRepositoryUrl()
{
  return _rep->currentText();
}

void CheckoutDialog::setWorkingCopyPath( const QString& path )
{
  _wc->insertItem( path, 0 );
}

QString CheckoutDialog::getWorkingCopyPath()
{
  return _wc->currentText();
}

svn::Revision* CheckoutDialog::getRevision()
{
  return _rw->getRevision();
}

svn::Revision* CheckoutDialog::getPegRevision()
{
  return _rwPeg->getRevision();
}

bool CheckoutDialog::isRecursive()
{
  return _recurse->isChecked();
}

bool CheckoutDialog::isAddToProject()
{
  return _autoAdd->isChecked();
}

void CheckoutDialog::enableRepositoryUrl( bool enable )
{
  _rep->setEnabled(enable);
}

void CheckoutDialog::enableWorkingCopyPath( bool enable )
{
  _wc->setEnabled(enable);
  _wcEx->setEnabled(enable);
}

void CheckoutDialog::checkOk( const QString& text )
{
  QString rep = _rep->currentText();
  QString wc  = _wc->currentText();

  if( ! rep.isEmpty() && ! wc.isEmpty()  )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }

  if( ! rep.isEmpty() && _rep->isEnabled() )
  {
    _repEx->setEnabled(true);
  }
  else
  {
    _repEx->setEnabled(false);
  }
}

void CheckoutDialog::repExtern()
{
  handleExtern(_rep);
}

void CheckoutDialog::handleExtern( QComboBox* e )
{
  sc::String res;

  if( _p->selectUrl( this, sc::String(e->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    e->setCurrentText(QString::fromUtf8(res));
    //e->insertItem( QString::fromUtf8(res) );
  }
}
