
/**
 * <p>Class OWLContainer - A Container item that holds different OWLItems</p>
 */


/**
 * <p>flag for type equivalence</p>
 */
    public constant is_container=1; 

/**
 * <p>The iterator for this container</p>
 */
    private int iterator = -1;
   
/**
 * <p>the array  holding the OWLItems</p>
 */
    public array container = ({});


/**
 * <p>Add a OWLItem to this container</p>
 * 
 * 
 * @param item  - OWLItem to add
 */
    public void add(Visconte.Onto.Item.OWLItem owlitem) {        
	    container+=({owlitem});
	    iterator=0;
    } 

/**
 * <p>Returns the next OWLItem in the container and pushes the iterator</p>
 * 
 * 
 * @return OWLItem - which comes next
 */
    public Visconte.Onto.Item.OWLItem next() 
    {        
         Visconte.Onto.Item.OWLItem current_item; 
	 if(iterator>=0 && iterator <sizeof(container))
	 {
		current_item = container[iterator];
		iterator++;
	 }
	 else
	 {
		iterator=0;
		current_item = container[iterator];
		iterator++;
	 }
	 
	return 	current_item;
		
    } 

/**
 * <p>Checks if the container has more items</p>
 * 
 * 
 * @return 
 */
    public int has_items() 
    {        
         if(iterator>=0 && iterator <sizeof(container))
	 {
		 return 1;
	 }
	 else
	 {
		 return 0;
	 }
    } 

    
/**
 * <p>Find a OWLItem in the container</p>
 * @param id - the id of the owlitem to find
 * 
 * @return OWLItem
 */
    public Visconte.Onto.Item.OWLItem find_by_id(string id) 
    {  
	Visconte.Onto.Item.OWLItem item; 
	foreach (container,Visconte.Onto.Item.OWLItem tmp_item)
	{
		if(tmp_item->get_Id()==id)
		{
			item = tmp_item;
			break;
		}
	}
	return item;
    }
    
    
/**
 * <p>Prints a String with the content of the container</p>
 * 
 * 
 * @return the string dump
 */
    public string to_string() 
    {
	    string content ="\nContent of OWLContainer:\n";
	    foreach(container,Visconte.Onto.Item.OWLItem i)
		    content+="\nItem id:"+i->get_Id()+", label:"+i->get_Label();
	    
	    return content+"\n";
    }


/**
 * <p>Return the size of the container</p>
 * 
 * 
 * @return size as int
 */
    public int size_of() 
    {
	    return sizeof(container);
    }

/**
 * <p>Resets the iterator manuall</p>
 * 
 * 
 * @return 
 */
    public void reset_iterator() 
    {
	    if(sizeof(container)>0)
		   iterator=0;
	    else
		   iterator=-1;
    }
    
/**
 * <p>merges another OWLContainer with this one. Duplicates will be ommited </p>
 * @param merge_container - the OWLContainer to merge
 * 
 * @return succes
 */
    public int merge(object merge_container) 
    {    
	    
	    if(merge_container && merge_container->is_container)
	    { 
		    foreach(merge_container->container,Visconte.Onto.Item.OWLItem tmp_item)
		    {
			    if(!find_by_id(tmp_item->get_Id()))
				    container+=({tmp_item});
		    }
		    return 1;
	    }
	    else
		    return 0;
    }
    
    
    
    
    
