message("-- Checking for libgee...")
pkg_check_modules(GEE gee-1.0)
message("-- Checking for libnotify >= 0.7...")
pkg_check_modules(LIBNOTIFY libnotify>=0.7)

if(GEE_FOUND)
    set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${GEE_INCLUDE_DIRS})
    set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${GEE_CFLAGS_OTHER})
    set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${GEE_LDFLAGS})
else()
    message(FATAL_ERROR "libgee not found")
endif()

if(LIBNOTIFY_FOUND)
    set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${LIBNOTIFY_INCLUDE_DIRS})
    set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${LIBNOTIFY_CFLAGS_OTHER})
    set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${LIBNOTIFY_LDFLAGS})
else()
    message(FATAL_ERROR "libnotify not found")
endif()

if(WANT_AYATANA)
	message("-- Checking for libappindicator3...")
	pkg_check_modules(APPINDICATOR appindicator3-0.1)
	
	if(APPINDICATOR_FOUND)
		set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${APPINDICATOR_INCLUDE_DIRS})
		set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${APPINDICATOR_CFLAGS_OTHER})
		set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${APPINDICATOR_LDFLAGS})
	endif()
endif()
