
/* $Id: phonebook.c,v 400.1 2002/07/25 08:43:16 sgifford Exp $ */

#include "phonebook.h"
#include "stdebug.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

struct startalk_phonebook_phonenum *
startalk_new_phonebook_phonenum(int type, char *num)
{
  struct startalk_phonebook_phonenum *n;

  n = malloc(sizeof(struct startalk_phonebook_phonenum));
  if (!n)
    die("Malloc error.");
  n->type = type;
  strncpy(n->num,num,32);
  n->num[32]='\0';

  return n;
}  

void
startalk_delete_phonebook_phonenum(struct startalk_phonebook_phonenum *d)
{
  free(d);
}

struct startalk_phonebook_entry *
startalk_new_phonebook_entry(void)
{
  struct startalk_phonebook_entry *n;

  n = malloc(sizeof(struct startalk_phonebook_entry));
  if (!n)
    return (void *) reterr(0,"malloc error:");
  n->name[0]=n->company[0]=n->email[0]=n->numphones=0;
  n->pos = -1;

  return n;
}

void
startalk_delete_phonebook_entry(struct startalk_phonebook_entry *d)
{
  int i;

  for(i=0;i<d->numphones;i++)
  {
    startalk_delete_phonebook_phonenum(d->phone[i]);
  }
  free(d);
}

struct startalk_phonebook *
startalk_new_phonebook(void)
{
  int i;
  struct startalk_phonebook *n;

  n = malloc(sizeof(struct startalk_phonebook));
  if (!n)
    die("Malloc error.");

  for(i=0;i<STARTALK_PHONEBOOK_MAX;i++)
  {
    n->entry[i]=NULL;
  }

  return n;
}

void
startalk_delete_phonebook(struct startalk_phonebook *d)
{
  int i;
  
  for(i=0;i<STARTALK_PHONEBOOK_MAX;i++)
  {
    if (d->entry[i])
      startalk_delete_phonebook_entry(d->entry[i]);
  }
  free(d);
}

int
startalk_add_phonestruct_to_entry(struct startalk_phonebook_entry *e, struct startalk_phonebook_phonenum *p)
{
  if (e->numphones >= 4)
    return 0;
  e->phone[e->numphones] = p;
  e->numphones++;

  return 1;
}

int
startalk_add_phone_to_entry(struct startalk_phonebook_entry *e, int type, char *num)
{
  struct startalk_phonebook_phonenum *p;

  p=startalk_new_phonebook_phonenum(type,num);

  return startalk_add_phonestruct_to_entry(e,p);
}

void
startalk_fprint_phonebook_phonenum(FILE *f, struct startalk_phonebook_phonenum *p)
{
  char typename[10];

  switch(p->type)
  {
    case 0: strcpy(typename,"none?"); break;
    case 1: strcpy(typename,"office"); break;
    case 2: strcpy(typename,"home"); break;
    case 3: strcpy(typename,"mobile"); break;
    case 4: strcpy(typename,"pager"); break;
    case 5: strcpy(typename,"fax"); break;
    case 6: strcpy(typename,"qmark"); break;
    default: sprintf(typename,"other%d",p->type); break;
  }
  fprintf(f,"phone-%s: %s\n",typename,p->num);
}

void
startalk_print_phonebook_phonenum(struct startalk_phonebook_phonenum *p)
{
  startalk_fprint_phonebook_phonenum(stdout, p);
}

void
startalk_fprint_phonebook_entry(FILE *f, struct startalk_phonebook_entry *e)
{
  int i;

  if (e->pos != -1)
    fprintf(f,"position: %d\n",e->pos);
  if (e->name[0])
    fprintf(f,"name: %s\n",e->name);
  if (e->company[0])
    fprintf(f,"company: %s\n",e->company);
  if (e->email[0])
    fprintf(f,"email: %s\n",e->email);
  for(i=0;i<e->numphones;i++)
    startalk_fprint_phonebook_phonenum(f,e->phone[i]);
  fprintf(f,"\n");
}

void
startalk_print_phonebook_entry(struct startalk_phonebook_entry *e)
{
  startalk_fprint_phonebook_entry(stdout, e);
}

void
startalk_empty_phonebook_entry(struct startalk_phonebook_entry *e)
{
  e->pos = e->name[0] = e->company[0] = e->email[0] = e->numphones = 0;
}

int
startalk_phonebook_entry_is_empty(struct startalk_phonebook_entry *e)
{
  return !(e->name[0] || e->company[0] || e->email[0] || e->numphones);
}
