#include "header.h"

int mkdir_p(const char *s,mode_t mode) {
    struct stat st;
    gchar *dir,*c;

    dbg("mkdir_p '%s'\n", s);

    if (!stat(s,&st))
        if (S_ISDIR(st.st_mode)) return(0);

    dir = g_strdup(s);
    c=strrchr(dir,'/');
    if (c==NULL) {
        g_free(dir);
        return(-1);
    }
    *c='\0';
    if (strlen(dir)==0) {
        g_free(dir);
        return(-1);
    }
    mkdir_p(dir,mode);
    g_free(dir);
    return(mkdir(s,mode));
}

int fmkdir_p(const char *filename, mode_t mode){
    gchar *dir,*d;
    int ret;
    
    dbg("fmkdir_p '%s'\n", filename);
    dir=g_strdup(filename);
    d=strrchr(dir,'/');
    ret=-1;
    if (d){
        *d='\0';
        ret=mkdir_p(dir,mode);
    }
    g_free(dir);
    return ret;
}


/* convert $XX to string */

/* /home/ja/ssbd/tmp/rec/$N_%Y%m%d_%H%M%S.wav */
#define SFT_LEN 1024
gchar *convert_esc(gchar *format, int flags){
    GString *gs;
    char *c,*s;
    gchar *ret;
    time_t now;
    struct tm *utc;
    char sft_buf[SFT_LEN+1];

    time(&now);
    utc = gmtime(&now);
    if (!format) format="";
    strftime(sft_buf, SFT_LEN, format, utc);    
    
    gs = g_string_new("");
    if (flags&CE_ONLY_STRFTIME){
        g_string_append(gs, sft_buf); 
        goto x;
    }
    
    s=sft_buf; 
    for (c=s; *c!='\0'; c++){
        if (*c=='~' && c==s){
            g_string_append(gs, getenv("HOME"));
            continue;
        }
        if (*c!='$') {
            g_string_append_c(gs, *c);
            continue;
        }
        c++;
        switch (tolower(*c)){
            case '\0':
                goto brk2;
                break;
            case 'v':
                if (cfg->callsign) g_string_append(gs, cfg->callsign);
                break;    
            case 's':
                g_string_sprintfa(gs, "%d", cfg->serno);
                break;    
        }        
brk2:;        
    }
x:;    
    
    ret = gs->str;
    g_string_free(gs, FALSE);
    
    return ret;
}

gchar *unique_filename(gchar *filename){
    struct stat st;
    int ser;
    gchar *file, *ext, *c;
    char *c1, *c2, *c3;

    c1=c2=c3=NULL;
    if (stat(filename, &st)) return filename; /* filename doesn't exist */
    
    if (regmatch(filename, "(.*)(\\..*)", &c1, &c2, &c3, NULL)==0){
        file=g_strdup(c2);
        ext=g_strdup(c3);
        g_free(filename);
    }else{
        file=filename;
        ext=g_strdup("");
    }
    if (c1) mem_free(c1);
    if (c2) mem_free(c2);
    if (c3) mem_free(c3);
    
    c=NULL;
    for (ser=1; ;ser++){
        dbg("file='%s'  ext='%s'\n", file, ext);
        c=g_strdup_printf("%s%d%s", file, ser, ext);
        dbg("c='%s'\n", c);
        if (stat(c, &st)){ /* c doesn't exist */
            break;
        }
        g_free(c);
    }
    return c;
}
